/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand;

import java.util.ArrayList;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyUpdatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalAbstractStaticCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalAbstractAutoHandler;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.PrimaryKeyNotFoundRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.exception.SRuntimeException;

public abstract class InternalAbstractAutoStaticCommand
extends InternalAbstractStaticCommand {
    protected static final boolean DEFAULT_VERSION_NO_AUTO_INCREMENT_ON_MEMORY = true;
    private PropertyType[] propertyTypes;
    private boolean checkSingleRowUpdate = true;
    protected boolean versionNoAutoIncrementOnMemory = true;

    public InternalAbstractAutoStaticCommand(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, String[] propertyNames) {
        this(dataSource, statementFactory, beanMetaData, propertyNames, true);
    }

    public InternalAbstractAutoStaticCommand(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, String[] propertyNames, boolean versionNoAutoIncrementOnMemory) {
        super(dataSource, statementFactory, beanMetaData);
        this.versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
        this.setupPropertyTypes(propertyNames);
        this.setupSql();
    }

    public Object execute(Object[] args) {
        InternalAbstractAutoHandler handler = this.createAutoHandler();
        handler.setSql(this.getSql());
        handler.setLoggingMessageSqlArgs(args);
        int rows = handler.execute(args);
        if (this.isCheckSingleRowUpdate() && rows != 1) {
            throw this.createNotSingleRowUpdatedRuntimeException(args[0], rows);
        }
        return new Integer(rows);
    }

    public boolean isCheckSingleRowUpdate() {
        return this.checkSingleRowUpdate;
    }

    public void setCheckSingleRowUpdate(boolean checkSingleRowUpdate) {
        this.checkSingleRowUpdate = checkSingleRowUpdate;
    }

    protected NotSingleRowUpdatedRuntimeException createNotSingleRowUpdatedRuntimeException(Object bean, int rows) {
        return new EntityAlreadyUpdatedException(bean, rows);
    }

    protected PropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    protected void setPropertyTypes(PropertyType[] propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    protected abstract InternalAbstractAutoHandler createAutoHandler();

    protected abstract void setupPropertyTypes(String[] var1);

    protected void setupInsertPropertyTypes(String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        int i = 0;
        while (i < propertyNames.length) {
            PropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (this.isInsertTarget(pt)) {
                types.add(pt);
            }
            ++i;
        }
        this.propertyTypes = types.toArray(new PropertyType[types.size()]);
    }

    protected boolean isInsertTarget(PropertyType propertyType) {
        if (propertyType.isPrimaryKey()) {
            String name = propertyType.getPropertyName();
            IdentifierGenerator generator = this.getBeanMetaData().getIdentifierGenerator(name);
            return generator.isSelfGenerate();
        }
        return true;
    }

    protected void setupUpdatePropertyTypes(String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        int i = 0;
        while (i < propertyNames.length) {
            PropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (!pt.isPrimaryKey()) {
                types.add(pt);
            }
            ++i;
        }
        if (types.size() == 0) {
            throw new SRuntimeException("EDAO0020");
        }
        this.propertyTypes = types.toArray(new PropertyType[types.size()]);
    }

    protected void setupDeletePropertyTypes(String[] propertyNames) {
    }

    protected abstract void setupSql();

    protected void setupInsertSql() {
        PropertyType pt;
        BeanMetaData bmd = this.getBeanMetaData();
        StringBuilder sb = new StringBuilder(100);
        sb.append("insert into ");
        sb.append(bmd.getTableName());
        sb.append(" (");
        int i = 0;
        while (i < this.propertyTypes.length) {
            pt = this.propertyTypes[i];
            if (this.isInsertTarget(pt)) {
                sb.append(pt.getColumnName());
                sb.append(", ");
            }
            ++i;
        }
        sb.setLength(sb.length() - 2);
        sb.append(") values (");
        i = 0;
        while (i < this.propertyTypes.length) {
            pt = this.propertyTypes[i];
            if (this.isInsertTarget(pt)) {
                sb.append("?, ");
            }
            ++i;
        }
        sb.setLength(sb.length() - 2);
        sb.append(")");
        this.setSql(sb.toString());
    }

    protected void setupUpdateSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(100);
        sb.append("update ");
        sb.append(this.getBeanMetaData().getTableName());
        sb.append(" set ");
        String versionNoPropertyName = this.getBeanMetaData().getVersionNoPropertyName();
        int i = 0;
        while (i < this.propertyTypes.length) {
            PropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName) && !this.versionNoAutoIncrementOnMemory) {
                sb.append(pt.getColumnName()).append(" = ").append(pt.getColumnName()).append(" + 1, ");
            } else {
                sb.append(pt.getColumnName()).append(" = ?, ");
            }
            ++i;
        }
        sb.setLength(sb.length() - 2);
        this.setupUpdateWhere(sb);
        this.setSql(sb.toString());
    }

    protected void setupDeleteSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(100);
        sb.append("delete from ");
        sb.append(this.getBeanMetaData().getTableName());
        this.setupUpdateWhere(sb);
        this.setSql(sb.toString());
    }

    protected void checkPrimaryKey() {
        BeanMetaData bmd = this.getBeanMetaData();
        if (bmd.getPrimaryKeySize() == 0) {
            throw new PrimaryKeyNotFoundRuntimeException(bmd.getBeanClass());
        }
    }

    protected void setupUpdateWhere(StringBuilder sb) {
        BeanMetaData bmd = this.getBeanMetaData();
        sb.append(" where ");
        int i = 0;
        while (i < bmd.getPrimaryKeySize()) {
            sb.append(bmd.getPrimaryKey(i)).append(" = ? and ");
            ++i;
        }
        sb.setLength(sb.length() - 5);
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
    }
}

