/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand;

import java.util.ArrayList;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalInsertAutoHandler;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.exception.SRuntimeException;

public class InternalInsertAutoDynamicCommand
implements SqlCommand {
    protected DataSource dataSource;
    protected StatementFactory statementFactory;
    protected BeanMetaData beanMetaData;
    protected String[] propertyNames;
    protected boolean checkSingleRowUpdate = true;

    public Object execute(Object[] args) {
        Object bean = args[0];
        BeanMetaData bmd = this.getBeanMetaData();
        PropertyType[] propertyTypes = this.createInsertPropertyTypes(bmd, bean, this.getPropertyNames());
        String sql = this.createInsertSql(bmd, propertyTypes);
        InternalInsertAutoHandler handler = new InternalInsertAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        handler.setSql(sql);
        handler.setLoggingMessageSqlArgs(args);
        int rows = handler.execute(args);
        if (this.isCheckSingleRowUpdate() && rows != 1) {
            throw new NotSingleRowUpdatedRuntimeException(args[0], rows);
        }
        return new Integer(rows);
    }

    protected String createInsertSql(BeanMetaData bmd, PropertyType[] propertyTypes) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("insert into ");
        buf.append(bmd.getTableName());
        buf.append(" (");
        int i = 0;
        while (i < propertyTypes.length) {
            PropertyType pt = propertyTypes[i];
            String columnName = pt.getColumnName();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(columnName);
            ++i;
        }
        buf.append(") values (");
        i = 0;
        while (i < propertyTypes.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("?");
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    protected PropertyType[] createInsertPropertyTypes(BeanMetaData bmd, Object bean, String[] propertyNames) {
        if (propertyNames.length == 0) {
            throw new SRuntimeException("EDAO0024", new Object[]{bean.getClass().getName()});
        }
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        int i = 0;
        while (i < propertyNames.length) {
            String propertyName;
            IdentifierGenerator generator;
            PropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (!(pt.isPrimaryKey() ? !(generator = bmd.getIdentifierGenerator(pt.getPropertyName())).isSelfGenerate() : pt.getPropertyDesc().getValue(bean) == null && !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName))) {
                types.add(pt);
            }
            ++i;
        }
        if (types.isEmpty()) {
            throw new SRuntimeException("EDAO0014");
        }
        PropertyType[] propertyTypes = types.toArray(new PropertyType[types.size()]);
        return propertyTypes;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(BeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    protected String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public boolean isCheckSingleRowUpdate() {
        return this.checkSingleRowUpdate;
    }

    public void setCheckSingleRowUpdate(boolean checkSingleRowUpdate) {
        this.checkSingleRowUpdate = checkSingleRowUpdate;
    }
}

