/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand;

import java.util.ArrayList;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalUpdateAutoHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.NoUpdatePropertyTypeRuntimeException;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;

public class InternalUpdateAutoDynamicCommand
extends AbstractSqlCommand {
    private static final Log _log = LogFactory.getLog(InternalUpdateAutoDynamicCommand.class);
    private static final Integer NO_UPDATE = new Integer(0);
    private BeanMetaData beanMetaData;
    private String[] propertyNames;
    private boolean checkSingleRowUpdate = true;
    private boolean versionNoAutoIncrementOnMemory = true;

    public InternalUpdateAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    public Object execute(Object[] args) {
        Object bean = args[0];
        BeanMetaData bmd = this.getBeanMetaData();
        PropertyType[] propertyTypes = this.createUpdatePropertyTypes(bmd, bean, this.getPropertyNames());
        if (propertyTypes.length == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)this.createNoUpdateLogMessage(bean, bmd));
            }
            return NO_UPDATE;
        }
        InternalUpdateAutoHandler handler = this.createInternalUpdateAutoHandler(bmd, propertyTypes);
        handler.setSql(this.createUpdateSql(bmd, propertyTypes, bean));
        handler.setLoggingMessageSqlArgs(args);
        int i = handler.execute(args);
        return new Integer(i);
    }

    protected InternalUpdateAutoHandler createInternalUpdateAutoHandler(BeanMetaData bmd, PropertyType[] propertyTypes) {
        InternalUpdateAutoHandler handler = new InternalUpdateAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        handler.setVersionNoAutoIncrementOnMemory(this.versionNoAutoIncrementOnMemory);
        handler.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate());
        return handler;
    }

    protected PropertyType[] createUpdatePropertyTypes(BeanMetaData bmd, Object bean, String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        int i = 0;
        while (i < propertyNames.length) {
            String propertyName;
            PropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (!pt.isPrimaryKey() && ((propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) || propertyName.equalsIgnoreCase(versionNoPropertyName) || pt.getPropertyDesc().getValue(bean) != null)) {
                types.add(pt);
            }
            ++i;
        }
        if (types.isEmpty()) {
            throw new NoUpdatePropertyTypeRuntimeException();
        }
        PropertyType[] propertyTypes = types.toArray(new PropertyType[types.size()]);
        return propertyTypes;
    }

    protected String createNoUpdateLogMessage(Object bean, BeanMetaData bmd) {
        StringBuffer sb = new StringBuffer();
        sb.append("skip UPDATE: table=").append(bmd.getTableName());
        int size = bmd.getPrimaryKeySize();
        int i = 0;
        while (i < size) {
            if (i == 0) {
                sb.append(", key{");
            } else {
                sb.append(", ");
            }
            String keyName = bmd.getPrimaryKey(i);
            sb.append(keyName).append("=");
            sb.append(bmd.getPropertyTypeByColumnName(keyName).getPropertyDesc().getValue(bean));
            if (i == size - 1) {
                sb.append("}");
            }
            ++i;
        }
        String s = new String(sb);
        return s;
    }

    /*
     * Unable to fully structure code
     */
    protected String createUpdateSql(BeanMetaData bmd, PropertyType[] propertyTypes, Object bean) {
        if (bmd.getPrimaryKeySize() == 0) {
            msg = "The table '" + bmd.getTableName() + "' does not have primary keys!";
            throw new IllegalStateException(msg);
        }
        sb = new StringBuilder(100);
        sb.append("update ");
        sb.append(bmd.getTableName());
        sb.append(" set ");
        versionNoPropertyName = bmd.getVersionNoPropertyName();
        i = 0;
        while (i < propertyTypes.length) {
            pt = propertyTypes[i];
            columnName = pt.getColumnName();
            if (i > 0) {
                sb.append(", ");
            }
            if (!pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) ** GOTO lbl-1000
            if (!this.isVersionNoAutoIncrementOnMemory()) {
                this.setupVersionNoAutoIncrementOnQuery(sb, columnName);
            } else {
                versionNo = pt.getPropertyDesc().getValue(bean);
                if (versionNo == null) {
                    this.setupVersionNoAutoIncrementOnQuery(sb, columnName);
                } else lbl-1000:
                // 2 sources

                {
                    sb.append(columnName).append(" = ?");
                }
            }
            ++i;
        }
        sb.append(" where ");
        i = 0;
        while (i < bmd.getPrimaryKeySize()) {
            sb.append(bmd.getPrimaryKey(i)).append(" = ? and ");
            ++i;
        }
        sb.setLength(sb.length() - 5);
        if (bmd.hasVersionNoPropertyType()) {
            pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
        if (bmd.hasTimestampPropertyType()) {
            pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
        return sb.toString();
    }

    protected boolean isVersionNoAutoIncrementOnMemory() {
        return this.versionNoAutoIncrementOnMemory;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this.versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }

    protected void setupVersionNoAutoIncrementOnQuery(StringBuilder sb, String columnName) {
        sb.append(columnName).append(" = ").append(columnName).append(" + 1");
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(BeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public boolean isCheckSingleRowUpdate() {
        return this.checkSingleRowUpdate;
    }

    public void setCheckSingleRowUpdate(boolean resultCheck) {
        this.checkSingleRowUpdate = resultCheck;
    }
}

