/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlparser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.MapParameterBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.LikeSearchOption;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.BindVariableCommentNotFoundPropertyException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.BindVariableParameterNullValueException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EmbeddedValueCommentNotFoundPropertyException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EmbeddedValueParameterNullValueException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EndCommentNotFoundException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.IfCommentConditionNotFoundException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.IfCommentNotBooleanResultException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.IfCommentWrongExpressionException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.RequiredOptionNotFoundException;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlparser.InternalCommandContextCreator;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlparser.InternalSqlTokenizer;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.util.InternalBindVariableUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleStringUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.node.AbstractNode;
import org.seasar.dao.node.BeginNode;
import org.seasar.dao.node.ContainerNode;
import org.seasar.dao.node.ElseNode;
import org.seasar.dao.node.PrefixSqlNode;
import org.seasar.dao.node.SqlNode;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.OgnlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSqlParser {
    protected InternalSqlTokenizer tokenizer;
    protected Stack<Node> nodeStack = new Stack();
    protected String specifiedSql;

    public InternalSqlParser(String sql) {
        sql = sql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this.specifiedSql = sql;
        this.tokenizer = new InternalSqlTokenizer(sql);
    }

    public Node parse() {
        this.push((Node)new ContainerNode());
        while (99 != this.tokenizer.next()) {
            this.parseToken();
        }
        return this.pop();
    }

    protected void parseToken() {
        switch (this.tokenizer.getTokenType()) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
            }
        }
    }

    protected void parseSql() {
        Node node;
        String sql = this.tokenizer.getToken();
        if (this.isElseMode()) {
            sql = InternalStringUtil.replace(sql, "--", "");
        }
        if (((node = this.peek()) instanceof InternalIfNode || node instanceof ElseNode) && node.getChildSize() == 0) {
            InternalSqlTokenizer st = new InternalSqlTokenizer(sql);
            st.skipWhitespace();
            String token = st.skipToken();
            st.skipWhitespace();
            if (sql.startsWith(",")) {
                if (sql.startsWith(", ")) {
                    node.addChild((Node)new PrefixSqlNode(", ", sql.substring(2)));
                } else {
                    node.addChild((Node)new PrefixSqlNode(",", sql.substring(1)));
                }
            } else if ("AND".equalsIgnoreCase(token) || "OR".equalsIgnoreCase(token)) {
                node.addChild((Node)new PrefixSqlNode(st.getBefore(), st.getAfter()));
            } else {
                node.addChild((Node)new SqlNode(sql));
            }
        } else {
            node.addChild((Node)new SqlNode(sql));
        }
    }

    protected void parseComment() {
        String comment = this.tokenizer.getToken();
        if (InternalSqlParser.isTargetComment(comment)) {
            if (InternalSqlParser.isIfComment(comment)) {
                this.parseIf();
            } else if (InternalSqlParser.isBeginComment(comment)) {
                this.parseBegin();
            } else {
                if (InternalSqlParser.isEndComment(comment)) {
                    return;
                }
                this.parseCommentBindVariable();
            }
        } else if (comment != null && comment.length() > 0) {
            String before = this.tokenizer.getBefore();
            this.peek().addChild((Node)new SqlNode(before.substring(before.lastIndexOf("/*"))));
        }
    }

    protected void parseIf() {
        String condition = this.tokenizer.getToken().substring(2).trim();
        if (InternalStringUtil.isEmpty(condition)) {
            this.throwIfCommentConditionNotFoundException();
        }
        ContainerNode ifNode = this.createIfNode(condition);
        this.peek().addChild((Node)ifNode);
        this.push((Node)ifNode);
        this.parseEnd();
    }

    protected void throwIfCommentConditionNotFoundException() {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The condition of IF comment was Not Found!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the IF comment expression." + this.getLineSeparator();
        msg = String.valueOf(msg) + "It may exist the IF comment that DOESN'T have a condition." + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    before (x) -- /*IF*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[IF Comment Expression]" + this.getLineSeparator() + this.tokenizer.getToken() + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Specified SQL]" + this.getLineSeparator() + this.specifiedSql + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new IfCommentConditionNotFoundException(msg);
    }

    protected void parseBegin() {
        BeginNode beginNode = new BeginNode();
        this.peek().addChild((Node)beginNode);
        this.push((Node)beginNode);
        this.parseEnd();
    }

    protected void parseEnd() {
        while (99 != this.tokenizer.next()) {
            if (this.tokenizer.getTokenType() == 2 && InternalSqlParser.isEndComment(this.tokenizer.getToken())) {
                this.pop();
                return;
            }
            this.parseToken();
        }
        this.throwEndCommentNotFoundException();
    }

    protected void throwEndCommentNotFoundException() {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The end comment was Not Found!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the parameter comment logic." + this.getLineSeparator();
        msg = String.valueOf(msg) + "It may exist the parameter comment that DOESN'T have an end comment." + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    before (x) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Specified SQL]" + this.getLineSeparator() + this.specifiedSql + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new EndCommentNotFoundException(msg);
    }

    protected void parseElse() {
        Node parent = this.peek();
        if (!(parent instanceof InternalIfNode)) {
            return;
        }
        InternalIfNode ifNode = (InternalIfNode)this.pop();
        InternalElseNode elseNode = new InternalElseNode();
        ifNode.setElseNode(elseNode);
        this.push((Node)elseNode);
        this.tokenizer.skipWhitespace();
    }

    protected void parseCommentBindVariable() {
        String expr = this.tokenizer.getToken();
        String s = this.tokenizer.skipToken();
        if (expr.startsWith("$")) {
            this.peek().addChild((Node)this.createEmbeddedValueNode(expr.substring(1), s));
        } else {
            this.peek().addChild((Node)this.createBindVariableNode(expr, s));
        }
    }

    protected void parseBindVariable() {
        String expr = this.tokenizer.getToken();
        this.peek().addChild((Node)this.createBindVariableNode(expr, null));
    }

    protected Node pop() {
        return this.nodeStack.pop();
    }

    protected Node peek() {
        return this.nodeStack.peek();
    }

    protected void push(Node node) {
        this.nodeStack.push(node);
    }

    protected boolean isElseMode() {
        int i = 0;
        while (i < this.nodeStack.size()) {
            if (this.nodeStack.get(i) instanceof InternalElseNode) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isTargetComment(String comment) {
        return comment != null && comment.length() > 0 && Character.isJavaIdentifierStart(comment.charAt(0));
    }

    private static boolean isIfComment(String comment) {
        return comment.startsWith("IF");
    }

    private static boolean isBeginComment(String content) {
        return content != null && "BEGIN".equals(content);
    }

    private static boolean isEndComment(String content) {
        return content != null && "END".equals(content);
    }

    protected AbstractNode createBindVariableNode(String expr, String testValue) {
        return new InternalBindVariableNode(expr, testValue, this.specifiedSql);
    }

    protected AbstractNode createEmbeddedValueNode(String expr, String testValue) {
        return new InternalEmbeddedValueNode(expr, testValue, this.specifiedSql);
    }

    protected ContainerNode createIfNode(String expr) {
        return new InternalIfNode(expr, this.specifiedSql);
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return SimpleStringUtil.replace(text, fromText, toText);
    }

    public static String convertTwoWaySql2DisplaySql(String twoWaySql, Object arg) {
        String[] argNames = new String[]{"dto"};
        Class[] argTypes = new Class[]{arg.getClass()};
        Object[] args = new Object[]{arg};
        return InternalSqlParser.convertTwoWaySql2DisplaySql(twoWaySql, argNames, argTypes, args);
    }

    public static String convertTwoWaySql2DisplaySql(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        InternalSqlParser parser = new InternalSqlParser(twoWaySql);
        Node node = parser.parse();
        InternalCommandContextCreator creator = new InternalCommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        String preparedSql = context.getSql();
        return InternalBindVariableUtil.getCompleteSql(preparedSql, context.getBindVariables());
    }

    protected static class InternalBindVariableNode
    extends AbstractNode {
        protected String _expression;
        protected String _testValue;
        protected String[] _names;
        protected String _specifiedSql;

        public InternalBindVariableNode(String expression, String testValue, String specifiedSql) {
            this._expression = expression;
            this._testValue = testValue;
            this._names = InternalStringUtil.split(expression, ".");
            this._specifiedSql = specifiedSql;
        }

        public void accept(CommandContext ctx) {
            Object value = ctx.getArg(this._names[0]);
            Class clazz = ctx.getArgType(this._names[0]);
            InternalValueAndType valueAndType = new InternalValueAndType();
            valueAndType.setTargetValue(value);
            valueAndType.setTargetType(clazz);
            this.setupValueAndType(valueAndType);
            if (valueAndType.getTargetValue() == null) {
                this.throwBindOrEmbeddedParameterNullValueException(valueAndType);
            }
            if (!this.isInScope()) {
                ctx.addSql("?", valueAndType.getTargetValue(), valueAndType.getTargetType());
            } else if (List.class.isAssignableFrom(valueAndType.getTargetType())) {
                this.bindArray(ctx, ((List)valueAndType.getTargetValue()).toArray());
            } else if (valueAndType.getTargetType().isArray()) {
                this.bindArray(ctx, valueAndType.getTargetValue());
            } else {
                ctx.addSql("?", valueAndType.getTargetValue(), valueAndType.getTargetType());
            }
            if (valueAndType.isValidRearOption()) {
                ctx.addSql(valueAndType.buildRearOptionOnSql());
            }
        }

        protected void setupValueAndType(InternalValueAndType valueAndType) {
            InternalValueAndTypeSetuper valueAndTypeSetuper = new InternalValueAndTypeSetuper(this._expression, this._names, this._specifiedSql, true);
            valueAndTypeSetuper.setupValueAndType(valueAndType);
        }

        protected void throwBindOrEmbeddedParameterNullValueException(InternalValueAndType valueAndType) {
            ParameterCommentExceptionProvider.throwBindOrEmbeddedParameterNullValueException(this._expression, valueAndType.getTargetType(), this._specifiedSql, true);
        }

        protected boolean isInScope() {
            return this._testValue != null && this._testValue.startsWith("(") && this._testValue.endsWith(")");
        }

        protected void bindArray(CommandContext ctx, Object array) {
            if (array == null) {
                return;
            }
            int length = Array.getLength(array);
            if (length == 0) {
                this.throwBindOrEmbeddedParameterEmptyListException();
            }
            Class<?> clazz = null;
            int i = 0;
            while (i < length) {
                Object currentElement = Array.get(array, i);
                if (currentElement != null) {
                    clazz = currentElement.getClass();
                    break;
                }
                ++i;
            }
            if (clazz == null) {
                this.throwBindOrEmbeddedParameterNullOnlyListException();
            }
            boolean existsValidElements = false;
            ctx.addSql("(");
            int i2 = 0;
            while (i2 < length) {
                Object currentElement = Array.get(array, i2);
                if (currentElement != null) {
                    if (!existsValidElements) {
                        ctx.addSql("?", currentElement, clazz);
                        existsValidElements = true;
                    } else {
                        ctx.addSql(", ?", currentElement, clazz);
                    }
                }
                ++i2;
            }
            ctx.addSql(")");
        }

        protected void throwBindOrEmbeddedParameterEmptyListException() {
            ParameterCommentExceptionProvider.throwBindOrEmbeddedParameterEmptyListException(this._expression, this._specifiedSql, false);
        }

        protected void throwBindOrEmbeddedParameterNullOnlyListException() {
            ParameterCommentExceptionProvider.throwBindOrEmbeddedParameterNullOnlyListException(this._expression, this._specifiedSql, true);
        }
    }

    protected static class InternalElseNode
    extends ContainerNode {
        protected InternalElseNode() {
        }

        public void accept(CommandContext ctx) {
            super.accept(ctx);
            ctx.setEnabled(true);
        }
    }

    protected static class InternalEmbeddedValueNode
    extends AbstractNode {
        protected String _expression;
        protected String _testValue;
        protected String[] _names;
        protected String _specifiedSql;

        public InternalEmbeddedValueNode(String expression, String testValue, String specifiedSql) {
            this._expression = expression;
            this._testValue = testValue;
            this._names = InternalStringUtil.split(expression, ".");
            this._specifiedSql = specifiedSql;
        }

        public void accept(CommandContext ctx) {
            Object value = ctx.getArg(this._names[0]);
            Class clazz = ctx.getArgType(this._names[0]);
            InternalValueAndType valueAndType = new InternalValueAndType();
            valueAndType.setTargetValue(value);
            valueAndType.setTargetType(clazz);
            this.setupValueAndType(valueAndType);
            if (valueAndType.getTargetValue() == null) {
                this.throwBindOrEmbeddedParameterNullValueException(valueAndType);
            }
            if (!this.isInScope()) {
                if (valueAndType.getTargetValue() != null && valueAndType.getTargetValue().toString().indexOf("?") > -1) {
                    throw new SRuntimeException("EDAO0023");
                }
                ctx.addSql(valueAndType.getTargetValue().toString());
            } else if (List.class.isAssignableFrom(valueAndType.getTargetType())) {
                this.embedArray(ctx, ((List)valueAndType.getTargetValue()).toArray());
            } else if (valueAndType.getTargetType().isArray()) {
                this.embedArray(ctx, valueAndType.getTargetValue());
            } else {
                if (valueAndType.getTargetValue() != null && valueAndType.getTargetValue().toString().indexOf("?") > -1) {
                    throw new SRuntimeException("EDAO0023");
                }
                ctx.addSql(valueAndType.getTargetValue().toString());
            }
            if (valueAndType.isValidRearOption()) {
                ctx.addSql(valueAndType.buildRearOptionOnSql());
            }
        }

        protected void setupValueAndType(InternalValueAndType valueAndType) {
            InternalValueAndTypeSetuper valueAndTypeSetuper = new InternalValueAndTypeSetuper(this._expression, this._names, this._specifiedSql, false);
            valueAndTypeSetuper.setupValueAndType(valueAndType);
        }

        protected void throwBindOrEmbeddedParameterNullValueException(InternalValueAndType valueAndType) {
            ParameterCommentExceptionProvider.throwBindOrEmbeddedParameterNullValueException(this._expression, valueAndType.getTargetType(), this._specifiedSql, false);
        }

        protected boolean isInScope() {
            return this._testValue != null && this._testValue.startsWith("(") && this._testValue.endsWith(")");
        }

        protected void embedArray(CommandContext ctx, Object array) {
            if (array == null) {
                return;
            }
            int length = Array.getLength(array);
            if (length == 0) {
                this.throwBindOrEmbeddedParameterEmptyListException();
            }
            String quote = null;
            int i = 0;
            while (i < length) {
                Object currentElement = Array.get(array, i);
                if (currentElement != null) {
                    quote = !(currentElement instanceof Number) ? "'" : "";
                    break;
                }
                ++i;
            }
            if (quote == null) {
                this.throwBindOrEmbeddedParameterNullOnlyListException();
            }
            boolean existsValidElements = false;
            ctx.addSql("(");
            int i2 = 0;
            while (i2 < length) {
                Object currentElement = Array.get(array, i2);
                if (currentElement != null) {
                    if (!existsValidElements) {
                        ctx.addSql(String.valueOf(quote) + currentElement + quote);
                        existsValidElements = true;
                    } else {
                        ctx.addSql(", " + quote + currentElement + quote);
                    }
                }
                ++i2;
            }
            ctx.addSql(")");
        }

        protected void throwBindOrEmbeddedParameterEmptyListException() {
            ParameterCommentExceptionProvider.throwBindOrEmbeddedParameterEmptyListException(this._expression, this._specifiedSql, false);
        }

        protected void throwBindOrEmbeddedParameterNullOnlyListException() {
            ParameterCommentExceptionProvider.throwBindOrEmbeddedParameterNullOnlyListException(this._expression, this._specifiedSql, false);
        }
    }

    protected static class InternalIfNode
    extends ContainerNode {
        private String _expression;
        private Object _parsedExpression;
        private InternalElseNode _elseNode;
        private String _specifiedSql;

        public InternalIfNode(String expression, String specifiedSql) {
            this._expression = expression;
            this._parsedExpression = OgnlUtil.parseExpression((String)expression);
            this._specifiedSql = specifiedSql;
        }

        public String getExpression() {
            return this._expression;
        }

        public InternalElseNode getElseNode() {
            return this._elseNode;
        }

        public void setElseNode(InternalElseNode elseNode) {
            this._elseNode = elseNode;
        }

        public void accept(CommandContext ctx) {
            Object result = null;
            try {
                result = OgnlUtil.getValue((Object)this._parsedExpression, (Object)ctx);
            }
            catch (RuntimeException e) {
                if (!this._expression.contains("pmb.")) {
                    this.throwIfCommentWrongExpressionException(this._expression, e, this._specifiedSql);
                }
                String replaced = InternalStringUtil.replace(this._expression, "pmb.", "pmb.parameterMap.");
                Object secondParsedExpression = OgnlUtil.parseExpression((String)replaced);
                try {
                    result = OgnlUtil.getValue((Object)secondParsedExpression, (Object)ctx);
                }
                catch (RuntimeException ignored) {
                    this.throwIfCommentWrongExpressionException(this._expression, e, this._specifiedSql);
                }
                if (result == null) {
                    this.throwIfCommentWrongExpressionException(this._expression, e, this._specifiedSql);
                }
                this._parsedExpression = secondParsedExpression;
            }
            if (result != null && result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    super.accept(ctx);
                    ctx.setEnabled(true);
                } else if (this._elseNode != null) {
                    this._elseNode.accept(ctx);
                    ctx.setEnabled(true);
                }
            } else {
                this.throwIfCommentNotBooleanResultException(this._expression, result, this._specifiedSql);
            }
        }

        protected void throwIfCommentWrongExpressionException(String expression, RuntimeException cause, String specifiedSql) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The IF comment of your specified SQL was Wrong!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the existence of your property on your arguments." + this.getLineSeparator();
            msg = String.valueOf(msg) + "And confirm the IF comment of your specified SQL." + this.getLineSeparator();
            msg = String.valueOf(msg) + "  For example, correct IF comment is as below:" + this.getLineSeparator();
            msg = String.valueOf(msg) + "    /*IF pmb.xxxId != null*/XXX_ID = .../*END*/" + this.getLineSeparator();
            msg = String.valueOf(msg) + "    /*IF pmb.isPaging()*/.../*END*/" + this.getLineSeparator();
            msg = String.valueOf(msg) + "    /*IF pmb.xxxId == null && pmb.xxxName != null*/.../*END*/" + this.getLineSeparator();
            msg = String.valueOf(msg) + "    /*IF pmb.xxxId == null || pmb.xxxName != null*/.../*END*/" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[IF Comment Expression]" + this.getLineSeparator() + expression + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Cause Message]" + this.getLineSeparator();
            msg = String.valueOf(msg) + cause.getClass() + ":" + this.getLineSeparator();
            msg = String.valueOf(msg) + "  --> " + cause.getMessage() + this.getLineSeparator();
            Throwable nestedCause = cause.getCause();
            if (nestedCause != null) {
                msg = String.valueOf(msg) + nestedCause.getClass() + ":" + this.getLineSeparator();
                msg = String.valueOf(msg) + "  --> " + nestedCause.getMessage() + this.getLineSeparator();
            }
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + this.getLineSeparator() + specifiedSql + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new IfCommentWrongExpressionException(msg, cause);
        }

        protected void throwIfCommentNotBooleanResultException(String expression, Object result, String specifiedSql) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The boolean expression on IF comment of your specified SQL was Wrong!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the grammar of your IF comment. Does it really express boolean?" + this.getLineSeparator();
            msg = String.valueOf(msg) + "And confirm the existence of your property on your arguments if you use parameterMap." + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[IF Comment Expression]" + this.getLineSeparator() + expression + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[IF Comment Result Value]" + this.getLineSeparator() + result + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + this.getLineSeparator() + specifiedSql + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new IfCommentNotBooleanResultException(msg);
        }

        protected String getLineSeparator() {
            return SimpleSystemUtil.getLineSeparator();
        }
    }

    protected static class InternalStringUtil {
        public static final String[] EMPTY_STRINGS = new String[0];

        private InternalStringUtil() {
        }

        public static final boolean isEmpty(String text) {
            return text == null || text.length() == 0;
        }

        public static final String replace(String text, String fromText, String toText) {
            return SimpleStringUtil.replace(text, fromText, toText);
        }

        public static String[] split(String str, String delim) {
            if (str == null) {
                return EMPTY_STRINGS;
            }
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreElements()) {
                list.add(st.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InternalValueAndType {
        public Object _targetValue;
        public Class<?> _targetType;
        protected String _rearOption;

        protected InternalValueAndType() {
        }

        public boolean isValidRearOption() {
            return this._targetValue != null && this._rearOption != null && this._rearOption.trim().length() > 0;
        }

        public String buildRearOptionOnSql() {
            return " " + this._rearOption.trim() + " ";
        }

        public Object getTargetValue() {
            return this._targetValue;
        }

        public void setTargetValue(Object targetValue) {
            this._targetValue = targetValue;
        }

        public Class<?> getTargetType() {
            return this._targetType;
        }

        public void setTargetType(Class<?> targetType) {
            this._targetType = targetType;
        }

        public String getRearOption() {
            return this._rearOption;
        }

        public void setRearOption(String rearOption) {
            this._rearOption = rearOption;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InternalValueAndTypeSetuper {
        protected String _expression;
        protected String[] _names;
        protected String _specifiedSql;
        protected boolean _bind;

        public InternalValueAndTypeSetuper(String expression, String[] names, String specifiedSql, boolean bind) {
            this._expression = expression;
            this._names = names;
            this._specifiedSql = specifiedSql;
            this._bind = bind;
        }

        /*
         * Unable to fully structure code
         */
        protected void setupValueAndType(InternalValueAndType valueAndType) {
            value = valueAndType.getTargetValue();
            clazz = valueAndType.getTargetType();
            likeSearchOption = null;
            rearOption = null;
            pos = 1;
            while (pos < this._names.length) {
                block7: {
                    block9: {
                        block8: {
                            block6: {
                                if (value == null) break;
                                currentName = this._names[pos];
                                if (pos == 1 && this.hasLikeSearchOption(beanDesc = BeanDescFactory.getBeanDesc(clazz), currentName)) {
                                    likeSearchOption = this.getLikeSearchOption(beanDesc, currentName, value);
                                }
                                if (!Map.class.isInstance(value)) break block6;
                                map = (Map)value;
                                value = map.get(this._names[pos]);
                                if (this.isLastLoop4LikeSearch(pos, likeSearchOption) && this.isValidStringValue(value)) {
                                    value = likeSearchOption.generateRealValue((String)value);
                                    rearOption = likeSearchOption.getRearOption();
                                }
                                clazz = value != null ? value.getClass() : clazz;
                                break block7;
                            }
                            beanDesc = BeanDescFactory.getBeanDesc(clazz);
                            if (!beanDesc.hasPropertyDesc(currentName)) break block8;
                            pd = beanDesc.getPropertyDesc(currentName);
                            value = this.getPropertyValue(clazz, value, currentName, pd);
                            if (this.isLastLoop4LikeSearch(pos, likeSearchOption) && this.isValidStringValue(value)) {
                                value = likeSearchOption.generateRealValue((String)value);
                                rearOption = likeSearchOption.getRearOption();
                            }
                            clazz = value != null ? value.getClass() : pd.getPropertyType();
                            break block7;
                        }
                        methodName = "get" + this.initCap(currentName);
                        if (!beanDesc.hasMethod(methodName)) break block9;
                        method = beanDesc.getMethod(methodName);
                        value = this.invokeGetter(method, value);
                        clazz = method.getReturnType();
                        break block7;
                    }
                    if (pos != 1 || !MapParameterBean.class.isAssignableFrom(clazz)) ** GOTO lbl-1000
                    pmb = (MapParameterBean)value;
                    map = pmb.getParameterMap();
                    v0 = elementValue = map != null ? map.get(this._names[pos]) : null;
                    if (elementValue != null) {
                        value = elementValue;
                        clazz = value.getClass();
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.throwBindOrEmbeddedCommentNotFoundPropertyException(this._expression, clazz, currentName, this._specifiedSql, this._bind);
                    }
                }
                ++pos;
            }
            valueAndType.setTargetValue(value);
            valueAndType.setTargetType(clazz);
            valueAndType.setRearOption(rearOption);
        }

        protected boolean isLastLoop4LikeSearch(int pos, LikeSearchOption likeSearchOption) {
            return this._names.length == pos + 1 && likeSearchOption != null;
        }

        protected boolean isValidStringValue(Object value) {
            return value != null && value instanceof String && ((String)value).length() > 0;
        }

        protected boolean hasLikeSearchOption(BeanDesc beanDesc, String currentName) {
            return beanDesc.hasPropertyDesc(String.valueOf(currentName) + "InternalLikeSearchOption");
        }

        protected LikeSearchOption getLikeSearchOption(BeanDesc beanDesc, String currentName, Object resourceBean) {
            PropertyDesc pb = beanDesc.getPropertyDesc(String.valueOf(currentName) + "InternalLikeSearchOption");
            LikeSearchOption option = (LikeSearchOption)pb.getValue(resourceBean);
            if (option == null) {
                this.throwLikeSearchOptionNotFoundException(resourceBean, currentName);
            }
            if (option.isSplit()) {
                this.throwOutsideSqlLikeSearchOptionSplitUnsupportedException(option, resourceBean, currentName);
            }
            return option;
        }

        protected void throwLikeSearchOptionNotFoundException(Object resourceBean, String currentName) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The likeSearchOption was Not Found! (Should not be null!)" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm your method call:" + this.getLineSeparator();
            String beanName = resourceBean.getClass().getSimpleName();
            String methodName = "set" + this.initCap(currentName) + "_LikeSearch(value, likeSearchOption);";
            msg = String.valueOf(msg) + "    " + beanName + "." + methodName + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Target ParameterBean]" + this.getLineSeparator() + resourceBean + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new RequiredOptionNotFoundException(msg);
        }

        protected void throwOutsideSqlLikeSearchOptionSplitUnsupportedException(LikeSearchOption option, Object resourceBean, String currentName) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The splitByXxx() of LikeSearchOption is unsupported at OutsideSql!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm your method call:" + this.getLineSeparator();
            msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
            msg = String.valueOf(msg) + "    before (x):" + this.getLineSeparator();
            String beanName = resourceBean.getClass().getSimpleName();
            String methodName = "set" + this.initCap(currentName) + "_LikeSearch(value, likeSearchOption);";
            msg = String.valueOf(msg) + "      " + beanName + " pmb = new " + beanName + "();" + this.getLineSeparator();
            msg = String.valueOf(msg) + "      LikeSearchOption likeSearchOption = new LikeSearchOption().likeContain();" + this.getLineSeparator();
            msg = String.valueOf(msg) + "      likeSearchOption.splitBySpace(); // *No! Don't invoke this!" + this.getLineSeparator();
            msg = String.valueOf(msg) + "      pmb." + methodName + this.getLineSeparator();
            msg = String.valueOf(msg) + "    after  (o):" + this.getLineSeparator();
            msg = String.valueOf(msg) + "      " + beanName + " pmb = new " + beanName + "();" + this.getLineSeparator();
            msg = String.valueOf(msg) + "      LikeSearchOption likeSearchOption = new LikeSearchOption().likeContain();" + this.getLineSeparator();
            msg = String.valueOf(msg) + "      pmb." + methodName + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Target LikeSearchOption]" + this.getLineSeparator() + option + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Target ParameterBean]" + this.getLineSeparator() + resourceBean + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new UnsupportedOperationException(msg);
        }

        protected Object getPropertyValue(Class<?> beanType, Object beanValue, String currentName, PropertyDesc pd) {
            try {
                return pd.getValue(beanValue);
            }
            catch (RuntimeException e) {
                this.throwPropertyHandlingFailureException(beanType, beanValue, currentName, this._expression, this._specifiedSql, this._bind, e);
                return null;
            }
        }

        protected void throwPropertyHandlingFailureException(Class<?> beanType, Object beanValue, String currentName, String expression, String specifiedSql, boolean bind, Exception e) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The handlig of the property was failed!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "This is the Framework Exception!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + this.getLineSeparator() + expression + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Bean Type]" + this.getLineSeparator() + beanType + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Bean Value]" + this.getLineSeparator() + beanValue + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Property Name]" + this.getLineSeparator() + currentName + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + this.getLineSeparator() + specifiedSql + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new IllegalStateException(msg, e);
        }

        protected String initCap(String name) {
            return SimpleStringUtil.initCap(name);
        }

        protected Object invokeGetter(Method method, Object target) {
            try {
                return method.invoke(target, null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        protected void throwBindOrEmbeddedCommentNotFoundPropertyException(String expression, Class<?> targetType, String notFoundProperty, String specifiedSql, boolean bind) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The property on the " + (bind ? "bind variable" : "embedded value") + " comment was Not Found!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the existence of your property on your arguments." + this.getLineSeparator();
            msg = String.valueOf(msg) + "Abd has the property had misspelling?" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + this.getLineSeparator() + expression + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[NotFound Property]" + this.getLineSeparator() + (targetType != null ? String.valueOf(targetType.getName()) + "#" : "") + notFoundProperty + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + this.getLineSeparator() + specifiedSql + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            if (bind) {
                throw new BindVariableCommentNotFoundPropertyException(msg);
            }
            throw new EmbeddedValueCommentNotFoundPropertyException(msg);
        }

        protected String getLineSeparator() {
            return SimpleSystemUtil.getLineSeparator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ParameterCommentExceptionProvider {
        protected ParameterCommentExceptionProvider() {
        }

        public static void throwBindOrEmbeddedParameterNullValueException(String expression, Class<?> targetType, String specifiedSql, boolean bind) {
            String msg = "Look! Read the message below." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "The value of " + (bind ? "bind variable" : "embedded value") + " was Null!" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "Is it within the scope of your assumption?" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "If the answer is YES, please confirm your application logic about the parameter." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "If the answer is NO, please confirm the logic of parameter comment(especially IF comment)." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "  --> For example:" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "        before (x) -- XXX_ID = /*pmb.xxxId*/3" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "        after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + ParameterCommentExceptionProvider.getLineSeparator() + expression + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Parameter Property Type]" + ParameterCommentExceptionProvider.getLineSeparator() + targetType + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + ParameterCommentExceptionProvider.getLineSeparator() + specifiedSql + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            if (bind) {
                throw new BindVariableParameterNullValueException(msg);
            }
            throw new EmbeddedValueParameterNullValueException(msg);
        }

        public static void throwBindOrEmbeddedParameterEmptyListException(String expression, String specifiedSql, boolean bind) {
            String msg = "Look! Read the message below." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "The list of " + (bind ? "bind variable" : "embedded value") + " was empty!" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm your application logic." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "  For example:" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "    before (x):" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      List<Integer> xxxIdList = new ArrayList<Integer>();" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "    after  (o):" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      List<Integer> xxxIdList = new ArrayList<Integer>();" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      xxxIdList.add(3);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      xxxIdList.add(7);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + ParameterCommentExceptionProvider.getLineSeparator() + expression + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + ParameterCommentExceptionProvider.getLineSeparator() + specifiedSql + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new IllegalArgumentException(msg);
        }

        public static void throwBindOrEmbeddedParameterNullOnlyListException(String expression, String specifiedSql, boolean bind) {
            String msg = "Look! Read the message below." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "The list of " + (bind ? "bind variable" : "embedded value") + " was 'Null Only List'!" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm your application logic." + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "  For example:" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "    before (x):" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      List<Integer> xxxIdList = new ArrayList<Integer>();" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      xxxIdList.add(null);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      xxxIdList.add(null);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "    after  (o):" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      List<Integer> xxxIdList = new ArrayList<Integer>();" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      xxxIdList.add(3);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      xxxIdList.add(7);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "      cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + ParameterCommentExceptionProvider.getLineSeparator() + expression + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "[Specified SQL]" + ParameterCommentExceptionProvider.getLineSeparator() + specifiedSql + ParameterCommentExceptionProvider.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new IllegalArgumentException(msg);
        }

        protected static String getLineSeparator() {
            return SimpleSystemUtil.getLineSeparator();
        }
    }
}

