/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureParameterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalProcedureMetaData {
    private String procedureName;
    private Map<String, InternalProcedureParameterType> unorderedMap = this.createUnorderedMap();
    private Map<String, InternalProcedureParameterType> parameterTypes = this.createParameterTypes();
    private boolean returnType;

    public InternalProcedureMetaData(String procedureName) {
        this.procedureName = procedureName;
    }

    protected Map<String, InternalProcedureParameterType> createUnorderedMap() {
        return new HashMap<String, InternalProcedureParameterType>();
    }

    protected Map<String, InternalProcedureParameterType> createParameterTypes() {
        return new TreeMap<String, InternalProcedureParameterType>(new ParameterComparator());
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public Collection<InternalProcedureParameterType> parameterTypes() {
        return this.parameterTypes.values();
    }

    public void addParameterType(InternalProcedureParameterType parameterType) {
        String name = parameterType.getParameterName();
        this.unorderedMap.put(name, parameterType);
        this.parameterTypes.put(name, parameterType);
        if (parameterType.isReturnType()) {
            this.returnType = true;
        }
    }

    public boolean hasReturnParameterType() {
        return this.returnType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ParameterComparator
    implements Comparator<String> {
        protected ParameterComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            boolean oneGreaterThanTwo = true;
            int twoGreaterThanOne = -1;
            InternalProcedureParameterType parameterType1 = (InternalProcedureParameterType)InternalProcedureMetaData.this.unorderedMap.get(o1);
            InternalProcedureParameterType parameterType2 = (InternalProcedureParameterType)InternalProcedureMetaData.this.unorderedMap.get(o2);
            if (parameterType1.isReturnType()) {
                return -1;
            }
            if (parameterType2.isReturnType()) {
                return 1;
            }
            Integer parameterIndex1 = parameterType1.getParameterIndex();
            Integer parameterIndex2 = parameterType2.getParameterIndex();
            if (parameterIndex1 == null && parameterIndex2 == null) {
                return 1;
            }
            if (parameterIndex1 != null && parameterIndex2 == null) {
                return -1;
            }
            if (parameterIndex1 == null && parameterIndex2 != null) {
                return 1;
            }
            return parameterIndex1.compareTo(parameterIndex2);
        }
    }
}

