/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureMetaData;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureParameterType;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.util.TypeUtil;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalProcedureMetaDataFactory {
    protected ValueTypeFactory valueTypeFactory;
    protected InternalFieldProcedureAnnotationReader annotationReader = new InternalFieldProcedureAnnotationReader();

    public InternalProcedureMetaData createProcedureMetaData(String procedureName, Class<?> pmbType) {
        InternalProcedureMetaData metaData = new InternalProcedureMetaData(procedureName);
        if (pmbType == null) {
            return metaData;
        }
        if (!this.isDtoType(pmbType)) {
            throw new IllegalStateException("The pmb type was Not DTO type: " + pmbType.getName());
        }
        BeanDesc pmbDesc = BeanDescFactory.getBeanDesc(pmbType);
        Stack stack = new Stack();
        Class clazz = pmbType;
        while (clazz != null && clazz != Object.class) {
            stack.push(clazz);
            clazz = clazz.getSuperclass();
        }
        while (!stack.isEmpty()) {
            clazz = (Class)stack.pop();
            this.registerParameterType(metaData, pmbDesc, clazz.getDeclaredFields());
        }
        return metaData;
    }

    protected void registerParameterType(InternalProcedureMetaData metaData, BeanDesc pmbDesc, Field[] fields) {
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            InternalProcedureParameterType ppt;
            Field field = fieldArray[n2];
            if (this.isInstanceField(field) && (ppt = this.getProcedureParameterType(pmbDesc, field)) != null) {
                metaData.addParameterType(ppt);
            }
            ++n2;
        }
    }

    protected InternalProcedureParameterType getProcedureParameterType(BeanDesc dtoDesc, Field field) {
        String procedureParameter = this.annotationReader.getProcedureParameter(dtoDesc, field);
        if (procedureParameter == null) {
            return null;
        }
        String type = this.extractParameterType(procedureParameter);
        field.setAccessible(true);
        InternalProcedureParameterType ppt = new InternalProcedureParameterType(field);
        if (type.equalsIgnoreCase("in")) {
            ppt.setInType(true);
        } else if (type.equalsIgnoreCase("out")) {
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase("inout")) {
            ppt.setInType(true);
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase("return")) {
            ppt.setOutType(true);
            ppt.setReturnType(true);
        } else {
            String msg = "The parameter type should be 'in' or 'out' or 'inout' or 'return':";
            msg = String.valueOf(msg) + " class=" + field.getDeclaringClass().getSimpleName();
            msg = String.valueOf(msg) + " field=" + field.getName();
            msg = String.valueOf(msg) + " parameterType=" + type;
            throw new IllegalStateException(msg);
        }
        Integer index = this.extractParameterIndex(procedureParameter, field);
        ppt.setParameterIndex(index);
        ValueType valueType = this.getValueType(dtoDesc, field);
        ppt.setValueType(valueType);
        return ppt;
    }

    protected String extractParameterType(String procedureParameter) {
        if (procedureParameter.contains(",")) {
            return procedureParameter.substring(0, procedureParameter.indexOf(",")).trim();
        }
        return procedureParameter.trim();
    }

    protected Integer extractParameterIndex(String procedureParameter, Field field) {
        if (procedureParameter.contains(",")) {
            String tmp = procedureParameter.substring(procedureParameter.indexOf(",") + ",".length()).trim();
            try {
                return Integer.valueOf(tmp);
            }
            catch (NumberFormatException e) {
                String msg = "The parameter index should be number:";
                msg = String.valueOf(msg) + " class=" + field.getDeclaringClass().getSimpleName();
                msg = String.valueOf(msg) + " field=" + field.getName();
                msg = String.valueOf(msg) + " parameterIndex=" + tmp + " procedureParameter=" + procedureParameter;
                throw new IllegalStateException(msg, e);
            }
        }
        return null;
    }

    protected ValueType getValueType(BeanDesc dtoDesc, Field field) {
        String name = this.annotationReader.getValueType(dtoDesc, field);
        if (name != null) {
            return this.valueTypeFactory.getValueTypeByName(name);
        }
        Class<?> type = field.getType();
        if (List.class.isAssignableFrom(type)) {
            if (ConditionBeanContext.isOracle()) {
                return ValueTypes.ORACLE_RESULT_SET;
            }
            if (ConditionBeanContext.isPostgreSql()) {
                return ValueTypes.POSTGRE_RESULT_SET;
            }
            return ValueTypes.SERIALIZABLE_BYTE_ARRAY;
        }
        return this.valueTypeFactory.getValueTypeByClass(type);
    }

    protected boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    protected boolean isDtoType(Class<?> clazz) {
        return !TypeUtil.isSimpleType(clazz) && !this.isContainerType(clazz);
    }

    protected boolean isContainerType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    protected static class InternalFieldProcedureAnnotationReader {
        protected String PROCEDURE_PARAMETER_SUFFIX = "_PROCEDURE_PARAMETER";
        protected String VALUE_TYPE_SUFFIX = "_VALUE_TYPE";

        public String getProcedureParameter(BeanDesc dtoDesc, Field field) {
            String fieldName = this.removeInstanceVariablePrefix(field.getName());
            String annotationName = String.valueOf(fieldName) + this.PROCEDURE_PARAMETER_SUFFIX;
            if (dtoDesc.hasField(annotationName)) {
                Field f = dtoDesc.getField(annotationName);
                return (String)this.getValue(f, null);
            }
            return null;
        }

        public String getValueType(BeanDesc dtoDesc, Field field) {
            String fieldName = this.removeInstanceVariablePrefix(field.getName());
            String annotationName = String.valueOf(fieldName) + this.VALUE_TYPE_SUFFIX;
            if (dtoDesc.hasField(annotationName)) {
                Field f = dtoDesc.getField(annotationName);
                return (String)this.getValue(f, null);
            }
            return null;
        }

        protected String removeInstanceVariablePrefix(String fieldName) {
            return fieldName.startsWith("_") ? fieldName.substring("_".length()) : fieldName;
        }

        protected Object getValue(Field field, Object target) {
            try {
                return field.get(target);
            }
            catch (IllegalAccessException e) {
                String msg = "The getting of the field threw the exception:";
                msg = String.valueOf(msg) + " class=" + field.getDeclaringClass().getSimpleName();
                msg = String.valueOf(msg) + " field=" + field.getName();
                throw new IllegalStateException(msg, e);
            }
        }
    }
}

