/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.ddl.factory.impl;

import java.util.List;
import jp.sourceforge.ea2ddl.common.config.Config;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ListResultBean;
import jp.sourceforge.ea2ddl.dao.cbean.TConnectorCB;
import jp.sourceforge.ea2ddl.dao.cbean.TOperationCB;
import jp.sourceforge.ea2ddl.dao.cbean.TOperationparamsCB;
import jp.sourceforge.ea2ddl.dao.exbhv.TAttributeBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TConnectorBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TObjectBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TObjectconstraintBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TObjectpropertiesBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TOperationBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TOperationparamsBhv;
import jp.sourceforge.ea2ddl.dao.exbhv.TPackageBhv;
import jp.sourceforge.ea2ddl.dao.exentity.TAttribute;
import jp.sourceforge.ea2ddl.dao.exentity.TConnector;
import jp.sourceforge.ea2ddl.dao.exentity.TObject;
import jp.sourceforge.ea2ddl.dao.exentity.TOperation;
import jp.sourceforge.ea2ddl.dao.exentity.TOperationparams;
import jp.sourceforge.ea2ddl.dao.exentity.TPackage;
import jp.sourceforge.ea2ddl.ddl.factory.ModelFactory;
import jp.sourceforge.ea2ddl.ddl.model.ColumnModel;
import jp.sourceforge.ea2ddl.ddl.model.DatabaseModel;
import jp.sourceforge.ea2ddl.ddl.model.ForeignKeyModel;
import jp.sourceforge.ea2ddl.ddl.model.IndexModel;
import jp.sourceforge.ea2ddl.ddl.model.PrimaryKeyModel;
import jp.sourceforge.ea2ddl.ddl.model.TableModel;
import jp.sourceforge.ea2ddl.ddl.model.UniqueModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.annotation.tiger.Binding;

public class DatabaseModelFactoryImpl
implements ModelFactory {
    private Log _log = LogFactory.getLog(DatabaseModelFactoryImpl.class);
    private Config _config;
    private TPackageBhv _tPackageBhv;
    private TObjectBhv _tObjectBhv;
    private TObjectpropertiesBhv _tObjectpropertiesBhv;
    private TObjectconstraintBhv _tObjectconstraintBhv;
    private TAttributeBhv _tAttributeBhv;
    private TConnectorBhv _tConnectorBhv;
    private TOperationBhv _tOperationBhv;
    private TOperationparamsBhv _tOperationparamsBhv;

    @Binding
    public void setConfig(Config config) {
        this._config = config;
    }

    @Binding
    public void setTPackageBhv(TPackageBhv packageBhv) {
        this._tPackageBhv = packageBhv;
    }

    @Binding
    public void setTObjectBhv(TObjectBhv objectBhv) {
        this._tObjectBhv = objectBhv;
    }

    @Binding
    public void setTObjectpropertiesBhv(TObjectpropertiesBhv objectpropertiesBhv) {
        this._tObjectpropertiesBhv = objectpropertiesBhv;
    }

    @Binding
    public void setTObjectconstraintBhv(TObjectconstraintBhv objectconstraintBhv) {
        this._tObjectconstraintBhv = objectconstraintBhv;
    }

    @Binding
    public void setTAttributeBhv(TAttributeBhv attributeBhv) {
        this._tAttributeBhv = attributeBhv;
    }

    @Binding
    public void setTConnectorBhv(TConnectorBhv connectorBhv) {
        this._tConnectorBhv = connectorBhv;
    }

    @Binding
    public void setTOperationBhv(TOperationBhv operationBhv) {
        this._tOperationBhv = operationBhv;
    }

    @Binding
    public void setTOperationparamsBhv(TOperationparamsBhv operationparamsBhv) {
        this._tOperationparamsBhv = operationparamsBhv;
    }

    public DatabaseModel create() {
        DatabaseModel dbModel = new DatabaseModel();
        TPackage pkg = this.getPackage();
        List<TObject> objectList = this._tObjectBhv.selectListByStereotype(pkg, "table");
        this._log.debug((Object)objectList.size());
        for (TObject object : objectList) {
            TableModel table = this.generateTableModel(object);
            dbModel.addTable(table);
        }
        return dbModel;
    }

    protected TPackage getPackage() {
        return this._tPackageBhv.selectPackage(this._config.getProperty("er.package.tree"));
    }

    protected TableModel generateTableModel(TObject tobject) {
        TableModel table = new TableModel();
        table.setName(tobject.getName());
        table.setAlias(tobject.getAlias());
        table.setNote(tobject.getNote());
        if (this._config.getBoolean(this._config.getProperty("use.schema"))) {
            table.setSchema(this._tObjectpropertiesBhv.getValue(tobject, "OWNER"));
        }
        table.setSuppressCommonColumn(this._tObjectconstraintBhv.hasConstraint(tobject, "SUPPRESS_COMMON_COLUMN"));
        this.generateColumnModel(table, tobject);
        this.generatePKModel(table, tobject);
        this.generateFKModel(table, tobject);
        this.generateUniqueModel(table, tobject);
        this.generateIndexModel(table, tobject);
        return table;
    }

    protected void generateColumnModel(TableModel table, TObject tobject) {
        ListResultBean<TAttribute> attributes = this._tAttributeBhv.selectColumns(tobject);
        for (TAttribute attribute : attributes) {
            ColumnModel column = new ColumnModel();
            column.setName(attribute.getName());
            column.setAlias(attribute.getStyle());
            column.setType(this.getColumnType(attribute));
            column.setLength(attribute.getLength());
            column.setPrecision(attribute.getPrecision());
            column.setScale(attribute.getScale());
            column.setNullable(Integer.valueOf(0).equals(attribute.getAllowduplicates()));
            column.setNote(attribute.getNotes());
            table.addColumn(column);
        }
    }

    protected String getColumnType(TAttribute attribute) {
        String dictionary = this._config.getProperty(attribute.getName());
        if (dictionary != null) {
            return dictionary;
        }
        return attribute.getType();
    }

    protected void generatePKModel(TableModel table, TObject tobject) {
        ListResultBean<TOperation> pkList = this._tOperationBhv.selectOperation(tobject, "PK");
        if (pkList.isEmpty()) {
            return;
        }
        TOperation opePK = pkList.get(0);
        ListResultBean<TOperationparams> params = this._tOperationparamsBhv.selectOperationParams(opePK);
        if (!params.isEmpty()) {
            PrimaryKeyModel pk = new PrimaryKeyModel();
            pk.setName(opePK.getName());
            for (TOperationparams param : params) {
                pk.addColumnName(param.getName());
            }
            table.setPrimaryKey(pk);
        }
    }

    protected void generateFKModel(TableModel table, TObject tobject) {
        ListResultBean<TOperation> fkList = this._tOperationBhv.selectOperation(tobject, "FK");
        for (TOperation opeFK : fkList) {
            ForeignKeyModel fkModel = new ForeignKeyModel();
            fkModel.setName(opeFK.getName());
            ListResultBean<TOperationparams> params = this._tOperationparamsBhv.selectOperationParams(opeFK);
            for (TOperationparams param : params) {
                fkModel.addColumnName(param.getName());
            }
            TConnectorCB conCB = new TConnectorCB();
            conCB.query().setStartObjectId_Equal(tobject.getObjectId());
            conCB.query().setSourcerole_Equal(opeFK.getName());
            TConnector con = this._tConnectorBhv.selectEntity(conCB);
            TObject targetTable = this._tObjectBhv.selectEntity(con.getEndObjectId());
            fkModel.setTargetTable(targetTable.getName());
            TOperationCB targetOpeCB = new TOperationCB();
            targetOpeCB.query().setObjectId_Equal(con.getEndObjectId());
            targetOpeCB.query().setName_Equal(con.getDestrole());
            TOperation targetOpe = this._tOperationBhv.selectEntity(targetOpeCB);
            ListResultBean<TOperationparams> targetParams = this._tOperationparamsBhv.selectOperationParams(targetOpe);
            for (TOperationparams targetParam : targetParams) {
                fkModel.addTargetColumnName(targetParam.getName());
            }
            table.addForeignKey(fkModel);
        }
    }

    protected void generateUniqueModel(TableModel table, TObject tobject) {
        TOperationCB cb = new TOperationCB();
        cb.query().setObjectId_Equal(tobject.getObjectId());
        cb.query().setStereotype_Equal("unique");
        ListResultBean<TOperation> uniqueList = this._tOperationBhv.selectList(cb);
        for (TOperation unique : uniqueList) {
            UniqueModel uniqueModel = new UniqueModel();
            uniqueModel.setName(unique.getName());
            TOperationparamsCB opeCB = new TOperationparamsCB();
            opeCB.query().setOperationid_Equal(unique.getOperationid());
            opeCB.query().addOrderBy_Pos_Asc();
            ListResultBean<TOperationparams> cols = this._tOperationparamsBhv.selectList(opeCB);
            for (TOperationparams param : cols) {
                uniqueModel.addColumnName(param.getName());
            }
            table.addUnique(uniqueModel);
        }
    }

    protected void generateIndexModel(TableModel table, TObject tobject) {
        ListResultBean<TOperation> indexList = this._tOperationBhv.selectOperation(tobject, "index");
        for (TOperation index : indexList) {
            IndexModel indexModel = new IndexModel();
            indexModel.setName(index.getName());
            ListResultBean<TOperationparams> params = this._tOperationparamsBhv.selectOperationParams(index);
            for (TOperationparams param : params) {
                indexModel.addColumn(param.getName());
            }
            table.addIndex(indexModel);
        }
    }
}

