/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.OutputStreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    protected FileUtil() {
    }

    public static void copyDirectory(File srcDir, File destDir, FilenameFilter filter) {
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("srcDir");
        }
        if (!FileUtil.getCanonicalPath(srcDir).equals(FileUtil.getCanonicalPath(srcDir)) && FileUtil.getCanonicalPath(srcDir).startsWith(FileUtil.getCanonicalPath(srcDir))) {
            throw new IllegalArgumentException("destDir");
        }
        FileUtil.copyDir(srcDir, destDir, filter);
    }

    protected static void copyDir(File srcDir, File destDir, FilenameFilter filter) {
        File[] srcFiles;
        destDir.mkdirs();
        File[] fileArray = srcFiles = srcDir.listFiles(filter);
        int n = srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            File dest = new File(destDir, src.getName());
            if (src.isDirectory()) {
                FileUtil.copyDir(src, dest, filter);
            } else {
                FileUtil.copyFile(src, dest);
            }
            ++n2;
        }
    }

    protected static void copyFile(File src, File dest) {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            try {
                int length;
                in = new BufferedInputStream(FileInputStreamUtil.create((File)src));
                out = new BufferedOutputStream(FileOutputStreamUtil.create((File)dest));
                byte[] buf = new byte[1024];
                while (-1 < (length = in.read(buf))) {
                    out.write(buf, 0, length);
                    out.flush();
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            InputStreamUtil.close(in);
            OutputStreamUtil.close(out);
            throw throwable;
        }
        InputStreamUtil.close((InputStream)in);
        OutputStreamUtil.close((OutputStream)out);
    }

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir");
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("dir");
        }
        FileUtil.deleteDir(dir);
    }

    protected static void deleteDir(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.deleteDir(file);
                file.delete();
            } else {
                file.delete();
            }
            ++n2;
        }
        dir.delete();
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void traverseDirectory(File dir, FilenameFilter filter, Comparator<File> comparator, FileHandler handler) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return;
        }
        Arrays.sort(files, comparator);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.traverseDirectory(file, filter, comparator, handler);
            }
            handler.handle(file);
            ++n2;
        }
    }

    public static File createJavaFile(File baseDir, String packageName, String shortClassName) {
        File packageDir = packageName == null ? baseDir : new File(baseDir, packageName.replace('.', File.separatorChar));
        return new File(packageDir, String.valueOf(shortClassName) + ".java");
    }

    public static interface FileHandler {
        public void handle(File var1);
    }
}

