/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;

public class HotdeployUtil {
    public static final String REBUILDER_CLASS_NAME = "org.seasar.framework.container.hotdeploy.HotdeployUtil$RebuilderImpl";
    private static Boolean hotdeploy;

    protected HotdeployUtil() {
    }

    public static void setHotdeploy(boolean hotdeploy) {
        HotdeployUtil.hotdeploy = hotdeploy;
    }

    public static void clearHotdeploy() {
        hotdeploy = null;
    }

    public static boolean isHotdeploy() {
        if (hotdeploy != null) {
            return hotdeploy;
        }
        S2ContainerBehavior.Provider provider = S2ContainerBehavior.getProvider();
        return provider instanceof HotdeployBehavior;
    }

    public static void start() {
        if (HotdeployUtil.isHotdeploy()) {
            ((HotdeployBehavior)S2ContainerBehavior.getProvider()).start();
        }
    }

    public static void stop() {
        if (HotdeployUtil.isHotdeploy()) {
            ((HotdeployBehavior)S2ContainerBehavior.getProvider()).stop();
        }
    }

    public static Object rebuildValue(Object value) {
        if (HotdeployUtil.isHotdeploy()) {
            return HotdeployUtil.rebuildValueInternal(value);
        }
        return value;
    }

    protected static Object rebuildValueInternal(Object value) {
        if (value == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class rebuilderClass = ClassLoaderUtil.loadClass(loader, REBUILDER_CLASS_NAME);
        Rebuilder rebuilder = (Rebuilder)ClassUtil.newInstance(rebuilderClass);
        return rebuilder.rebuild(value);
    }

    public static class RebuilderImpl
    implements Rebuilder {
        public Object rebuild(Object value) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            catch (Throwable t) {
                return value;
            }
        }
    }

    public static interface Rebuilder {
        public Object rebuild(Object var1);
    }
}

