/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.AbstractDtoMetaDataResultSetHandler;

public abstract class AbstractBeanMetaDataResultSetHandler
extends AbstractDtoMetaDataResultSetHandler {
    private BeanMetaData beanMetaData;
    protected RelationRowCreator relationRowCreator;

    public AbstractBeanMetaDataResultSetHandler(BeanMetaData beanMetaData, RowCreator rowCreator, RelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator);
        this.beanMetaData = beanMetaData;
        this.relationRowCreator = relationRowCreator;
    }

    protected Map createPropertyCache(Set columnNames) throws SQLException {
        return this.rowCreator.createPropertyCache(columnNames, this.beanMetaData);
    }

    protected Object createRow(ResultSet rs, Map propertyCache) throws SQLException {
        Class beanClass = this.beanMetaData.getBeanClass();
        return this.rowCreator.createRow(rs, propertyCache, beanClass);
    }

    protected Map createRelationPropertyCache(Set columnNames) throws SQLException {
        return this.relationRowCreator.createPropertyCache(columnNames, this.beanMetaData);
    }

    protected Object createRelationRow(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues, Map relationPropertyCache) throws SQLException {
        return this.relationRowCreator.createRelationRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache);
    }

    protected void postCreateRow(Object row) {
        BeanMetaData bmd = this.getBeanMetaData();
        Set names = bmd.getModifiedPropertyNames(row);
        names.clear();
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }
}

