/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.InjectDaoClassSupport;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.InsertAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.framework.exception.SRuntimeException;

public class InsertAutoDynamicCommand
implements SqlCommand,
InjectDaoClassSupport {
    private DataSource dataSource;
    private StatementFactory statementFactory;
    private BeanMetaData beanMetaData;
    private String[] propertyNames;
    private Class notSingleRowUpdatedExceptionClass;
    private Class daoClass;
    private boolean checkSingleRowUpdate = true;

    public Object execute(Object[] args) {
        Object bean = args[0];
        BeanMetaData bmd = this.getBeanMetaData();
        PropertyType[] propertyTypes = this.createInsertPropertyTypes(bmd, bean, this.getPropertyNames());
        String sql = this.createInsertSql(bmd, propertyTypes);
        InsertAutoHandler handler = new InsertAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        this.injectDaoClass(handler);
        handler.setSql(sql);
        int rows = handler.execute(args);
        if (this.isCheckSingleRowUpdate() && rows != 1) {
            throw new NotSingleRowUpdatedRuntimeException(args[0], rows);
        }
        return new Integer(rows);
    }

    public void setDaoClass(Class clazz) {
        this.daoClass = clazz;
    }

    protected void injectDaoClass(BasicHandler handler) {
        if (this.daoClass != null) {
            handler.setLoggerClass(this.daoClass);
        }
    }

    protected String createInsertSql(BeanMetaData bmd, PropertyType[] propertyTypes) {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append("INSERT INTO ");
        buf.append(bmd.getTableName());
        buf.append(" (");
        for (i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            String columnName = pt.getColumnName();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(columnName);
        }
        buf.append(") VALUES (");
        for (i = 0; i < propertyTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    protected PropertyType[] createInsertPropertyTypes(BeanMetaData bmd, Object bean, String[] propertyNames) {
        if (0 == propertyNames.length) {
            throw new SRuntimeException("EDAO0024", new Object[]{bean.getClass().getName()});
        }
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            IdentifierGenerator generator;
            PropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() ? !(generator = bmd.getIdentifierGenerator(pt.getPropertyName())).isSelfGenerate() : pt.getPropertyDesc().getValue(bean) == null && !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName)) continue;
            types.add(pt);
        }
        if (types.isEmpty()) {
            throw new SRuntimeException("EDAO0014");
        }
        PropertyType[] propertyTypes = types.toArray(new PropertyType[types.size()]);
        return propertyTypes;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Class getNotSingleRowUpdatedExceptionClass() {
        return this.notSingleRowUpdatedExceptionClass;
    }

    public void setNotSingleRowUpdatedExceptionClass(Class notSingleRowUpdatedExceptionClass) {
        this.notSingleRowUpdatedExceptionClass = notSingleRowUpdatedExceptionClass;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(BeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    protected String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public boolean isCheckSingleRowUpdate() {
        return this.checkSingleRowUpdate;
    }

    public void setCheckSingleRowUpdate(boolean checkSingleRowUpdate) {
        this.checkSingleRowUpdate = checkSingleRowUpdate;
    }
}

