/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.ArgumentDtoAnnotationReader;
import org.seasar.dao.IllegalParameterTypeRuntimeException;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.ProcedureMetaData;
import org.seasar.dao.ProcedureMetaDataFactory;
import org.seasar.dao.ProcedureParameterType;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.ProcedureMetaDataImpl;
import org.seasar.dao.impl.ProcedureParameterTypeImpl;
import org.seasar.dao.util.TypeUtil;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class ProcedureMetaDataFactoryImpl
implements ProcedureMetaDataFactory {
    public static final String INIT_METHOD = "initialize";
    public static final String valueTypeFactory_BINDING = "bindingType=must";
    public static final String annotationReaderFactory_BINDING = "bindingType=must";
    protected static String procedureParameterInType = "in";
    protected static String procedureParameterOutType = "out";
    protected static String procedureParameterInOutType = "inOut";
    protected static String procedureParameterReturnType = "return";
    protected ValueTypeFactory valueTypeFactory;
    protected AnnotationReaderFactory annotationReaderFactory;
    protected ArgumentDtoAnnotationReader annotationReader;

    public void initialize() {
        this.annotationReader = this.annotationReaderFactory.createArgumentDtoAnnotationReader();
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    public ProcedureMetaData createProcedureMetaData(String procedureName, Method method) {
        ProcedureMetaDataImpl metaData = new ProcedureMetaDataImpl(procedureName);
        Class dtoClass = this.getParameterType(method);
        if (dtoClass == null) {
            return metaData;
        }
        if (!this.isDtoType(dtoClass)) {
            throw new IllegalSignatureRuntimeException("EDAO0031", method.toString());
        }
        BeanDesc dtoDesc = BeanDescFactory.getBeanDesc((Class)dtoClass);
        Field[] fields = dtoClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            ProcedureParameterType ppt;
            Field field = fields[i];
            if (!this.isInstanceField(field) || (ppt = this.getProcedureParameterType(dtoDesc, field)) == null) continue;
            metaData.addParameterType(ppt);
        }
        return metaData;
    }

    protected Class getParameterType(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return null;
        }
        if (parameterTypes.length == 1) {
            return parameterTypes[0];
        }
        throw new IllegalSignatureRuntimeException("EDAO0030", method.toString());
    }

    protected ProcedureParameterType getProcedureParameterType(BeanDesc dtoDesc, Field field) {
        String type = this.annotationReader.getProcedureParameter(dtoDesc, field);
        if (type == null) {
            return null;
        }
        field.setAccessible(true);
        ProcedureParameterTypeImpl ppt = new ProcedureParameterTypeImpl(field);
        if (type.equalsIgnoreCase(procedureParameterInType)) {
            ppt.setInType(true);
        } else if (type.equalsIgnoreCase(procedureParameterOutType)) {
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase(procedureParameterInOutType)) {
            ppt.setInType(true);
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase(procedureParameterReturnType)) {
            ppt.setOutType(true);
            ppt.setReturnType(true);
        } else {
            throw new IllegalParameterTypeRuntimeException(type);
        }
        ValueType valueType = this.getValueType(dtoDesc, field);
        ppt.setValueType(valueType);
        return ppt;
    }

    protected ValueType getValueType(BeanDesc dtoDesc, Field field) {
        String name = this.annotationReader.getValueType(dtoDesc, field);
        if (name != null) {
            return this.valueTypeFactory.getValueTypeByName(name);
        }
        Class<?> type = field.getType();
        return this.valueTypeFactory.getValueTypeByClass(type);
    }

    protected boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    protected boolean isDtoType(Class clazz) {
        return !TypeUtil.isSimpleType(clazz) && !this.isContainerType(clazz);
    }

    protected boolean isContainerType(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || clazz.isArray();
    }
}

