/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.impl.UpdateAutoDynamicCommand;
import org.seasar.dao.impl.UpdateAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.log.Logger;

public class UpdateModifiedOnlyCommand
extends UpdateAutoDynamicCommand {
    private static Logger logger = Logger.getLogger((Class)UpdateModifiedOnlyCommand.class);
    private static final Integer NO_UPDATE = new Integer(0);

    public UpdateModifiedOnlyCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    public Object execute(Object[] args) {
        Object bean = args[0];
        BeanMetaData bmd = this.getBeanMetaData();
        PropertyType[] propertyTypes = this.createUpdatePropertyTypes(bmd, bean, this.getPropertyNames());
        if (propertyTypes.length == 0) {
            if (logger.isDebugEnabled()) {
                String s = this.createNoUpdateLogMessage(bean, bmd);
                logger.debug((Object)s);
            }
            return NO_UPDATE;
        }
        UpdateAutoHandler handler = new UpdateAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        this.injectDaoClass(handler);
        handler.setSql(this.createUpdateSql(bmd, propertyTypes));
        int i = handler.execute(args);
        if (this.isCheckSingleRowUpdate() && i < 1) {
            throw this.createNotSingleRowUpdatedRuntimeException(args[0], i);
        }
        return new Integer(i);
    }

    protected NotSingleRowUpdatedRuntimeException createNotSingleRowUpdatedRuntimeException(Object bean, int rows) {
        return new NotSingleRowUpdatedRuntimeException(bean, rows);
    }

    protected String createNoUpdateLogMessage(Object bean, BeanMetaData bmd) {
        StringBuffer sb = new StringBuffer();
        sb.append("skip UPDATE: table=");
        sb.append(bmd.getTableName());
        int size = bmd.getPrimaryKeySize();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append(", key{");
            } else {
                sb.append(", ");
            }
            String keyName = bmd.getPrimaryKey(i);
            sb.append(keyName);
            sb.append("=");
            sb.append(bmd.getPropertyTypeByColumnName(keyName).getPropertyDesc().getValue(bean));
            if (i != size - 1) continue;
            sb.append("}");
        }
        String s = new String(sb);
        return s;
    }

    protected PropertyType[] createUpdatePropertyTypes(BeanMetaData bmd, Object bean, String[] propertyNames) {
        Set modifiedPropertyNames = this.getBeanMetaData().getModifiedPropertyNames(bean);
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            PropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() || !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName) && !modifiedPropertyNames.contains(propertyName)) continue;
            types.add(pt);
        }
        PropertyType[] propertyTypes = types.toArray(new PropertyType[types.size()]);
        return propertyTypes;
    }
}

