/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.node;

import org.seasar.dao.CommandContext;
import org.seasar.dao.node.AbstractNode;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.StringUtil;

public class EmbeddedValueNode
extends AbstractNode {
    private String expression;
    private String baseName;
    private String propertyName;

    public EmbeddedValueNode(String expression) {
        this.expression = expression;
        String[] array = StringUtil.split((String)expression, (String)".");
        this.baseName = array[0];
        if (array.length > 1) {
            this.propertyName = array[1];
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(CommandContext ctx) {
        Object value = ctx.getArg(this.baseName);
        Class clazz = ctx.getArgType(this.baseName);
        if (this.propertyName != null) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
            PropertyDesc pd = beanDesc.getPropertyDesc(this.propertyName);
            value = pd.getValue(value);
            clazz = pd.getPropertyType();
        }
        if (value.toString().indexOf("?") > -1) {
            throw new SRuntimeException("EDAO0023");
        }
        if (value != null) {
            ctx.addSql(value.toString());
        }
    }
}

