/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.IntegerConversionUtil;

public abstract class AbstractPagingSqlRewriter
implements PagingSqlRewriter {
    private static final Pattern patternOrderBy = Pattern.compile("order\\s+by\\s+([\\w\\p{L}.`\\[\\]]+(\\s+(asc|desc))?|([\\w\\p{L}.`\\[\\]]+(\\s+(asc|desc))?\\s*,\\s*)+[\\w\\p{L}.`\\[\\]])+(\\s+(asc|desc))?\\s*$", 66);
    private boolean chopOrderBy = true;
    public static final String dataSource_BINDING = "bindingType=must";
    private DataSource dataSource;

    public String rewrite(String sql, Object[] args, Class[] argTypes) {
        Object[] pagingArgs = PagerContext.getContext().peekArgs();
        if (PagerContext.isPagerCondition(pagingArgs)) {
            try {
                PagerCondition dto = PagerContext.getPagerCondition(pagingArgs);
                dto.setCount(this.getCount(sql, args, argTypes));
                if (dto.getLimit() > 0 && dto.getOffset() > -1) {
                    String limitOffsetSql = this.makeLimitOffsetSql(sql, dto.getLimit(), dto.getOffset());
                    return limitOffsetSql;
                }
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        return sql;
    }

    public void setChopOrderBy(boolean chopOrderBy) {
        this.chopOrderBy = chopOrderBy;
    }

    public boolean isChopOrderBy() {
        return this.chopOrderBy;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected int getCount(String baseSQL, Object[] args, Class[] argTypes) throws SQLException {
        String countSQL = this.makeCountSql(baseSQL);
        BasicSelectHandler handler = new BasicSelectHandler(this.dataSource, countSQL, (ResultSetHandler)new ObjectResultSetHandler());
        Object ret = handler.execute(args, argTypes);
        if (ret != null) {
            return IntegerConversionUtil.toPrimitiveInt((Object)ret);
        }
        throw new SQLException("[S2Pager]Result not found.");
    }

    protected String chopOrderBy(String baseSQL) {
        Matcher matcher = patternOrderBy.matcher(baseSQL);
        if (matcher.find()) {
            return matcher.replaceAll("");
        }
        return baseSQL;
    }

    abstract String makeLimitOffsetSql(String var1, int var2, int var3);

    abstract String makeCountSql(String var1);
}

