/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingContext {
    protected Map<String, Map<Object, Object>> cache;
    protected Map<Object, Map<Object, Set<Object>>> doneEntityMap;

    public MappingContext() {
        this(100);
    }

    public MappingContext(int initialCapacity) {
        this.cache = new HashMap<String, Map<Object, Object>>(initialCapacity);
        this.doneEntityMap = new HashMap<Object, Map<Object, Set<Object>>>(initialCapacity * 2);
    }

    public Object getCache(Class<?> entityClass, Object key) {
        Map<Object, Object> m = this.cache.get(entityClass.getName());
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    public void setCache(Class<?> entityClass, Object key, Object entity) {
        Map<Object, Object> m = this.cache.get(entityClass.getName());
        if (m == null) {
            m = new HashMap<Object, Object>();
            this.cache.put(entityClass.getName(), m);
        }
        m.put(key, entity);
    }

    public boolean checkDone(Object entityMapper, Object target, Object entity) {
        Set<Object> entities;
        Map<Object, Set<Object>> m = this.doneEntityMap.get(entityMapper);
        if (m == null) {
            m = new HashMap<Object, Set<Object>>();
            this.doneEntityMap.put(entityMapper, m);
        }
        if ((entities = m.get(target)) == null) {
            entities = new HashSet<Object>();
            m.put(target, entities);
        }
        return !entities.add(entity);
    }

    public void clear() {
        this.cache.clear();
        this.doneEntityMap.clear();
    }
}

