/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.OrderByBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.sqlclause.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.WhereClauseSimpleFilter;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.helper.mapstring.impl.MapListStringImpl;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionBean
implements ConditionBean {
    private static final String MAP_STRING_MAP_MARK = "map:";
    private static final String MAP_STRING_LIST_MARK = "list:";
    private static final String MAP_STRING_START_BRACE = "@{";
    private static final String MAP_STRING_END_BRACE = "@}";
    private static final String MAP_STRING_DELIMITER = "@;";
    private static final String MAP_STRING_EQUAL = "@=";
    protected final SqlClause _sqlClause = this.createSqlClause();
    protected int _safetyMaxResultSize;
    protected StatementConfig _statementConfig;
    protected boolean _canPagingReSelect = true;
    protected boolean _forDerivedReferrer;
    protected boolean _forScalarSelect;
    protected boolean _forScalarSubQuery;
    protected boolean _forUnion;
    protected boolean _forExistsSubQuery;
    protected boolean _forInScopeSubQuery;
    protected boolean _isSelectCountIgnoreFetchScope;

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    protected abstract SqlClause createSqlClause();

    protected abstract DBMetaProvider getDBMetaProvider();

    public void embedCondition(Set<ColumnInfo> embeddedColumnInfoSet, boolean quote) {
        if (embeddedColumnInfoSet == null) {
            String msg = "The argument[embeddedColumnInfoSet] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (quote) {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet));
        } else {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedSimpleFilter(embeddedColumnInfoSet));
        }
    }

    private WhereClauseSimpleFilter newToEmbeddedQuotedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new WhereClauseSimpleFilter.WhereClauseToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet);
    }

    private WhereClauseSimpleFilter newToEmbeddedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new WhereClauseSimpleFilter.WhereClauseToEmbeddedSimpleFilter(embeddedColumnInfoSet);
    }

    private void addWhereClauseSimpleFilter(WhereClauseSimpleFilter whereClauseSimpleFilter) {
        this._sqlClause.addWhereClauseSimpleFilter(whereClauseSimpleFilter);
    }

    @Override
    public void acceptPrimaryKeyMapString(String primaryKeyMapString) {
        if (primaryKeyMapString == null) {
            String msg = "The argument[primaryKeyMapString] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        String prefix = "map:@{";
        String suffix = MAP_STRING_END_BRACE;
        if (!primaryKeyMapString.trim().startsWith("map:@{")) {
            primaryKeyMapString = "map:@{" + primaryKeyMapString;
        }
        if (!primaryKeyMapString.trim().endsWith(MAP_STRING_END_BRACE)) {
            primaryKeyMapString = primaryKeyMapString + MAP_STRING_END_BRACE;
        }
        MapListStringImpl mapListString = new MapListStringImpl();
        mapListString.setMapMark(MAP_STRING_MAP_MARK);
        mapListString.setListMark(MAP_STRING_LIST_MARK);
        mapListString.setDelimiter(MAP_STRING_DELIMITER);
        mapListString.setStartBrace(MAP_STRING_START_BRACE);
        mapListString.setEndBrace(MAP_STRING_END_BRACE);
        mapListString.setEqual(MAP_STRING_EQUAL);
        this.acceptPrimaryKeyMap(mapListString.generateMap(primaryKeyMapString));
    }

    protected void checkTypeString(Object value, String propertyName, String typeName) {
        if (value == null) {
            throw new IllegalArgumentException("The value should not be null: " + propertyName);
        }
        if (!(value instanceof String)) {
            String msg = "The value of " + propertyName + " should be " + typeName + " or String: ";
            msg = msg + "valueType=" + value.getClass() + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected long parseDateStringAsMillis(Object value, String propertyName, String typeName) {
        this.checkTypeString(value, propertyName, typeName);
        try {
            String valueString = (String)value;
            if (valueString.indexOf("-") >= 0 && valueString.indexOf("-") != valueString.lastIndexOf("-")) {
                return Timestamp.valueOf(valueString).getTime();
            }
            return this.getParseDateFormat().parse((String)value).getTime();
        }
        catch (ParseException e) {
            String msg = "The value of " + propertyName + " should be " + typeName + ". but: " + value;
            throw new RuntimeException(msg + " threw the exception: value=[" + value + "]", e);
        }
        catch (RuntimeException e) {
            String msg = "The value of " + propertyName + " should be " + typeName + ". but: " + value;
            throw new RuntimeException(msg + " threw the exception: value=[" + value + "]", e);
        }
    }

    private DateFormat getParseDateFormat() {
        return DateFormat.getDateTimeInstance();
    }

    @Override
    public boolean isPaging() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean isCountLater() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void paging(int pageSize, int pageNumber) {
        this.fetchFirst(pageSize);
        this.fetchPage(pageNumber);
    }

    @Override
    public void xsetPaging(boolean paging) {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void disablePagingReSelect() {
        this._canPagingReSelect = false;
    }

    @Override
    public boolean canPagingReSelect() {
        return this._canPagingReSelect;
    }

    @Override
    public PagingBean fetchFirst(int fetchSize) {
        this.getSqlClause().fetchFirst(fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchScope(int fetchStartIndex, int fetchSize) {
        this.getSqlClause().fetchScope(fetchStartIndex, fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchPage(int fetchPageNumber) {
        this.getSqlClause().fetchPage(fetchPageNumber);
        return this;
    }

    @Override
    public int getFetchStartIndex() {
        return this.getSqlClause().getFetchStartIndex();
    }

    @Override
    public int getFetchSize() {
        return this.getSqlClause().getFetchSize();
    }

    @Override
    public int getFetchPageNumber() {
        return this.getSqlClause().getFetchPageNumber();
    }

    @Override
    public int getPageStartIndex() {
        return this.getSqlClause().getPageStartIndex();
    }

    @Override
    public int getPageEndIndex() {
        return this.getSqlClause().getPageEndIndex();
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this.getSqlClause().isFetchScopeEffective();
    }

    public String getSelectHint() {
        return this.getSqlClause().getSelectHint();
    }

    public String getFromBaseTableHint() {
        return this.getSqlClause().getFromBaseTableHint();
    }

    public String getFromHint() {
        return this.getSqlClause().getFromHint();
    }

    public String getSqlSuffix() {
        return this.getSqlClause().getSqlSuffix();
    }

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getSqlClause().getFetchNarrowingSkipStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getSqlClause().getFetchNarrowingLoopCount();
    }

    @Override
    public boolean isFetchNarrowingSkipStartIndexEffective() {
        return !this.getSqlClause().isFetchStartIndexSupported();
    }

    @Override
    public boolean isFetchNarrowingLoopCountEffective() {
        return !this.getSqlClause().isFetchSizeSupported();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this.getSqlClause().isFetchNarrowingEffective();
    }

    @Override
    public void ignoreFetchNarrowing() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void restoreIgnoredFetchNarrowing() {
    }

    @Override
    public int getSafetyMaxResultSize() {
        return this._safetyMaxResultSize;
    }

    @Override
    public void checkSafetyResult(int safetyMaxResultSize) {
        this._safetyMaxResultSize = safetyMaxResultSize;
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this.getSqlClause().getSqlComponentOfOrderByClause();
    }

    @Override
    public String getOrderByClause() {
        return this._sqlClause.getOrderByClause();
    }

    @Override
    public OrderByBean clearOrderBy() {
        this.getSqlClause().clearOrderBy();
        return this;
    }

    @Override
    public OrderByBean ignoreOrderBy() {
        this.getSqlClause().ignoreOrderBy();
        return this;
    }

    @Override
    public OrderByBean makeOrderByEffective() {
        this.getSqlClause().makeOrderByEffective();
        return this;
    }

    @Override
    public ConditionBean lockForUpdate() {
        this.getSqlClause().lockForUpdate();
        return this;
    }

    @Override
    public ConditionBean xsetupSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = true;
        this.getSqlClause().classifySelectClauseType(SqlClause.SelectClauseType.COUNT);
        this.getSqlClause().ignoreOrderBy();
        this.getSqlClause().ignoreFetchScope();
        return this;
    }

    @Override
    public ConditionBean xafterCareSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = false;
        this.getSqlClause().rollbackSelectClauseType();
        this.getSqlClause().makeOrderByEffective();
        this.getSqlClause().makeFetchScopeEffective();
        return this;
    }

    @Override
    public boolean isSelectCountIgnoreFetchScope() {
        return this._isSelectCountIgnoreFetchScope;
    }

    @Override
    public void configure(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    @Override
    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    @Override
    public String toDisplaySql() {
        return ConditionBeanContext.convertConditionBean2DisplaySql(this, this.getLogDateFormat(), this.getLogTimestampFormat());
    }

    protected abstract String getLogDateFormat();

    protected abstract String getLogTimestampFormat();

    public void xsetupForDerivedReferrer() {
        this._forDerivedReferrer = true;
    }

    public void xsetupForScalarSelect() {
        this._forScalarSelect = true;
    }

    public void xsetupForScalarSubQuery() {
        this._forScalarSubQuery = true;
    }

    public void xsetupForUnion() {
        this._forUnion = true;
    }

    public void xsetupForExistsSubQuery() {
        this._forExistsSubQuery = true;
    }

    public void xsetupForInScopeSubQuery() {
        this._forInScopeSubQuery = true;
    }

    protected void doSetupSelect(SsCall callback) {
        String foreignPropertyName = callback.qf().getForeignPropertyName();
        this.assertSetupSelectBeforeUnion(foreignPropertyName);
        String foreignTableAliasName = callback.qf().getRealAliasName();
        String localRelationPath = this.localCQ().getRelationPath();
        this.getSqlClause().registerSelectedSelectColumn(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, localRelationPath);
        this.getSqlClause().registerSelectedForeignInfo(callback.qf().getRelationPath(), foreignPropertyName);
    }

    protected void assertPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        if (primaryKeyMap == null) {
            String msg = "The argument[primaryKeyMap] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (primaryKeyMap.isEmpty()) {
            String msg = "The argument[primaryKeyMap] must not be empty.";
            throw new IllegalArgumentException(msg);
        }
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        List<ColumnInfo> columnInfoList = dbmeta.getPrimaryUniqueInfo().getUniqueColumnList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnDbName = columnInfo.getColumnDbName();
            if (primaryKeyMap.containsKey(columnDbName)) continue;
            String msg = "The primaryKeyMap must have the value of " + columnDbName;
            throw new IllegalStateException(msg + ": primaryKeyMap --> " + primaryKeyMap);
        }
    }

    protected void assertSetupSelectBeforeUnion(String foreignPropertyName) {
        if (this.hasUnionQueryOrUnionAllQuery()) {
            this.throwSetupSelectAfterUnionException(this.getClass().getSimpleName(), foreignPropertyName);
        }
    }

    protected void throwSetupSelectAfterUnionException(String className, String foreignPropertyName) {
        String methodName = "setupSelect_" + this.initCap(foreignPropertyName) + "()";
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "You should NOT call " + methodName + " after calling union()!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + methodName + " should be called before calling union()." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    " + className + " cb = new " + className + "();" + this.getLineSeparator();
        msg = msg + "    cb." + methodName + "; // You should call here!" + this.getLineSeparator();
        msg = msg + "    cb.query().setXxx...;" + this.getLineSeparator();
        msg = msg + "    cb.union(new UnionQuery<" + className + ">() {" + this.getLineSeparator();
        msg = msg + "        public void query(" + className + " unionCB) {" + this.getLineSeparator();
        msg = msg + "            unionCB.query().setXxx...;" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    });" + this.getLineSeparator();
        msg = msg + "    // You should not call setupSelect after calling union()!" + this.getLineSeparator();
        msg = msg + "    // cb." + methodName + ";" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[SetupSelect Method]" + this.getLineSeparator() + methodName + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[ConditionBean SQL]" + this.getLineSeparator() + this.toDisplaySql() + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
        throw new IllegalStateException(msg);
    }

    protected String initCap(String str) {
        return DfStringUtil.initCap(str);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    public String toString() {
        try {
            return this.toDisplaySql();
        }
        catch (RuntimeException e) {
            return this.getSqlClause().getClause();
        }
    }

    protected static interface SsCall {
        public ConditionQuery qf();
    }

    public static class DerivedReferrerEntityPropertyNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DerivedReferrerEntityPropertyNotFoundException(String msg) {
            super(msg);
        }
    }

    public static class DerivedReferrerInvalidAliasNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DerivedReferrerInvalidAliasNameException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RAQSetupper<REFERRER_CB extends ConditionBean, LOCAL_CQ extends ConditionQuery> {
        public void setup(String var1, SubQuery<REFERRER_CB> var2, LOCAL_CQ var3, String var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RAFunction<REFERRER_CB extends ConditionBean, LOCAL_CQ extends ConditionQuery> {
        protected ConditionBean _baseCB;
        protected LOCAL_CQ _localCQ;
        protected RAQSetupper<REFERRER_CB, LOCAL_CQ> _querySetupper;
        protected DBMetaProvider _dbmetaProvider;

        public RAFunction(ConditionBean baseCB, LOCAL_CQ localCQ, RAQSetupper<REFERRER_CB, LOCAL_CQ> querySetupper, DBMetaProvider dbmetaProvider) {
            this._baseCB = baseCB;
            this._localCQ = localCQ;
            this._querySetupper = querySetupper;
            this._dbmetaProvider = dbmetaProvider;
        }

        public void count(SubQuery<REFERRER_CB> subQuery, String aliasName) {
            this.assertAliasName(aliasName);
            this._querySetupper.setup("count", subQuery, this._localCQ, aliasName.trim());
        }

        public void countDistinct(SubQuery<REFERRER_CB> subQuery, String aliasName) {
            this.assertAliasName(aliasName);
            this._querySetupper.setup("count(distinct", subQuery, this._localCQ, aliasName.trim());
        }

        public void max(SubQuery<REFERRER_CB> subQuery, String aliasName) {
            this.assertAliasName(aliasName);
            this._querySetupper.setup("max", subQuery, this._localCQ, aliasName.trim());
        }

        public void min(SubQuery<REFERRER_CB> subQuery, String aliasName) {
            this.assertAliasName(aliasName);
            this._querySetupper.setup("min", subQuery, this._localCQ, aliasName.trim());
        }

        public void sum(SubQuery<REFERRER_CB> subQuery, String aliasName) {
            this.assertAliasName(aliasName);
            this._querySetupper.setup("sum", subQuery, this._localCQ, aliasName.trim());
        }

        public void avg(SubQuery<REFERRER_CB> subQuery, String aliasName) {
            this.assertAliasName(aliasName);
            this._querySetupper.setup("avg", subQuery, this._localCQ, aliasName.trim());
        }

        protected void assertAliasName(String aliasName) {
            if (aliasName == null || aliasName.trim().length() == 0) {
                this.throwDerivedReferrerInvalidAliasNameException();
            }
            String tableDbName = this._baseCB.getTableDbName();
            DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(tableDbName);
            Method[] methods = dbmeta.getEntityType().getMethods();
            String targetMethodName = "set" + this.replaceString(aliasName, "_", "").toLowerCase();
            boolean existsSetterMethod = false;
            for (Method method : methods) {
                if (!method.getName().startsWith("set") || !targetMethodName.equals(method.getName().toLowerCase())) continue;
                existsSetterMethod = true;
                break;
            }
            if (!existsSetterMethod) {
                this.throwDerivedReferrerEntityPropertyNotFoundException(aliasName, dbmeta.getEntityType());
            }
        }

        protected void throwDerivedReferrerInvalidAliasNameException() {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "The alias name for derived-referrer was Invalid!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "You should set valid alias name. {NotNull, NotEmpty}" + this.getLineSeparator();
            msg = msg + "  For example:" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Wrong]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().columnPurchaseDatetime();" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    }, null); // *No! {null, \"\", \"   \"} are NG!" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Good!]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().columnPurchaseDatetime();" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\"); // *Point!" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Local Table]" + this.getLineSeparator() + this._localCQ.getTableDbName() + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new DerivedReferrerInvalidAliasNameException(msg);
        }

        protected void throwDerivedReferrerEntityPropertyNotFoundException(String aliasName, Class<?> entityType) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "A property for derived-referrer was Not Found in the entity!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "You should implement a property(setter and getter) in the entity." + this.getLineSeparator();
            msg = msg + "Or you should confirm whether the alias name has typo or not." + this.getLineSeparator();
            msg = msg + "  For example:" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [ConditionBean Invoking]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().columnPurchaseDatetime();" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Extended Entity]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    // At the entity of Purchase..." + this.getLineSeparator();
            msg = msg + "    protected Date _latestPurchaseDatetime;" + this.getLineSeparator();
            msg = msg + "    public Date getLatestPurchaseDatetime() {" + this.getLineSeparator();
            msg = msg + "        return _latestPurchaseDatetime;" + this.getLineSeparator();
            msg = msg + "    }" + this.getLineSeparator();
            msg = msg + "    public void setLatestPurchaseDatetime(Date latestPurchaseDatetime) {" + this.getLineSeparator();
            msg = msg + "        _latestPurchaseDatetime = latestPurchaseDatetime;" + this.getLineSeparator();
            msg = msg + "    }" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Alias Name]" + this.getLineSeparator() + aliasName + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Target Entity]" + this.getLineSeparator() + entityType + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new DerivedReferrerEntityPropertyNotFoundException(msg);
        }

        protected String replaceString(String text, String fromText, String toText) {
            return DfStringUtil.replace(text, fromText, toText);
        }

        protected String getLineSeparator() {
            return DfSystemUtil.getLineSeparator();
        }
    }

    public static class ScalarSelectInvalidForeignSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScalarSelectInvalidForeignSpecificationException(String msg) {
            super(msg);
        }
    }

    public static class ScalarSubQueryInvalidForeignSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScalarSubQueryInvalidForeignSpecificationException(String msg) {
            super(msg);
        }
    }

    public static class DerivedReferrerInvalidForeignSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DerivedReferrerInvalidForeignSpecificationException(String msg) {
            super(msg);
        }
    }

    public static class SpecifyColumnNotSetupSelectColumnException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SpecifyColumnNotSetupSelectColumnException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface SpQyCall<CQ extends ConditionQuery> {
        public boolean has();

        public CQ qy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractSpecification<CQ extends ConditionQuery> {
        protected ConditionBean _baseCB;
        protected SpQyCall<CQ> _qyCall;
        protected CQ _query;
        protected boolean _forDerivedReferrer;
        protected boolean _forScalarSelect;
        protected boolean _forScalarSubQuery;
        protected boolean _alreadySpecifyRequiredColumn;
        protected DBMetaProvider _dbmetaProvider;

        protected AbstractSpecification(ConditionBean baseCB, SpQyCall<CQ> qyCall, boolean forDerivedReferrer, boolean forScalarSelect, boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            this._baseCB = baseCB;
            this._qyCall = qyCall;
            this._forDerivedReferrer = forDerivedReferrer;
            this._forScalarSelect = forScalarSelect;
            this._forScalarSubQuery = forScalarSubQuery;
            this._dbmetaProvider = dbmetaProvider;
        }

        protected void doColumn(String columnName) {
            this.assertColumn(columnName);
            if (this._query == null) {
                this._query = this._qyCall.qy();
            }
            if (this.isRequiredColumnSpecificationEnabled()) {
                this._alreadySpecifyRequiredColumn = true;
                this.doSpecifyRequiredColumn();
            }
            String relationPath = this._query.getRelationPath() != null ? this._query.getRelationPath() : "";
            String tableAliasName = this._query.isBaseQuery((ConditionQuery)this._query) ? this._baseCB.getSqlClause().getLocalTableAliasName() : this._baseCB.getSqlClause().resolveJoinAliasName(relationPath, this._query.getNestLevel());
            this._baseCB.getSqlClause().specifySelectColumn(tableAliasName, columnName);
        }

        protected boolean isRequiredColumnSpecificationEnabled() {
            return !this._forDerivedReferrer && !this._forScalarSelect && !this._forScalarSubQuery && !this._alreadySpecifyRequiredColumn;
        }

        protected void assertColumn(String columnName) {
            if (this._query == null && !this._qyCall.has()) {
                this.throwSpecifyColumnNotSetupSelectColumnException(columnName);
            }
        }

        protected void assertForeign(String foreignPropertyName) {
            if (this._forDerivedReferrer) {
                this.throwDerivedReferrerInvalidForeignSpecificationException(foreignPropertyName);
            }
            if (this._forScalarSelect) {
                this.throwScalarSelectInvalidForeignSpecificationException(foreignPropertyName);
            }
            if (this._forScalarSubQuery) {
                this.throwScalarSubQueryInvalidForeignSpecificationException(foreignPropertyName);
            }
        }

        protected abstract void doSpecifyRequiredColumn();

        protected abstract String getTableDbName();

        protected void throwSpecifyColumnNotSetupSelectColumnException(String columnName) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "You specified the column that had Not been Set up!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "You should call setupSelect_[ForeignTable]() before calling specify[ForeignTable]().column[TargetColumn]()." + this.getLineSeparator();
            msg = msg + "  For example:" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Wrong]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.specify().specifyMemberStatus().columnMemberStatusName(); // *No!" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Good!]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.setupSelect_MemberStatus(); // *Point!" + this.getLineSeparator();
            msg = msg + "    cb.specify().specifyMemberStatus().columnMemberStatusName();" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[ConditionBean]" + this.getLineSeparator() + this._baseCB.getClass().getName() + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Specified Column]" + this.getLineSeparator() + this.getTableDbName() + "." + columnName + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new SpecifyColumnNotSetupSelectColumnException(msg);
        }

        protected void throwDerivedReferrerInvalidForeignSpecificationException(String foreignPropertyName) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "You specified a foreign table column in spite of derived-referrer!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "You should specified a local table column at condition-bean for derived-referrer." + this.getLineSeparator();
            msg = msg + "  For example(for SpecifyDerivedReferrer):" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Wrong]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.specify().derivedPurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().specifyProduct().columnProductName(); // *No!" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Good!]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.specify().derivedPurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().columnPurchaseDatetime();// *Point!" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Specified Foreign Property]" + this.getLineSeparator() + foreignPropertyName + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new DerivedReferrerInvalidForeignSpecificationException(msg);
        }

        protected void throwScalarSelectInvalidForeignSpecificationException(String foreignPropertyName) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "You specified a foreign table column in spite of scalar select!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "You should specified a local table column at condition-bean for scalar select." + this.getLineSeparator();
            msg = msg + "  For example:" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Wrong]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    memberBhv.scalarSelect(Integer.class).max(new ScalarSelect<MemberCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(MemberCB cb) {" + this.getLineSeparator();
            msg = msg + "            cb.specify().specifyMemberStatus().columnDisplayOrder(); // *No!" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    });" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Good!]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    memberBhv.scalarSelect(Date.class).max(new ScalarSelect() {" + this.getLineSeparator();
            msg = msg + "        public void query(MemberCB cb) {" + this.getLineSeparator();
            msg = msg + "            cb.specify().columnMemberBirthday(); // *Point!" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    });" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Specified Foreign Property]" + this.getLineSeparator() + foreignPropertyName + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new ScalarSelectInvalidForeignSpecificationException(msg);
        }

        protected void throwScalarSubQueryInvalidForeignSpecificationException(String foreignPropertyName) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "You specified a foreign table column in spite of derived-query!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "You should specified a local table column at condition-bean for derived-query." + this.getLineSeparator();
            msg = msg + "  For example:" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Wrong]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.query().scalar_Equal().max(new SubQuery<MemberCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(MemberCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().specifyMemberStatusName().columnDisplayOrder(); // *No!" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    });" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + "    " + this.getLineSeparator();
            msg = msg + "    [Good!]" + this.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
            msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
            msg = msg + "    cb.query().scalar_Equal().max(new SubQuery<MemberCB>() {" + this.getLineSeparator();
            msg = msg + "        public void query(MemberCB subCB) {" + this.getLineSeparator();
            msg = msg + "            subCB.specify().columnMemberBirthday();// *Point!" + this.getLineSeparator();
            msg = msg + "        }" + this.getLineSeparator();
            msg = msg + "    });" + this.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Specified Foreign Property]" + this.getLineSeparator() + foreignPropertyName + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new ScalarSubQueryInvalidForeignSpecificationException(msg);
        }

        protected String getLineSeparator() {
            return DfSystemUtil.getLineSeparator();
        }
    }
}

