/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.InScopeOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.exception.RequiredOptionNotFoundException;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.TraceViewUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionQuery
implements ConditionQuery {
    protected static final ConditionKey CK_EQ = ConditionKey.CK_EQUAL;
    protected static final ConditionKey CK_NE = ConditionKey.CK_NOT_EQUAL;
    protected static final ConditionKey CK_GE = ConditionKey.CK_GREATER_EQUAL;
    protected static final ConditionKey CK_GT = ConditionKey.CK_GREATER_THAN;
    protected static final ConditionKey CK_LE = ConditionKey.CK_LESS_EQUAL;
    protected static final ConditionKey CK_LT = ConditionKey.CK_LESS_THAN;
    protected static final ConditionKey CK_PS = ConditionKey.CK_PREFIX_SEARCH;
    protected static final ConditionKey CK_INS = ConditionKey.CK_IN_SCOPE;
    protected static final ConditionKey CK_NINS = ConditionKey.CK_NOT_IN_SCOPE;
    protected static final ConditionKey CK_LS = ConditionKey.CK_LIKE_SEARCH;
    protected static final ConditionKey CK_NLS = ConditionKey.CK_NOT_LIKE_SEARCH;
    protected static final ConditionKey CK_ISN = ConditionKey.CK_IS_NULL;
    protected static final ConditionKey CK_ISNN = ConditionKey.CK_IS_NOT_NULL;
    protected static final Object DOBJ = new Object();
    protected static final String CQ_PROPERTY = "conditionQuery";
    protected final SqlClause _sqlClause;
    protected final String _aliasName;
    protected final int _nestLevel;
    protected int _subQueryLevel;
    protected String _foreignPropertyName;
    protected String _relationPath;
    protected final ConditionQuery _childQuery;
    protected boolean _onClauseInline;
    protected Map<String, ConditionQuery> _unionQueryMap;
    protected Map<String, ConditionQuery> _unionAllQueryMap;

    public AbstractConditionQuery(ConditionQuery childQuery, SqlClause sqlClause, String aliasName, int nestLevel) {
        this._childQuery = childQuery;
        this._sqlClause = sqlClause;
        this._aliasName = aliasName;
        this._nestLevel = nestLevel;
    }

    protected abstract DBMetaProvider getDBMetaProvider();

    protected DBMeta findDBMeta(String tableFlexibleName) {
        return this.getDBMetaProvider().provideDBMetaChecked(tableFlexibleName);
    }

    @Override
    public ConditionQuery getChildQuery() {
        return this._childQuery;
    }

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    @Override
    public String getAliasName() {
        return this._aliasName;
    }

    @Override
    public int getNestLevel() {
        return this._nestLevel;
    }

    @Override
    public int getNextNestLevel() {
        return this._nestLevel + 1;
    }

    @Override
    public boolean isBaseQuery(ConditionQuery query) {
        return query.getChildQuery() == null;
    }

    @Override
    public int getSubQueryLevel() {
        return this._subQueryLevel;
    }

    @Override
    public String getRealAliasName() {
        return this.getAliasName();
    }

    @Override
    public String getRealColumnName(String columnName) {
        this.assertColumnName(columnName);
        return this.buildRealColumnName(this.getRealAliasName(), columnName);
    }

    protected String buildRealColumnName(String aliasName, String columnName) {
        return aliasName + "." + columnName;
    }

    @Override
    public String getForeignPropertyName() {
        return this._foreignPropertyName;
    }

    public void xsetForeignPropertyName(String foreignPropertyName) {
        this._foreignPropertyName = foreignPropertyName;
    }

    @Override
    public String getRelationPath() {
        return this._relationPath;
    }

    public void xsetRelationPath(String relationPath) {
        this._relationPath = relationPath;
    }

    public void xsetOnClauseInline(boolean onClauseInline) {
        this._onClauseInline = onClauseInline;
    }

    protected String getLocation(String columnPropertyName, ConditionKey key) {
        return this.getLocationBase(columnPropertyName) + "." + key.getConditionKey();
    }

    protected String getLocationBase() {
        StringBuffer sb = new StringBuffer();
        ConditionQuery query = this;
        while (true) {
            if (query.isBaseQuery(query)) break;
            String foreignPropertyName = query.getForeignPropertyName();
            if (foreignPropertyName == null) {
                String msg = "The foreignPropertyName of the query should not be null:";
                msg = msg + " query=" + query;
                throw new IllegalStateException(msg);
            }
            sb.insert(0, CQ_PROPERTY + this.initCap(foreignPropertyName) + ".");
            query = query.getChildQuery();
        }
        sb.insert(0, "conditionQuery.");
        return sb.toString();
    }

    protected String getLocationBase(String columnPropertyName) {
        return this.getLocationBase() + columnPropertyName;
    }

    public Map<String, ConditionQuery> getUnionQueryMap() {
        if (this._unionQueryMap == null) {
            this._unionQueryMap = new LinkedHashMap<String, ConditionQuery>();
        }
        return this._unionQueryMap;
    }

    public void xsetUnionQuery(ConditionQuery unionQuery) {
        this.xsetupUnion(unionQuery, false, this.getUnionQueryMap());
    }

    public Map<String, ConditionQuery> getUnionAllQueryMap() {
        if (this._unionAllQueryMap == null) {
            this._unionAllQueryMap = new LinkedHashMap<String, ConditionQuery>();
        }
        return this._unionAllQueryMap;
    }

    public void xsetUnionAllQuery(ConditionQuery unionAllQuery) {
        this.xsetupUnion(unionAllQuery, true, this.getUnionAllQueryMap());
    }

    protected void xsetupUnion(ConditionQuery unionQuery, boolean unionAll, Map<String, ConditionQuery> unionQueryMap) {
        if (unionQuery == null) {
            String msg = "The argument[unionQuery] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.reflectRelationOnUnionQuery(this, unionQuery);
        String key = (unionAll ? "unionAllQuery" : "unionQuery") + unionQueryMap.size();
        unionQueryMap.put(key, unionQuery);
        this.registerUnionQuery(unionQuery, unionAll, (unionAll ? "unionAllQueryMap" : "unionQueryMap") + "." + key);
    }

    protected abstract void reflectRelationOnUnionQuery(ConditionQuery var1, ConditionQuery var2);

    public boolean hasUnionQueryOrUnionAllQuery() {
        return this._unionQueryMap != null && !this._unionQueryMap.isEmpty() || this._unionAllQueryMap != null && !this._unionAllQueryMap.isEmpty();
    }

    public List<ConditionQuery> getUnionQueryList() {
        if (this._unionQueryMap == null) {
            return new ArrayList<ConditionQuery>();
        }
        return new ArrayList<ConditionQuery>(this._unionQueryMap.values());
    }

    public List<ConditionQuery> getUnionAllQueryList() {
        if (this._unionAllQueryMap == null) {
            return new ArrayList<ConditionQuery>();
        }
        return new ArrayList<ConditionQuery>(this._unionAllQueryMap.values());
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String colName) {
        if (key.isValidRegistration(cvalue, value, key.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName);
        }
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String colName, ConditionOption option) {
        if (key.isValidRegistration(cvalue, value, key.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, option);
        }
    }

    protected void regFTQ(Date fromDate, Date toDate, ConditionValue cvalue, String colName, FromToOption option) {
        Date filteredFromDate = option.filterFromDate(fromDate);
        ConditionKey fromKey = option.getFromDateConditionKey();
        if (fromKey.isValidRegistration(cvalue, filteredFromDate, fromKey.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            this.setupConditionValueAndRegisterWhereClause(fromKey, filteredFromDate, cvalue, colName);
        }
        Date filteredToDate = option.filterToDate(toDate);
        ConditionKey toKey = option.getToDateConditionKey();
        if (toKey.isValidRegistration(cvalue, filteredToDate, toKey.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            this.setupConditionValueAndRegisterWhereClause(toKey, filteredToDate, cvalue, colName);
        }
    }

    protected void regLSQ(ConditionKey key, String value, ConditionValue cvalue, String colName, LikeSearchOption option) {
        this.registerLikeSearchQuery(key, value, cvalue, colName, option);
    }

    protected void registerLikeSearchQuery(ConditionKey key, String value, ConditionValue cvalue, String colName, LikeSearchOption option) {
        String validationMsg = key.getConditionKey() + " of " + this.getRealAliasName() + "." + colName;
        if (!key.isValidRegistration(cvalue, value, validationMsg)) {
            return;
        }
        if (option == null) {
            this.throwLikeSearchOptionNotFoundException(colName, value);
            return;
        }
        if (value == null || !option.isSplit()) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, option);
            return;
        }
        String[] strArray = option.generateSplitValueArray(value);
        if (!option.isAsOrSplit()) {
            for (int i = 0; i < strArray.length; ++i) {
                String currentValue = strArray[i];
                this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, colName, option);
                List<LikeSearchOption.LikeAsOrCallback> callbackList = option.getLikeAsOrCallbackList();
                if (callbackList.isEmpty()) continue;
                this.getSqlClause().makeAdditionalConditionAsOrEffective();
                for (LikeSearchOption.LikeAsOrCallback likeAsOrCallback : callbackList) {
                    String additionalTargetPropertyName = likeAsOrCallback.getAdditionalTargetPropertyName();
                    String filteredValue = likeAsOrCallback.filterValue(currentValue);
                    LikeSearchOption optionDeepCopy = (LikeSearchOption)option.createDeepCopy();
                    optionDeepCopy.clearLikeAsOrCallback();
                    LikeSearchOption filteredOption = likeAsOrCallback.filterOption(optionDeepCopy);
                    this.invokeSetterLikeSearch(additionalTargetPropertyName, filteredValue, filteredOption);
                }
                this.getSqlClause().ignoreAdditionalConditionAsOr();
            }
        } else {
            for (int i = 0; i < strArray.length; ++i) {
                String currentValue = strArray[i];
                if (i == 0) {
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, colName, option);
                    continue;
                }
                this.getSqlClause().makeAdditionalConditionAsOrEffective();
                this.invokeSetterLikeSearch(colName, currentValue, option);
            }
            this.getSqlClause().ignoreAdditionalConditionAsOr();
        }
    }

    protected void throwLikeSearchOptionNotFoundException(String colName, String value) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMeta(this.getTableDbName());
        String capPropName = this.initCap(dbmeta.findPropertyName(colName));
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The likeSearchOption was Not Found! (Should not be null!)" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm your method call:" + this.getLineSeparator();
        String beanName = this.getClass().getSimpleName();
        String methodName = "set" + capPropName + "_LikeSearch('" + value + "', likeSearchOption);";
        msg = msg + "    " + beanName + "." + methodName + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
        throw new RequiredOptionNotFoundException(msg);
    }

    protected void invokeSetterLikeSearch(String columnFlexibleName, Object value, LikeSearchOption option) {
        if (value == null) {
            return;
        }
        DBMeta dbmeta = this.findDBMeta(this.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "set" + columnCapPropName + "_LikeSearch";
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, value.getClass(), LikeSearchOption.class);
        }
        catch (NoSuchMethodException e) {
            String msg = "The columnFlexibleName is not existing in this table: columnFlexibleName=" + columnFlexibleName;
            msg = msg + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new RuntimeException(msg, e);
        }
        try {
            method.invoke((Object)this, value, option);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void registerInScopeQuery(ConditionKey key, String value, ConditionValue cvalue, String colName, InScopeOption option) {
        if (key.isValidRegistration(cvalue, value, key.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            if (value != null && option.isSplit()) {
                String[] strArray = option.generateSplitValueArray(value);
                ArrayList<String> realValueList = new ArrayList<String>();
                for (int i = 0; i < strArray.length; ++i) {
                    String currentValue = strArray[i];
                    realValueList.add(currentValue);
                }
                this.setupConditionValueAndRegisterWhereClause(key, realValueList, cvalue, colName, option);
            } else {
                this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, option);
            }
        }
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String colName) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        String propertyName = dbmeta.findPropertyName(colName);
        String uncapPropName = this.initUncap(propertyName);
        if (key.isValidRegistration(cvalue, value, key.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key));
            if (this.isBaseQuery(this)) {
                this.getSqlClause().registerBaseTableInlineWhereClause(colName, key, cvalue);
            } else {
                this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), colName, key, cvalue, this._onClauseInline);
            }
        }
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String colName, ConditionOption option) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        String propertyName = dbmeta.findPropertyName(colName);
        String uncapPropName = this.initUncap(propertyName);
        if (key.isValidRegistration(cvalue, value, key.getConditionKey() + " of " + this.getRealAliasName() + "." + colName)) {
            key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key), option);
            if (this.isBaseQuery(this)) {
                this.getSqlClause().registerBaseTableInlineWhereClause(colName, key, cvalue, option);
            } else {
                this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), colName, key, cvalue, option, this._onClauseInline);
            }
        }
    }

    protected void registerInScopeSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerInScopeSubQuery(subQuery, columnName, relatedColumnName, propertyName, null);
    }

    protected void registerNotInScopeSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerInScopeSubQuery(subQuery, columnName, relatedColumnName, propertyName, "not");
    }

    protected void registerInScopeSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String inScopeOption) {
        this.assertObjectNotNull("InScopeSubQyery(" + columnName + ")", subQuery);
        inScopeOption = inScopeOption != null ? inScopeOption + " " : "";
        String realColumnName = this.getInScopeSubQueryRealColumnName(columnName);
        this.xincrementLocalSubQueryLevelIfNeeds(subQuery);
        String subQueryClause = this.getInScopeSubQuerySql(subQuery, relatedColumnName, propertyName);
        String ln = this.getLineSeparator();
        int subQueryLevel = subQuery.getSubQueryLevel();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
        String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
        String endIndent = "       ";
        String clause = realColumnName + " " + inScopeOption + "in (" + beginMark + subQueryClause + ln + endIndent + ")" + endMark;
        this.registerWhereClause(clause);
    }

    protected String getInScopeSubQueryRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getInScopeSubQuerySql(ConditionQuery subQuery, String relatedColumnName, String propertyName) {
        String tableAliasName = this.getSqlClause().getLocalTableAliasName();
        String selectClause = "select " + tableAliasName + "." + relatedColumnName;
        String fromWhereClause = this.buildPlainSubQueryFromWhereClause(subQuery, relatedColumnName, propertyName, selectClause, tableAliasName);
        return selectClause + " " + fromWhereClause;
    }

    protected void registerExistsSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerExistsSubQuery(subQuery, columnName, relatedColumnName, propertyName, null);
    }

    protected void registerNotExistsSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerExistsSubQuery(subQuery, columnName, relatedColumnName, propertyName, "not");
    }

    protected void registerExistsSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String existsOption) {
        this.assertObjectNotNull("ExistsSubQyery(" + columnName + ")", subQuery);
        existsOption = existsOption != null ? existsOption + " " : "";
        String realColumnName = this.getExistsSubQueryRealColumnName(columnName);
        this.xincrementLocalSubQueryLevelIfNeeds(subQuery);
        String subQueryClause = this.getExistsSubQuerySql(subQuery, realColumnName, relatedColumnName, propertyName);
        String ln = this.getLineSeparator();
        int subQueryLevel = subQuery.getSubQueryLevel();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
        String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
        String endIndent = "       ";
        String clause = existsOption + "exists (" + beginMark + subQueryClause + ln + endIndent + ")" + endMark;
        this.registerWhereClause(clause);
    }

    protected String getExistsSubQueryRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getExistsSubQuerySql(ConditionQuery subQuery, String realColumnName, String relatedColumnName, String propertyName) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        String tableAliasName = "dfsublocal_" + subQueryLevel;
        String selectClause = "select " + tableAliasName + "." + relatedColumnName;
        String fromWhereClause = this.buildCorrelationSubQueryFromWhereClause(subQuery, relatedColumnName, propertyName, selectClause, tableAliasName, realColumnName);
        return selectClause + " " + fromWhereClause;
    }

    protected void registerSpecifyDerivedReferrer(String function, ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String aliasName) {
        this.assertObjectNotNull("SpecifyDerivedReferrer(function)", function);
        this.assertObjectNotNull("SpecifyDerivedReferrer(" + columnName + ")", subQuery);
        String realColumnName = this.getSpecifyDerivedReferrerRealColumnName(columnName);
        this.xincrementLocalSubQueryLevelIfNeeds(subQuery);
        String subQueryClause = this.getSpecifyDerivedReferrerSubQuerySql(function, subQuery, realColumnName, relatedColumnName, propertyName, aliasName);
        String ln = this.getLineSeparator();
        int subQueryLevel = subQuery.getSubQueryLevel();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
        String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
        String endIndent = "       ";
        String clause = "(" + beginMark + subQueryClause + ln + endIndent + ") as " + aliasName + endMark;
        this.getSqlClause().specifyDeriveSubQuery(aliasName, clause);
    }

    protected String getSpecifyDerivedReferrerRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getSpecifyDerivedReferrerSubQuerySql(String function, ConditionQuery subQuery, String realColumnName, String relatedColumnName, String propertyName, String aliasName) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        String tableAliasName = "dfsublocal_" + subQueryLevel;
        String deriveColumnName = subQuery.getSqlClause().getSpecifiedColumnNameAsOne();
        if (deriveColumnName == null || deriveColumnName.trim().length() == 0) {
            this.throwSpecifyDerivedReferrerInvalidColumnSpecificationException(function, aliasName);
        }
        this.assertSpecifyDerivedReferrerColumnType(function, subQuery, deriveColumnName);
        subQuery.getSqlClause().clearSpecifiedSelectColumn();
        String connect = this.xbuildFunctionConnector(function);
        if (subQuery.getSqlClause().hasUnionQuery()) {
            String ln = this.getLineSeparator();
            String subQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
            String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
            String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
            DBMeta dbmeta = this.findDBMeta(subQuery.getTableDbName());
            if (!dbmeta.hasPrimaryKey() || dbmeta.hasTwoOrMorePrimaryKeys()) {
                String msg = "The derived-referrer is unsupported when no primary key or two-or-more primary keys:";
                msg = msg + " table=" + subQuery.getTableDbName();
                throw new UnsupportedOperationException(msg);
            }
            String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
            String selectClause = "select " + tableAliasName + "." + primaryKeyName + ", " + tableAliasName + "." + relatedColumnName + ", " + tableAliasName + "." + deriveColumnName;
            String fromWhereClause = this.buildPlainSubQueryFromWhereClause(subQuery, relatedColumnName, propertyName, selectClause, tableAliasName);
            String mainSql = selectClause + " " + fromWhereClause;
            String joinCondition = "dfsubquerymain." + relatedColumnName + " = " + realColumnName;
            return "select " + function + connect + "dfsubquerymain." + deriveColumnName + ")" + ln + "  from (" + beginMark + mainSql + ln + "       ) dfsubquerymain" + endMark + ln + " where " + joinCondition;
        }
        String selectClause = "select " + function + connect + tableAliasName + "." + deriveColumnName + ")";
        String fromWhereClause = this.buildCorrelationSubQueryFromWhereClause(subQuery, relatedColumnName, propertyName, selectClause, tableAliasName, realColumnName);
        return selectClause + " " + fromWhereClause;
    }

    protected void throwSpecifyDerivedReferrerInvalidColumnSpecificationException(String function, String aliasName) {
        String method = this.xconvertFunctionToMethod(function);
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The specified the column for derived-referrer was Invalid!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + " You should call specify().column[TargetColumn]() only once." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.specify().derivePurchaseList()." + method + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            // *No! It's empty!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.specify().derivePurchaseList()." + method + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseDatetime();" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseCount(); // *No! It's duplicated!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Good!]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.specify().derivePurchaseList()." + method + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseDatetime(); // *Point!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Alias Name]" + this.getLineSeparator() + aliasName + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new SpecifyDerivedReferrerInvalidColumnSpecificationException(msg);
    }

    protected void assertSpecifyDerivedReferrerColumnType(String function, ConditionQuery subQuery, String deriveColumnName) {
        DBMeta dbmeta = this.findDBMeta(subQuery.getTableDbName());
        Class<?> deriveColumnType = dbmeta.findColumnInfo(deriveColumnName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwSpecifyDerivedReferrerUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType);
        }
    }

    protected void throwSpecifyDerivedReferrerUnmatchedColumnTypeException(String function, String deriveColumnName, Class<?> deriveColumnType) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The type of the specified the column unmatched with the function!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "You should confirm the list as follow:" + this.getLineSeparator();
        msg = msg + "    count() : String, Number, Date *with distinct same" + this.getLineSeparator();
        msg = msg + "    max()   : String, Number, Date" + this.getLineSeparator();
        msg = msg + "    min()   : String, Number, Date" + this.getLineSeparator();
        msg = msg + "    sum()   : Number" + this.getLineSeparator();
        msg = msg + "    avg()   : Number" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Function]" + this.getLineSeparator() + function + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Derive Column]" + this.getLineSeparator() + deriveColumnName + "(" + deriveColumnType.getName() + ")" + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new SpecifyDerivedReferrerUnmatchedColumnTypeException(msg);
    }

    protected void registerQueryDerivedReferrer(String function, ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String operand, Object value, String parameterPropertyName) {
        this.assertObjectNotNull("QueryDerivedReferrer(function)", function);
        this.assertObjectNotNull("QueryDerivedReferrer(" + columnName + ")", subQuery);
        String realColumnName = this.getQueryDerivedReferrerRealColumnName(columnName);
        this.xincrementLocalSubQueryLevelIfNeeds(subQuery);
        String subQueryClause = this.getQueryDerivedReferrerSubQuerySql(function, subQuery, realColumnName, relatedColumnName, propertyName, value);
        String ln = this.getLineSeparator();
        int subQueryLevel = subQuery.getSubQueryLevel();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
        String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
        String endIndent = "       ";
        String parameter = "/*dto." + this.getLocationBase(parameterPropertyName) + "*/" + value;
        String clause = "(" + beginMark + subQueryClause + ln + endIndent + ") " + operand + " " + parameter + " " + endMark;
        this.registerWhereClause(clause);
    }

    protected String getQueryDerivedReferrerRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getQueryDerivedReferrerSubQuerySql(String function, ConditionQuery subQuery, String realColumnName, String relatedColumnName, String propertyName, Object value) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        String tableAliasName = "dfsublocal_" + subQueryLevel;
        String deriveColumnName = subQuery.getSqlClause().getSpecifiedColumnNameAsOne();
        if (deriveColumnName == null || deriveColumnName.trim().length() == 0) {
            this.throwQueryDerivedReferrerInvalidColumnSpecificationException(function);
        }
        this.assertQueryDerivedReferrerColumnType(function, subQuery, deriveColumnName, value);
        subQuery.getSqlClause().clearSpecifiedSelectColumn();
        String connect = this.xbuildFunctionConnector(function);
        if (subQuery.getSqlClause().hasUnionQuery()) {
            String ln = this.getLineSeparator();
            String subQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
            String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
            String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
            DBMeta dbmeta = this.findDBMeta(subQuery.getTableDbName());
            if (!dbmeta.hasPrimaryKey() || dbmeta.hasTwoOrMorePrimaryKeys()) {
                String msg = "The derived-referrer is unsupported when no primary key or two-or-more primary keys:";
                msg = msg + " table=" + subQuery.getTableDbName();
                throw new UnsupportedOperationException(msg);
            }
            String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
            String selectClause = "select " + tableAliasName + "." + primaryKeyName + ", " + tableAliasName + "." + relatedColumnName + ", " + tableAliasName + "." + deriveColumnName;
            String fromWhereClause = this.buildPlainSubQueryFromWhereClause(subQuery, relatedColumnName, propertyName, selectClause, tableAliasName);
            String mainSql = selectClause + " " + fromWhereClause;
            String joinCondition = "dfsubquerymain." + relatedColumnName + " = " + realColumnName;
            return "select " + function + connect + "dfsubquerymain." + deriveColumnName + ")" + ln + "  from (" + beginMark + mainSql + ln + "       ) dfsubquerymain" + endMark + ln + " where " + joinCondition;
        }
        String selectClause = "select " + function + connect + tableAliasName + "." + deriveColumnName + ")";
        String fromWhereClause = this.buildCorrelationSubQueryFromWhereClause(subQuery, relatedColumnName, propertyName, selectClause, tableAliasName, realColumnName);
        return selectClause + " " + fromWhereClause;
    }

    protected void throwQueryDerivedReferrerInvalidColumnSpecificationException(String function) {
        String method = this.xconvertFunctionToMethod(function);
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The specified the column for derived-referrer was Invalid!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + " You should call specify().column[TargetColumn]() only once." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.query().scalarPurchaseList()." + method + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            // *No! It's empty!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }).greaterEqual(123);" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.query().scalarPurchaseList()." + method + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseDatetime();" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseCount(); // *No! It's duplicated!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }).greaterEqual(123);" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Good!]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.query().scalarPurchaseList()." + method + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseDatetime(); // *Point!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }).greaterEqual(123);" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new QueryDerivedReferrerInvalidColumnSpecificationException(msg);
    }

    protected void assertQueryDerivedReferrerColumnType(String function, ConditionQuery subQuery, String deriveColumnName, Object value) {
        DBMeta dbmeta = this.findDBMeta(subQuery.getTableDbName());
        Class<?> deriveColumnType = dbmeta.findColumnInfo(deriveColumnName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType, value);
        }
        if (value != null) {
            Class<?> parameterType = value.getClass();
            if (String.class.isAssignableFrom(deriveColumnType) && !String.class.isAssignableFrom(parameterType)) {
                this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType, value);
            }
            if (Number.class.isAssignableFrom(deriveColumnType) && !Number.class.isAssignableFrom(parameterType)) {
                this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType, value);
            }
            if (Date.class.isAssignableFrom(deriveColumnType) && !Date.class.isAssignableFrom(parameterType)) {
                this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType, value);
            }
        }
    }

    protected void throwQueryDerivedReferrerUnmatchedColumnTypeException(String function, String deriveColumnName, Class<?> deriveColumnType, Object value) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The type of the specified the column unmatched with the function or the parameter!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "You should confirm the list as follow:" + this.getLineSeparator();
        msg = msg + "    count() : String, Number, Date *with distinct same" + this.getLineSeparator();
        msg = msg + "    max()   : String, Number, Date" + this.getLineSeparator();
        msg = msg + "    min()   : String, Number, Date" + this.getLineSeparator();
        msg = msg + "    sum()   : Number" + this.getLineSeparator();
        msg = msg + "    avg()   : Number" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Function]" + this.getLineSeparator() + function + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Derive Column]" + this.getLineSeparator() + deriveColumnName + "(" + deriveColumnType.getName() + ")" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Parameter Type]" + this.getLineSeparator() + (value != null ? value.getClass() : null) + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new QueryDerivedReferrerUnmatchedColumnTypeException(msg);
    }

    protected void registerScalarSubQuery(String function, ConditionQuery subQuery, String propertyName, String operand) {
        this.assertObjectNotNull("ScalarSubQuery(" + propertyName + ")", subQuery);
        String deriveColumnName = subQuery.getSqlClause().getSpecifiedColumnNameAsOne();
        if (deriveColumnName == null || deriveColumnName.trim().length() == 0) {
            this.throwScalarSubQueryInvalidColumnSpecificationException(function);
        }
        String deriveRealColumnName = this.getScalarSubQueryRealColumnName(deriveColumnName);
        this.xincrementLocalSubQueryLevelIfNeeds(subQuery);
        String subQueryClause = this.getScalarSubQuerySql(function, subQuery, propertyName);
        String ln = this.getLineSeparator();
        int subQueryLevel = subQuery.getSubQueryLevel();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
        String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
        String endIndent = "       ";
        String clause = deriveRealColumnName + " " + operand + " (" + beginMark + subQueryClause + ln + endIndent + ") " + endMark;
        this.registerWhereClause(clause);
    }

    protected String getScalarSubQueryRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getScalarSubQuerySql(String function, ConditionQuery subQuery, String propertyName) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        String tableAliasName = "dfsublocal_" + subQueryLevel;
        String deriveColumnName = subQuery.getSqlClause().getSpecifiedColumnNameAsOne();
        if (deriveColumnName == null || deriveColumnName.trim().length() == 0) {
            this.throwScalarSubQueryInvalidColumnSpecificationException(function);
        }
        this.assertScalarSubQueryColumnType(function, subQuery, deriveColumnName);
        subQuery.getSqlClause().clearSpecifiedSelectColumn();
        DBMeta dbmeta = this.findDBMeta(subQuery.getTableDbName());
        if (!dbmeta.hasPrimaryKey() || dbmeta.hasTwoOrMorePrimaryKeys()) {
            String msg = "The scalar-sub-query is unsupported when no primary key or two-or-more primary keys:";
            msg = msg + " table=" + subQuery.getTableDbName();
            throw new UnsupportedOperationException(msg);
        }
        String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        if (subQuery.getSqlClause().hasUnionQuery()) {
            String ln = this.getLineSeparator();
            String subQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
            String beginMark = this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity) + ln;
            String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
            String selectClause = "select " + tableAliasName + "." + primaryKeyName + ", " + tableAliasName + "." + deriveColumnName;
            String fromWhereClause = this.buildPlainSubQueryFromWhereClause(subQuery, primaryKeyName, propertyName, selectClause, tableAliasName);
            String mainSql = selectClause + " " + fromWhereClause;
            return "select " + function + "(dfsubquerymain." + deriveColumnName + ")" + ln + "  from (" + beginMark + mainSql + ln + "       ) dfsubquerymain" + endMark;
        }
        String selectClause = "select " + function + "(" + tableAliasName + "." + deriveColumnName + ")";
        String fromWhereClause = this.buildPlainSubQueryFromWhereClause(subQuery, primaryKeyName, propertyName, selectClause, tableAliasName);
        return selectClause + " " + fromWhereClause;
    }

    protected void throwScalarSubQueryInvalidColumnSpecificationException(String function) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The specified the column for derived-referrer was Invalid!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + " You should call specify().column[TargetColumn]() only once." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.query().scalar_Equal()." + function + "(new SubQuery<MemberCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(MemberCB subCB) {" + this.getLineSeparator();
        msg = msg + "            // *No! It's empty!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    });" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.query().scalar_Equal()." + function + "(new SubQuery<MemberCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(MemberCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnMemberBirthday();" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnMemberName(); // *No! It's duplicated!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    });" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Good!]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.query().scalar_Equal()." + function + "(new SubQuery<MemberCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(MemberCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseDatetime(); // *Point!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    });" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new ScalarSubQueryInvalidColumnSpecificationException(msg);
    }

    protected void assertScalarSubQueryColumnType(String function, ConditionQuery subQuery, String deriveColumnName) {
        DBMeta dbmeta = this.findDBMeta(subQuery.getTableDbName());
        Class<?> deriveColumnType = dbmeta.findColumnInfo(deriveColumnName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwScalarSubQueryUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType);
        }
    }

    protected void throwScalarSubQueryUnmatchedColumnTypeException(String function, String deriveColumnName, Class<?> deriveColumnType) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The type of the specified the column unmatched with the function!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "You should confirm the list as follow:" + this.getLineSeparator();
        msg = msg + "    max()   : String, Number, Date" + this.getLineSeparator();
        msg = msg + "    min()   : String, Number, Date" + this.getLineSeparator();
        msg = msg + "    sum()   : Number" + this.getLineSeparator();
        msg = msg + "    avg()   : Number" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Function]" + this.getLineSeparator() + function + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Derive Column]" + this.getLineSeparator() + deriveColumnName + "(" + deriveColumnType.getName() + ")" + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new ScalarSubQueryUnmatchedColumnTypeException(msg);
    }

    protected String buildPlainSubQueryFromWhereClause(ConditionQuery subQuery, String relatedColumnName, String propertyName, String selectClause, String tableAliasName) {
        String fromWhereClause = subQuery.getSqlClause().getClauseFromWhereWithUnionTemplate();
        if (tableAliasName != null) {
            fromWhereClause = this.replaceString(fromWhereClause, "dflocal", tableAliasName);
        }
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this.getLocationBase(propertyName) + ".");
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereFirstConditionMark(), "");
        return fromWhereClause;
    }

    protected String buildCorrelationSubQueryFromWhereClause(ConditionQuery subQuery, String relatedColumnName, String propertyName, String selectClause, String tableAliasName, String realColumnName) {
        String fromWhereClause = subQuery.getSqlClause().getClauseFromWhereWithWhereUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, "dflocal", tableAliasName);
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this.getLocationBase(propertyName) + ".");
        String joinCondition = tableAliasName + "." + relatedColumnName + " = " + realColumnName;
        String firstConditionAfter = this.getLineSeparator() + "   and ";
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getWhereClauseMark(), "where " + joinCondition);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getWhereFirstConditionMark(), joinCondition + firstConditionAfter);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereClauseMark(), "where " + joinCondition);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereFirstConditionMark(), joinCondition + firstConditionAfter);
        return fromWhereClause;
    }

    protected void xincrementLocalSubQueryLevelIfNeeds(ConditionQuery subQuery) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        if (this._subQueryLevel <= subQueryLevel) {
            this._subQueryLevel = subQueryLevel + 1;
        }
    }

    protected String xbuildFunctionConnector(String function) {
        if (function != null && function.endsWith("(distinct")) {
            return " ";
        }
        return "(";
    }

    protected String xconvertFunctionToMethod(String function) {
        if (function != null && function.contains("(")) {
            int index = function.indexOf("(");
            String front = function.substring(0, index);
            if (function.length() > front.length() + "(".length()) {
                String rear = function.substring(index + "(".length());
                function = front + this.initCap(rear);
            } else {
                function = front;
            }
        }
        return function;
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String colName) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        String propertyName = dbmeta.findPropertyName(colName);
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key));
        this.getSqlClause().registerWhereClause(this.getRealColumnName(colName), key, cvalue);
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String colName, ConditionOption option) {
        DBMeta dbmeta = this.getDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        String propertyName = dbmeta.findPropertyName(colName);
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key), option);
        this.getSqlClause().registerWhereClause(this.getRealColumnName(colName), key, cvalue, option);
    }

    protected void registerWhereClause(String whereClause) {
        this.getSqlClause().registerWhereClause(whereClause);
    }

    protected void registerInlineWhereClause(String whereClause) {
        if (this.isBaseQuery(this)) {
            this.getSqlClause().registerBaseTableInlineWhereClause(whereClause);
        } else {
            this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), whereClause, this._onClauseInline);
        }
    }

    public void registerUnionQuery(ConditionQuery unionQuery, boolean unionAll, String unionQueryPropertyName) {
        String unionQueryClause = this.getUnionQuerySql(unionQuery, unionQueryPropertyName);
        this.getSqlClause().registerUnionQuery(unionQueryClause, unionAll);
    }

    protected String getUnionQuerySql(ConditionQuery unionQuery, String unionQueryPropertyName) {
        String unionQueryClause;
        String fromClause = unionQuery.getSqlClause().getFromClause();
        String whereClause = unionQuery.getSqlClause().getWhereClause();
        if (whereClause.trim().length() <= 0) {
            unionQueryClause = fromClause + " " + this.getSqlClause().getUnionWhereClauseMark();
        } else {
            int whereIndex = whereClause.indexOf("where ");
            if (whereIndex < 0) {
                String msg = "The whereClause should have 'where' string: " + whereClause;
                throw new IllegalStateException(msg);
            }
            int clauseIndex = whereIndex + "where ".length();
            String mark = this.getSqlClause().getUnionWhereFirstConditionMark();
            unionQueryClause = fromClause + " " + whereClause.substring(0, clauseIndex) + mark + whereClause.substring(clauseIndex);
        }
        String oldStr = ".conditionQuery.";
        String newStr = ".conditionQuery." + unionQueryPropertyName + ".";
        return this.replaceString(unionQueryClause, ".conditionQuery.", newStr);
    }

    public void withNullsFirst() {
        this.getSqlClause().addNullsFirstToPreviousOrderBy();
    }

    public void withNullsLast() {
        this.getSqlClause().addNullsLastToPreviousOrderBy();
    }

    protected void registerSpecifiedDerivedOrderBy_Asc(String aliasName) {
        if (!this.getSqlClause().hasSpecifiedDeriveSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.getSqlClause().registerOrderBy(aliasName, null, true);
    }

    protected void registerSpecifiedDerivedOrderBy_Desc(String aliasName) {
        if (!this.getSqlClause().hasSpecifiedDeriveSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.getSqlClause().registerOrderBy(aliasName, null, false);
    }

    protected void throwSpecifiedDerivedOrderByAliasNameNotFoundException(String aliasName) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The aliasName was Not Found in specified alias names." + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "You should specified an alias name that is the same as one in specify-derived-referrer." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Wrong]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().specifyProduct().columnProductName(); // *No!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    cb.query().addSpecifiedDerivedOrderBy_Desc(\"WRONG_NAME_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + "    " + this.getLineSeparator();
        msg = msg + "    [Good!]" + this.getLineSeparator();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = msg + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = msg + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = msg + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = msg + "            subCB.specify().columnPurchaseDatetime();// *Point!" + this.getLineSeparator();
        msg = msg + "        }" + this.getLineSeparator();
        msg = msg + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    cb.query().addSpecifiedDerivedOrderBy_Desc(\"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = msg + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Not Found Alias Name]" + this.getLineSeparator() + aliasName + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new SpecifiedDerivedOrderByAliasNameNotFoundException(msg);
    }

    protected void registerOrderBy(String columnName, boolean ascOrDesc) {
        this.getSqlClause().registerOrderBy(this.getRealColumnName(columnName), null, ascOrDesc);
    }

    protected void regOBA(String columnName) {
        this.registerOrderBy(columnName, true);
    }

    protected void regOBD(String columnName) {
        this.registerOrderBy(columnName, false);
    }

    protected String resolveJoinAliasName(String relationPath, int nestLevel) {
        return this.getSqlClause().resolveJoinAliasName(relationPath, nestLevel);
    }

    protected String resolveNestLevelExpression(String name) {
        return this.getSqlClause().resolveNestLevelExpression(name, this.getNestLevel());
    }

    protected String resolveNextRelationPath(String tableName, String relationPropertyName) {
        int relationNo = this.getSqlClause().resolveRelationNo(tableName, relationPropertyName);
        String nextRelationPath = "_" + relationNo;
        if (this._relationPath != null) {
            nextRelationPath = this._relationPath + nextRelationPath;
        }
        return nextRelationPath;
    }

    protected String ppFxCd(String fixedCondition, String localAliasName, String foreignAliasName) {
        fixedCondition = this.replaceString(fixedCondition, "$$alias$$", foreignAliasName);
        fixedCondition = this.replaceString(fixedCondition, "$$foreignAlias$$", foreignAliasName);
        fixedCondition = this.replaceString(fixedCondition, "$$localAlias$$", localAliasName);
        fixedCondition = this.replaceString(fixedCondition, "$$locationBase$$.", "dto." + this.getLocationBase());
        return fixedCondition;
    }

    @Override
    public ConditionValue invokeValue(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        DBMeta dbmeta = this.findDBMeta(this.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "get" + columnCapPropName;
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0], columnFlexibleName);
        return (ConditionValue)this.helpInvokingCQMethod(this, method, new Object[0]);
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object value) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        this.assertStringNotNullAndNotTrimmedEmpty("conditionKeyName", conditionKeyName);
        if (value == null) {
            return;
        }
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String propertyName = container.getPropertyName();
        ConditionQuery cq = container.getConditionQuery();
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(propertyName));
        String methodName = "set" + columnCapPropName + "_" + this.initCap(conditionKeyName);
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[]{value.getClass()}, propertyName);
        this.helpInvokingCQMethod(cq, method, new Object[]{value});
    }

    @Override
    public void invokeOrderBy(String columnFlexibleName, boolean isAsc) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String propertyName = container.getPropertyName();
        ConditionQuery cq = container.getConditionQuery();
        String ascDesc = isAsc ? "Asc" : "Desc";
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(propertyName));
        String methodName = "addOrderBy_" + columnCapPropName + "_" + ascDesc;
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[0], propertyName);
        this.helpInvokingCQMethod(cq, method, new Object[0]);
    }

    @Override
    public ConditionQuery invokeForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "query" + this.initCap(foreignPropertyName);
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0], foreignPropertyName);
        return (ConditionQuery)this.helpInvokingCQMethod(this, method, new Object[0]);
    }

    private PropertyNameCQContainer helpExtractingPropertyNameCQContainer(String name) {
        String[] strings = name.split("\\.");
        int length = strings.length;
        String propertyName = null;
        ConditionQuery cq = this;
        int index = 0;
        for (String element : strings) {
            if (length == index + 1) {
                propertyName = element;
                break;
            }
            cq = cq.invokeForeignCQ(element);
            ++index;
        }
        return new PropertyNameCQContainer(propertyName, cq);
    }

    private Method helpGettingCQMethod(ConditionQuery cq, String methodName, Class<?>[] argTypes, String property) {
        try {
            return cq.getClass().getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            String msg = "The method is not existing:";
            msg = msg + " methodName=" + methodName;
            msg = msg + " argTypes=" + this.convertObjectArrayToStringView(argTypes);
            msg = msg + " tableName=" + cq.getTableDbName();
            msg = msg + " property=" + property;
            throw new IllegalStateException(msg, e);
        }
    }

    private Object helpInvokingCQMethod(ConditionQuery cq, Method method, Object[] args) {
        try {
            return method.invoke((Object)cq, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    protected String fRES(String value) {
        return this.filterRemoveEmptyString(value);
    }

    private String filterRemoveEmptyString(String value) {
        return value != null && !"".equals(value) ? value : null;
    }

    protected <PROPERTY_TYPE> List<PROPERTY_TYPE> cTL(Collection<PROPERTY_TYPE> col) {
        return this.convertToList(col);
    }

    private <PROPERTY_TYPE> List<PROPERTY_TYPE> convertToList(Collection<PROPERTY_TYPE> col) {
        if (col == null) {
            return null;
        }
        if (col instanceof List) {
            return this.filterRemoveNullOrEmptyValueFromList((List)col);
        }
        return this.filterRemoveNullOrEmptyValueFromList(new ArrayList<PROPERTY_TYPE>(col));
    }

    private <PROPERTY_TYPE> List<PROPERTY_TYPE> filterRemoveNullOrEmptyValueFromList(List<PROPERTY_TYPE> ls) {
        if (ls == null) {
            return null;
        }
        ArrayList<PROPERTY_TYPE> newList = new ArrayList<PROPERTY_TYPE>();
        for (PROPERTY_TYPE element : ls) {
            if (element == null || element instanceof String && ((String)element).length() == 0) continue;
            newList.add(element);
        }
        return newList;
    }

    public void doNss(NssCall callback) {
        String foreignPropertyName = callback.qf().getForeignPropertyName();
        String foreignTableAliasName = callback.qf().getRealAliasName();
        this.getSqlClause().registerSelectedSelectColumn(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, this.getRelationPath());
        this.getSqlClause().registerSelectedForeignInfo(callback.qf().getRelationPath(), foreignPropertyName);
    }

    protected void registerOuterJoin(ConditionQuery cq, Map<String, String> joinOnMap) {
        this.getSqlClause().registerOuterJoin(cq.getTableSqlName(), cq.getRealAliasName(), joinOnMap);
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return DfStringUtil.initCap(str);
    }

    protected String initUncap(String str) {
        return DfStringUtil.initUncap(str);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    protected String convertObjectArrayToStringView(Object[] objArray) {
        return TraceViewUtil.convertObjectArrayToStringView(objArray);
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertColumnName(String columnName) {
        if (columnName == null) {
            String msg = "The columnName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.trim().length() == 0) {
            String msg = "The columnName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.indexOf(",") >= 0) {
            String msg = "The columnName should not contain comma ',': " + columnName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertAliasName(String aliasName) {
        if (aliasName == null) {
            String msg = "The aliasName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.trim().length() == 0) {
            String msg = "The aliasName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.indexOf(",") >= 0) {
            String msg = "The aliasName should not contain comma ',': " + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":{aliasName=" + this._aliasName + ", nestLevel=" + this._nestLevel + ", subQueryLevel=" + this._subQueryLevel + ", foreignPropertyName=" + this._foreignPropertyName + ", relationPath=" + this._relationPath + ", onClauseInline=" + this._onClauseInline + "}";
    }

    public static interface NssCall {
        public ConditionQuery qf();
    }

    private static class PropertyNameCQContainer {
        protected String _propertyName;
        protected ConditionQuery _cq;

        public PropertyNameCQContainer(String propertyName, ConditionQuery cq) {
            this._propertyName = propertyName;
            this._cq = cq;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public ConditionQuery getConditionQuery() {
            return this._cq;
        }
    }

    public static class SpecifiedDerivedOrderByAliasNameNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SpecifiedDerivedOrderByAliasNameNotFoundException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface SSQSetupper<CB extends ConditionBean> {
        public void setup(String var1, SubQuery<CB> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SSQFunction<CB extends ConditionBean> {
        protected SSQSetupper<CB> _setupper;

        public SSQFunction(SSQSetupper<CB> setupper) {
            this._setupper = setupper;
        }

        public void max(SubQuery<CB> subQuery) {
            this._setupper.setup("max", subQuery);
        }

        public void min(SubQuery<CB> subQuery) {
            this._setupper.setup("min", subQuery);
        }

        public void sum(SubQuery<CB> subQuery) {
            this._setupper.setup("sum", subQuery);
        }

        public void avg(SubQuery<CB> subQuery) {
            this._setupper.setup("avg", subQuery);
        }
    }

    public static class ScalarSubQueryUnmatchedColumnTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScalarSubQueryUnmatchedColumnTypeException(String msg) {
            super(msg);
        }
    }

    public static class ScalarSubQueryInvalidColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScalarSubQueryInvalidColumnSpecificationException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QDRParameter<CB extends ConditionBean, PARAMETER> {
        protected String _function;
        protected SubQuery<CB> _subQuery;
        protected QDRSetupper<CB> _setupper;

        public QDRParameter(String function, SubQuery<CB> subQuery, QDRSetupper<CB> setupper) {
            this._function = function;
            this._subQuery = subQuery;
            this._setupper = setupper;
        }

        public void equal(PARAMETER value) {
            this._setupper.setup(this._function, this._subQuery, "=", value);
        }

        public void greaterThan(PARAMETER value) {
            this._setupper.setup(this._function, this._subQuery, ">", value);
        }

        public void lessThan(PARAMETER value) {
            this._setupper.setup(this._function, this._subQuery, "<", value);
        }

        public void greaterEqual(PARAMETER value) {
            this._setupper.setup(this._function, this._subQuery, ">=", value);
        }

        public void lessEqual(PARAMETER value) {
            this._setupper.setup(this._function, this._subQuery, "<=", value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface QDRSetupper<CB extends ConditionBean> {
        public void setup(String var1, SubQuery<CB> var2, String var3, Object var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QDRFunction<CB extends ConditionBean> {
        protected QDRSetupper<CB> _setupper;

        public QDRFunction(QDRSetupper<CB> setupper) {
            this._setupper = setupper;
        }

        public QDRParameter<CB, Integer> count(SubQuery<CB> subQuery) {
            return new QDRParameter("count", subQuery, this._setupper);
        }

        public QDRParameter<CB, Integer> countDistinct(SubQuery<CB> subQuery) {
            return new QDRParameter("count(distinct", subQuery, this._setupper);
        }

        public QDRParameter<CB, Object> max(SubQuery<CB> subQuery) {
            return new QDRParameter("max", subQuery, this._setupper);
        }

        public QDRParameter<CB, Object> min(SubQuery<CB> subQuery) {
            return new QDRParameter("min", subQuery, this._setupper);
        }

        public QDRParameter<CB, Number> sum(SubQuery<CB> subQuery) {
            return new QDRParameter("sum", subQuery, this._setupper);
        }

        public QDRParameter<CB, Number> avg(SubQuery<CB> subQuery) {
            return new QDRParameter("avg", subQuery, this._setupper);
        }
    }

    public static class QueryDerivedReferrerUnmatchedColumnTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public QueryDerivedReferrerUnmatchedColumnTypeException(String msg) {
            super(msg);
        }
    }

    public static class QueryDerivedReferrerInvalidColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public QueryDerivedReferrerInvalidColumnSpecificationException(String msg) {
            super(msg);
        }
    }

    public static class SpecifyDerivedReferrerUnmatchedColumnTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SpecifyDerivedReferrerUnmatchedColumnTypeException(String msg) {
            super(msg);
        }
    }

    public static class SpecifyDerivedReferrerInvalidColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SpecifyDerivedReferrerInvalidColumnSpecificationException(String msg) {
            super(msg);
        }
    }
}

