/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.AccessContext;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.SimplePagingBean;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.InScopeOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.grouping.GroupingOption;
import org.seasar.dbflute.cbean.grouping.GroupingRowEndDeterminer;
import org.seasar.dbflute.cbean.grouping.GroupingRowResource;
import org.seasar.dbflute.cbean.grouping.GroupingRowSetupper;
import org.seasar.dbflute.cbean.pagenavi.PageNumberLink;
import org.seasar.dbflute.cbean.pagenavi.PageNumberLinkSetupper;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityDuplicatedException;
import org.seasar.dbflute.jdbc.CursorHandler;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionBeanContext {
    private static final Log _log = LogFactory.getLog(ConditionBeanContext.class);
    private static final ThreadLocal<ConditionBean> _conditionBeanLocal = new ThreadLocal();
    private static final ThreadLocal<EntityRowHandler<? extends Entity>> _entityRowHandlerLocal = new ThreadLocal();

    public static ConditionBean getConditionBeanOnThread() {
        return _conditionBeanLocal.get();
    }

    public static void setConditionBeanOnThread(ConditionBean cb) {
        if (cb == null) {
            String msg = "The argument[cb] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _conditionBeanLocal.set(cb);
    }

    public static boolean isExistConditionBeanOnThread() {
        return _conditionBeanLocal.get() != null;
    }

    public static void clearConditionBeanOnThread() {
        _conditionBeanLocal.set(null);
    }

    public static EntityRowHandler<? extends Entity> getEntityRowHandlerOnThread() {
        return _entityRowHandlerLocal.get();
    }

    public static void setEntityRowHandlerOnThread(EntityRowHandler<? extends Entity> handler) {
        if (handler == null) {
            String msg = "The argument[handler] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _entityRowHandlerLocal.set(handler);
    }

    public static boolean isExistEntityRowHandlerOnThread() {
        return _entityRowHandlerLocal.get() != null;
    }

    public static void clearEntityRowHandlerOnThread() {
        _entityRowHandlerLocal.set(null);
    }

    public static boolean isTheArgumentConditionBean(Object dtoInstance) {
        return dtoInstance instanceof ConditionBean;
    }

    public static boolean isTheTypeConditionBean(Class<?> dtoClass) {
        return ConditionBean.class.isAssignableFrom(dtoClass);
    }

    public static void loadCoolClasses() {
        boolean debugEnabled = false;
        StringBuilder sb = new StringBuilder();
        Class clazz = SimplePagingBean.class;
        if (debugEnabled) {
            sb.append("  ...Loading class of " + clazz.getName() + " by " + clazz.getClassLoader().getClass()).append(ConditionBeanContext.getLineSeparator());
        }
        clazz = AccessContext.class;
        clazz = CallbackContext.class;
        clazz = EntityRowHandler.class;
        clazz = FromToOption.class;
        clazz = LikeSearchOption.class;
        clazz = InScopeOption.class;
        clazz = GroupingOption.class;
        clazz = GroupingRowEndDeterminer.class;
        clazz = GroupingRowResource.class;
        clazz = GroupingRowSetupper.class;
        clazz = PageNumberLink.class;
        clazz = PageNumberLinkSetupper.class;
        clazz = CursorHandler.class;
        if (debugEnabled) {
            sb.append("  ...Loading class of ...and so on");
        }
        if (debugEnabled) {
            _log.debug((Object)("{Initialize against the ClassLoader Headache}" + ConditionBeanContext.getLineSeparator() + sb));
        }
    }

    public static void throwEntityAlreadyDeletedException(Object searchKey4Log) {
        String msg = "Look! Read the message below." + ConditionBeanContext.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ConditionBeanContext.getLineSeparator();
        msg = msg + "The entity was Not Found! it has already been deleted!" + ConditionBeanContext.getLineSeparator();
        msg = msg + ConditionBeanContext.getLineSeparator();
        msg = msg + "[Advice]" + ConditionBeanContext.getLineSeparator();
        msg = msg + "Please confirm the existence of your target record on your database." + ConditionBeanContext.getLineSeparator();
        msg = msg + "Does the target record really created before this operation?" + ConditionBeanContext.getLineSeparator();
        msg = msg + "Has the target record been deleted by other thread?" + ConditionBeanContext.getLineSeparator();
        msg = msg + "It is precondition that the record exists on your database." + ConditionBeanContext.getLineSeparator();
        msg = msg + ConditionBeanContext.getLineSeparator();
        if (searchKey4Log != null && searchKey4Log instanceof ConditionBean) {
            ConditionBean cb = (ConditionBean)searchKey4Log;
            msg = msg + "[Display SQL]" + ConditionBeanContext.getLineSeparator() + cb.toDisplaySql() + ConditionBeanContext.getLineSeparator();
        } else {
            msg = msg + "[Search Condition]" + ConditionBeanContext.getLineSeparator() + searchKey4Log + ConditionBeanContext.getLineSeparator();
        }
        msg = msg + "* * * * * * * * * */";
        throw new EntityAlreadyDeletedException(msg);
    }

    public static void throwEntityDuplicatedException(String resultCountString, Object searchKey4Log, Throwable cause) {
        String msg = "Look! Read the message below." + ConditionBeanContext.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ConditionBeanContext.getLineSeparator();
        msg = msg + "The entity was Too Many! it has been duplicated. It should be the only one! But the resultCount=" + resultCountString + ConditionBeanContext.getLineSeparator();
        msg = msg + ConditionBeanContext.getLineSeparator();
        msg = msg + "[Advice]" + ConditionBeanContext.getLineSeparator();
        msg = msg + "Please confirm your search condition. Does it really select the only one?" + ConditionBeanContext.getLineSeparator();
        msg = msg + "Please confirm your database. Does it really exist the only one?" + ConditionBeanContext.getLineSeparator();
        msg = msg + ConditionBeanContext.getLineSeparator();
        if (searchKey4Log != null && searchKey4Log instanceof ConditionBean) {
            ConditionBean cb = (ConditionBean)searchKey4Log;
            msg = msg + "[Display SQL]" + ConditionBeanContext.getLineSeparator() + cb.toDisplaySql() + ConditionBeanContext.getLineSeparator();
        } else {
            msg = msg + "[Search Condition]" + ConditionBeanContext.getLineSeparator() + searchKey4Log + ConditionBeanContext.getLineSeparator();
        }
        msg = msg + "* * * * * * * * * */";
        if (cause != null) {
            throw new EntityDuplicatedException(msg, cause);
        }
        throw new EntityDuplicatedException(msg);
    }

    public static String convertConditionBean2DisplaySql(ConditionBean cb, String logDateFormat, String logTimestampFormat) {
        String twoWaySql = cb.getSqlClause().getClause();
        return SqlAnalyzer.convertTwoWaySql2DisplaySql(twoWaySql, cb, logDateFormat, logTimestampFormat);
    }

    protected static String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }
}

