/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.coption.SimpleStringOption;
import org.seasar.dbflute.cbean.coption.parts.local.JapaneseOptionPartsAgent;
import org.seasar.dbflute.resource.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikeSearchOption
extends SimpleStringOption {
    protected static final String LIKE_PREFIX = "prefix";
    protected static final String LIKE_SUFFIX = "suffix";
    protected static final String LIKE_CONTAIN = "contain";
    protected String _like;
    protected String _escape;
    protected boolean _asOrSplit;
    protected List<LikeAsOrCallback> _likeAsOrCallbackList;

    @Override
    public String getRearOption() {
        if (this._escape == null || this._escape.trim().length() == 0) {
            return "";
        }
        return " escape '" + this._escape + "'";
    }

    public boolean hasLikeAsOrCallback() {
        return this._likeAsOrCallbackList != null && !this._likeAsOrCallbackList.isEmpty();
    }

    public List<LikeAsOrCallback> getLikeAsOrCallbackList() {
        if (this._likeAsOrCallbackList == null) {
            this._likeAsOrCallbackList = new ArrayList<LikeAsOrCallback>();
        }
        return this._likeAsOrCallbackList;
    }

    public void addLikeAsOrCallback(LikeAsOrCallback likeAsOrCallback) {
        this.getLikeAsOrCallbackList().add(likeAsOrCallback);
    }

    public void clearLikeAsOrCallback() {
        this.getLikeAsOrCallbackList().clear();
    }

    public LikeSearchOption likePrefix() {
        this._like = LIKE_PREFIX;
        return this;
    }

    public LikeSearchOption likeSuffix() {
        this._like = LIKE_SUFFIX;
        return this;
    }

    public LikeSearchOption likeContain() {
        this._like = LIKE_CONTAIN;
        return this;
    }

    public LikeSearchOption escapeByPipeLine() {
        this._escape = "|";
        return this;
    }

    public LikeSearchOption escapeByAtMark() {
        this._escape = "@";
        return this;
    }

    public LikeSearchOption escapeBySlash() {
        this._escape = "/";
        return this;
    }

    public LikeSearchOption escapeByBackSlash() {
        this._escape = "\\";
        return this;
    }

    public LikeSearchOption splitBySpace() {
        return (LikeSearchOption)this.doSplitBySpace();
    }

    public LikeSearchOption splitBySpace(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitBySpace(splitLimitCount);
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte() {
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte();
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte(splitLimitCount);
    }

    public LikeSearchOption splitByPipeLine() {
        return (LikeSearchOption)this.doSplitByPipeLine();
    }

    public LikeSearchOption splitByPipeLine(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitByPipeLine(splitLimitCount);
    }

    public LikeSearchOption asOrSplit() {
        this._asOrSplit = true;
        return this;
    }

    public boolean isAsOrSplit() {
        return this._asOrSplit;
    }

    public LikeSearchOption toUpperCase() {
        return (LikeSearchOption)this.doToUpperCase();
    }

    public LikeSearchOption toLowerCase() {
        return (LikeSearchOption)this.doToLowerCase();
    }

    public LikeSearchOption toSingleByteSpace() {
        return (LikeSearchOption)this.doToSingleByteSpace();
    }

    public LikeSearchOption toSingleByteAlphabetNumber() {
        return (LikeSearchOption)this.doToSingleByteAlphabetNumber();
    }

    public LikeSearchOption toSingleByteAlphabetNumberMark() {
        return (LikeSearchOption)this.doToSingleByteAlphabetNumberMark();
    }

    public JapaneseOptionPartsAgent localJapanese() {
        return this.doLocalJapanese();
    }

    @Override
    public String generateRealValue(String value) {
        value = super.generateRealValue(value);
        if (this._escape != null && this._escape.trim().length() != 0) {
            String tmp = this.replace(value, this._escape, this._escape + this._escape);
            tmp = this.replace(tmp, "%", this._escape + "%");
            tmp = this.replace(tmp, "_", this._escape + "_");
            if (this.isCurrentDBDef(DBDef.Oracle)) {
                tmp = this.replace(tmp, "\uff05", this._escape + "\uff05");
                tmp = this.replace(tmp, "\uff3f", this._escape + "\uff3f");
            }
            value = tmp;
        }
        String wildCard = "%";
        if (this._like == null || this._like.trim().length() == 0) {
            return value;
        }
        if (this._like.equals(LIKE_PREFIX)) {
            return value + "%";
        }
        if (this._like.equals(LIKE_SUFFIX)) {
            return "%" + value;
        }
        if (this._like.equals(LIKE_CONTAIN)) {
            return "%" + value + "%";
        }
        String msg = "The like was wrong string: " + this._like;
        throw new IllegalStateException(msg);
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    @Override
    public Object createDeepCopy() {
        LikeSearchOption deepCopy = (LikeSearchOption)super.createDeepCopy();
        deepCopy._like = this._like;
        deepCopy._escape = this._escape;
        if (this.hasLikeAsOrCallback()) {
            Iterator<LikeAsOrCallback> ite = this._likeAsOrCallbackList.iterator();
            while (ite.hasNext()) {
                deepCopy.addLikeAsOrCallback(ite.next());
            }
        }
        return deepCopy;
    }

    @Override
    protected SimpleStringOption newDeepCopyInstance() {
        return new LikeSearchOption();
    }

    public String toString() {
        return "like=" + this._like + ", escape=" + this._escape + ", split=" + this.isSplit() + ", asOrSplit = " + this._asOrSplit;
    }

    public static abstract class DefaultLikeAsOrCallback
    implements LikeAsOrCallback {
        public String filterValue(String currentValue) {
            return currentValue;
        }

        public LikeSearchOption filterOption(LikeSearchOption optionDeepCopyWithoutCallback) {
            return optionDeepCopyWithoutCallback;
        }
    }

    public static interface LikeAsOrCallback {
        public String getAdditionalTargetPropertyName();

        public String filterValue(String var1);

        public LikeSearchOption filterOption(LikeSearchOption var1);
    }
}

