/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferrerInfo
implements RelationInfo {
    protected final String referrerPropertyName;
    protected final DBMeta localDBMeta;
    protected final DBMeta referrerDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> referrerLocalColumnInfoMap;
    protected final boolean oneToOne;

    public ReferrerInfo(String referrerPropertyName, DBMeta localDBMeta, DBMeta referrerDBMeta, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne) {
        this.assertObjectNotNull("referrerPropertyName", referrerPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("referrerDBMeta", referrerDBMeta);
        this.assertObjectNotNull("localReferrerColumnInfoMap", localReferrerColumnInfoMap);
        this.referrerPropertyName = referrerPropertyName;
        this.localDBMeta = localDBMeta;
        this.referrerDBMeta = referrerDBMeta;
        this.localReferrerColumnInfoMap = localReferrerColumnInfoMap;
        Set<ColumnInfo> keySet = localReferrerColumnInfoMap.keySet();
        this.referrerLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localReferrerColumnInfoMap.get(key);
            this.referrerLocalColumnInfoMap.put(value, key);
        }
        this.oneToOne = oneToOne;
    }

    public ColumnInfo findLocalByReferrer(String referrerColumnDbName) {
        ColumnInfo keyColumnInfo = this.referrerDBMeta.findColumnInfo(referrerColumnDbName);
        ColumnInfo resultColumnInfo = this.referrerLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by referrerColumnDbName in referrerLocalColumnInfoMap:";
            msg = msg + " referrerColumnDbName=" + referrerColumnDbName + " referrerLocalColumnInfoMap=" + this.referrerLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public ColumnInfo findReferrerByLocal(String localColumnDbName) {
        ColumnInfo keyColumnInfo = this.localDBMeta.findColumnInfo(localColumnDbName);
        ColumnInfo resultColumnInfo = this.localReferrerColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by localColumnDbName in localReferrerColumnInfoMap:";
            msg = msg + " localColumnDbName=" + localColumnDbName + " localReferrerColumnInfoMap=" + this.localReferrerColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public Method findSetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{List.class});
    }

    public Method findGetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    protected String buildInitCapPropertyName() {
        return this.initCap(this.referrerPropertyName);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getReferrerPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getReferrerDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalReferrerColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return true;
    }

    protected String initCap(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this.referrerPropertyName.hashCode() + this.localDBMeta.hashCode() + this.referrerDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ReferrerInfo)) {
            return false;
        }
        ReferrerInfo target = (ReferrerInfo)obj;
        if (!this.referrerPropertyName.equals(target.getReferrerPropertyName())) {
            return false;
        }
        if (!this.localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this.referrerDBMeta.equals(target.getReferrerDBMeta());
    }

    public String toString() {
        return this.localDBMeta.getTableDbName() + "." + this.referrerPropertyName + "<-" + this.referrerDBMeta.getTableDbName();
    }

    public String getReferrerPropertyName() {
        return this.referrerPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this.localDBMeta;
    }

    public DBMeta getReferrerDBMeta() {
        return this.referrerDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalReferrerColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this.localReferrerColumnInfoMap);
    }

    public Map<ColumnInfo, ColumnInfo> getReferrerLocalColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this.referrerLocalColumnInfoMap);
    }

    @Override
    public boolean isOneToOne() {
        return this.oneToOne;
    }
}

