/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.mapstring.impl;

import java.util.Arrays;
import java.util.List;
import org.seasar.dbflute.helper.mapstring.MapStringBuilder;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.helper.token.line.impl.LineTokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapStringBuilderImpl
implements MapStringBuilder {
    protected List<String> _columnNameList;
    protected String _msMapMark;
    protected String _msStartBrace;
    protected String _msEndBrace;
    protected String _msDelimiter;
    protected String _msEqual;
    protected boolean _trimDoubleQuotation;

    @Override
    public void setColumnNames(String[] columnNames) {
        this._columnNameList = Arrays.asList(columnNames);
    }

    @Override
    public void setColumnNameList(List<String> columnNameList) {
        this._columnNameList = columnNameList;
    }

    @Override
    public void setMsMapMark(String value) {
        this._msMapMark = value;
    }

    @Override
    public void setMsStartBrace(String value) {
        this._msStartBrace = value;
    }

    @Override
    public void setMsEndBrace(String value) {
        this._msEndBrace = value;
    }

    @Override
    public void setMsDelimiter(String value) {
        this._msDelimiter = value;
    }

    @Override
    public void setMsEqual(String value) {
        this._msEqual = value;
    }

    public void trimDoubleQuotation() {
        this._trimDoubleQuotation = true;
    }

    @Override
    public String buildByDelimiter(String values, String delimiter) {
        if (values == null) {
            String msg = "The argument[values] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (delimiter == null) {
            String msg = "The argument[delimiter] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.assertStringComponent();
        List<String> valueList = this.tokenize(values, delimiter);
        this.assertColumnValueList(this._columnNameList, valueList);
        StringBuffer sb = new StringBuffer();
        sb.append(this._msMapMark).append(this._msStartBrace);
        for (int i = 0; i < this._columnNameList.size(); ++i) {
            sb.append(this._columnNameList.get(i)).append(this._msEqual).append(valueList.get(i)).append(this._msDelimiter);
        }
        sb.delete(sb.length() - this._msDelimiter.length(), sb.length());
        sb.append(this._msEndBrace);
        return sb.toString();
    }

    @Override
    public String buildFromList(List<String> valueList) {
        if (valueList == null) {
            String msg = "The argument[valueList] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.assertStringComponent();
        this.assertColumnValueList(this._columnNameList, valueList);
        StringBuffer sb = new StringBuffer();
        sb.append(this._msMapMark).append(this._msStartBrace);
        for (int i = 0; i < this._columnNameList.size(); ++i) {
            sb.append(this._columnNameList.get(i)).append(this._msEqual).append(valueList.get(i)).append(this._msDelimiter);
        }
        sb.delete(sb.length() - this._msDelimiter.length(), sb.length());
        sb.append(this._msEndBrace);
        return sb.toString();
    }

    protected List<String> tokenize(String value, String delimiter) {
        LineTokenImpl lineToken = new LineTokenImpl();
        LineTokenizingOption lineTokenizingOption = new LineTokenizingOption();
        lineTokenizingOption.setDelimiter(delimiter);
        if (this._trimDoubleQuotation) {
            lineTokenizingOption.trimDoubleQuotation();
        }
        return lineToken.tokenize(value, lineTokenizingOption);
    }

    protected void assertStringComponent() {
        if (this._columnNameList == null) {
            String msg = "The columnNameList should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._columnNameList.isEmpty()) {
            String msg = "The columnNameList should not be empty.";
            throw new IllegalStateException(msg);
        }
        if (this._msMapMark == null) {
            String msg = "The msMapMark should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._msStartBrace == null) {
            String msg = "The msStartBrace should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._msEndBrace == null) {
            String msg = "The msEndBrace should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._msDelimiter == null) {
            String msg = "The msDelimiter should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._msEqual == null) {
            String msg = "The msEqual should not be null.";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertColumnValueList(List<String> columnNameList, List<String> valueList) {
        if (columnNameList.size() != valueList.size()) {
            String msg = "The length of columnNameList and valueList are difference. (" + columnNameList.size() + ", " + valueList.size() + ")";
            msg = msg + " columnNameList=" + columnNameList;
            msg = msg + " valueList=" + valueList;
            throw new MapStringBuilder.DifferentDelimiterCountException(msg, columnNameList, valueList);
        }
    }

    protected static final String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                buf.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            buf.append(text.substring(pos2, pos));
            buf.append(toText);
            pos2 = pos + fromText.length();
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }
}

