/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.resource;

import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.exception.EntityAlreadyExistsException;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.util.DfSystemUtil;

public class SQLExceptionHandler {
    public void handleSQLException(SQLException e) {
        this.handleSQLException(e, null, false);
    }

    public void handleSQLException(SQLException e, Statement statement) {
        this.handleSQLException(e, statement, false);
    }

    public void handleSQLException(SQLException e, Statement statement, boolean uniqueConstraintValid) {
        this.handleSQLException(e, statement, uniqueConstraintValid, null);
    }

    public void handleSQLException(SQLException e, Statement statement, boolean uniqueConstraintValid, String completeSql) {
        if (uniqueConstraintValid && this.isUniqueConstraintException(e)) {
            this.throwEntityAlreadyExistsException(e, statement, completeSql);
        }
        this.throwSQLFailureException(e, statement, completeSql);
    }

    protected boolean isUniqueConstraintException(SQLException e) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        return ResourceContext.isUniqueConstraintException(this.extractSQLState(e), e.getErrorCode());
    }

    protected void throwEntityAlreadyExistsException(SQLException e, Statement statement, String completeSql) {
        String invokeName;
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The entity already exists on the database!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the primary key whether it already exists on the database." + this.ln();
        msg = msg + "And confirm the unique constraint for other columns." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQLState]" + this.ln() + this.extractSQLState(e) + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ErrorCode]" + this.ln() + e.getErrorCode() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQLException]" + this.ln() + e.getClass().getName() + this.ln();
        msg = msg + e.getMessage() + this.ln();
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            msg = msg + this.ln();
            msg = msg + "[NextException]" + this.ln();
            msg = msg + nextEx.getClass().getName() + this.ln();
            msg = msg + nextEx.getMessage() + this.ln();
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                msg = msg + this.ln();
                msg = msg + "[NextNextException]" + this.ln();
                msg = msg + nextNextEx.getClass().getName() + this.ln();
                msg = msg + nextNextEx.getMessage() + this.ln();
            }
        }
        if ((invokeName = this.extractBehaviorInvokeName()) != null) {
            msg = msg + this.ln();
            msg = msg + "[Behavior]" + this.ln();
            msg = msg + invokeName + this.ln();
        }
        if (this.hasConditionBean()) {
            msg = msg + this.ln();
            msg = msg + "[ConditionBean]" + this.ln();
            msg = msg + this.getConditionBean().getClass().getName() + this.ln();
        }
        if (this.hasOutsideSqlContext()) {
            msg = msg + this.ln();
            msg = msg + "[OutsideSql]" + this.ln();
            msg = msg + this.getOutsideSqlContext().getOutsideSqlPath() + this.ln();
            msg = msg + this.ln();
            msg = msg + "[ParameterBean]" + this.ln();
            Object pmb = this.getOutsideSqlContext().getParameterBean();
            if (pmb != null) {
                msg = msg + pmb.getClass().getName() + this.ln();
                msg = msg + pmb + this.ln();
            } else {
                msg = msg + pmb + this.ln();
            }
        }
        if (statement != null) {
            msg = msg + this.ln();
            msg = msg + "[Statement]" + this.ln();
            msg = msg + statement.getClass().getName() + this.ln();
        }
        if (completeSql != null) {
            msg = msg + this.ln();
            msg = msg + "[Display SQL]" + this.ln();
            msg = msg + completeSql + this.ln();
        }
        msg = msg + "* * * * * * * * * */";
        throw new EntityAlreadyExistsException(msg, e);
    }

    protected void throwSQLFailureException(SQLException e, Statement statement, String completeSql) {
        String invokeName;
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The SQL failed to execute!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the SQLException message." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQLState]" + this.ln() + this.extractSQLState(e) + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ErrorCode]" + this.ln() + e.getErrorCode() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQLException]" + this.ln() + e.getClass().getName() + this.ln();
        msg = msg + e.getMessage() + this.ln();
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            msg = msg + this.ln();
            msg = msg + "[NextException]" + this.ln();
            msg = msg + nextEx.getClass().getName() + this.ln();
            msg = msg + nextEx.getMessage() + this.ln();
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                msg = msg + this.ln();
                msg = msg + "[NextNextException]" + this.ln();
                msg = msg + nextNextEx.getClass().getName() + this.ln();
                msg = msg + nextNextEx.getMessage() + this.ln();
            }
        }
        if ((invokeName = this.extractBehaviorInvokeName()) != null) {
            msg = msg + this.ln();
            msg = msg + "[Behavior]" + this.ln();
            msg = msg + invokeName + this.ln();
        }
        if (this.hasConditionBean()) {
            msg = msg + this.ln();
            msg = msg + "[ConditionBean]" + this.ln();
            msg = msg + this.getConditionBean().getClass().getName() + this.ln();
        }
        if (this.hasOutsideSqlContext()) {
            msg = msg + this.ln();
            msg = msg + "[OutsideSql]" + this.ln();
            msg = msg + this.getOutsideSqlContext().getOutsideSqlPath() + this.ln();
            msg = msg + this.ln();
            msg = msg + "[ParameterBean]" + this.ln();
            Object pmb = this.getOutsideSqlContext().getParameterBean();
            if (pmb != null) {
                msg = msg + pmb.getClass().getName() + this.ln();
                msg = msg + pmb + this.ln();
            } else {
                msg = msg + pmb + this.ln();
            }
        }
        if (statement != null) {
            msg = msg + this.ln();
            msg = msg + "[Statement]" + this.ln();
            msg = msg + statement.getClass().getName() + this.ln();
        }
        if (completeSql != null) {
            msg = msg + this.ln();
            msg = msg + "[Display SQL]" + this.ln();
            msg = msg + completeSql + this.ln();
        }
        msg = msg + "* * * * * * * * * */";
        throw new SQLFailureException(msg, e);
    }

    protected String extractSQLState(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextEx = e.getNextException();
        if (nextEx == null) {
            return null;
        }
        sqlState = nextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextEx = nextEx.getNextException();
        if (nextNextEx == null) {
            return null;
        }
        sqlState = nextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextNextEx = nextNextEx.getNextException();
        if (nextNextNextEx == null) {
            return null;
        }
        sqlState = nextNextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        return null;
    }

    protected String extractBehaviorInvokeName() {
        Object behaviorInvokeName = InternalMapContext.getObject("df:BehaviorInvokeName");
        if (behaviorInvokeName == null) {
            return null;
        }
        Object clientInvokeName = InternalMapContext.getObject("df:ClientInvokeName");
        Object byPassInvokeName = InternalMapContext.getObject("df:ByPassInvokeName");
        StringBuilder sb = new StringBuilder();
        boolean existsPath = false;
        if (clientInvokeName != null) {
            existsPath = true;
            sb.append(clientInvokeName);
        }
        if (byPassInvokeName != null) {
            existsPath = true;
            sb.append(byPassInvokeName);
        }
        sb.append(behaviorInvokeName);
        if (existsPath) {
            sb.append("...");
        }
        return sb.toString();
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected ConditionBean getConditionBean() {
        return ConditionBeanContext.getConditionBeanOnThread();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

