/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnUpdateAutoHandler;

public class TnUpdateAutoDynamicCommand
extends TnAbstractSqlCommand {
    private static final Integer NO_UPDATE = new Integer(1);
    private TnBeanMetaData beanMetaData;
    private String[] propertyNames;
    private boolean optimisticLockHandling;
    private boolean versionNoAutoIncrementOnMemory;

    public TnUpdateAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    public Object execute(Object[] args) {
        Object bean = args[0];
        TnBeanMetaData bmd = this.getBeanMetaData();
        TnPropertyType[] propertyTypes = this.createUpdatePropertyTypes(bmd, bean, this.getPropertyNames());
        if (propertyTypes.length == 0) {
            if (this.isLogEnabled()) {
                this.log(this.createNoUpdateLogMessage(bean, bmd));
            }
            return NO_UPDATE;
        }
        TnUpdateAutoHandler handler = this.createInternalUpdateAutoHandler(bmd, propertyTypes);
        handler.setSql(this.createUpdateSql(bmd, propertyTypes, bean));
        handler.setLoggingMessageSqlArgs(args);
        int i = handler.execute(args);
        return new Integer(i);
    }

    protected TnUpdateAutoHandler createInternalUpdateAutoHandler(TnBeanMetaData bmd, TnPropertyType[] propertyTypes) {
        TnUpdateAutoHandler handler = new TnUpdateAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        handler.setOptimisticLockHandling(this.optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this.versionNoAutoIncrementOnMemory);
        return handler;
    }

    protected TnPropertyType[] createUpdatePropertyTypes(TnBeanMetaData bmd, Object bean, String[] propertyNames) {
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            TnPropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() || !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName) && pt.getPropertyDesc().getValue(bean) == null) continue;
            types.add(pt);
        }
        if (types.isEmpty()) {
            String msg = "The property type for update was not found:";
            msg = msg + " propertyNames=" + propertyNames;
            throw new IllegalStateException(msg);
        }
        TnPropertyType[] propertyTypes = types.toArray(new TnPropertyType[types.size()]);
        return propertyTypes;
    }

    protected String createNoUpdateLogMessage(Object bean, TnBeanMetaData bmd) {
        StringBuffer sb = new StringBuffer();
        sb.append("skip UPDATE: table=").append(bmd.getTableName());
        int size = bmd.getPrimaryKeySize();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append(", key{");
            } else {
                sb.append(", ");
            }
            String keyName = bmd.getPrimaryKey(i);
            sb.append(keyName).append("=");
            sb.append(bmd.getPropertyTypeByColumnName(keyName).getPropertyDesc().getValue(bean));
            if (i != size - 1) continue;
            sb.append("}");
        }
        String s = new String(sb);
        return s;
    }

    protected String createUpdateSql(TnBeanMetaData bmd, TnPropertyType[] propertyTypes, Object bean) {
        int i;
        if (bmd.getPrimaryKeySize() == 0) {
            String msg = "The table '" + bmd.getTableName() + "' does not have primary keys!";
            throw new IllegalStateException(msg);
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("update ");
        sb.append(bmd.getTableName());
        sb.append(" set ");
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            String columnName = pt.getColumnName();
            if (i > 0) {
                sb.append(", ");
            }
            if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                if (!this.isVersionNoAutoIncrementOnMemory()) {
                    this.setupVersionNoAutoIncrementOnQuery(sb, columnName);
                    continue;
                }
                Object versionNo = pt.getPropertyDesc().getValue(bean);
                if (versionNo == null) {
                    this.setupVersionNoAutoIncrementOnQuery(sb, columnName);
                    continue;
                }
            }
            sb.append(columnName).append(" = ?");
        }
        sb.append(" where ");
        for (i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            sb.append(bmd.getPrimaryKey(i)).append(" = ? and ");
        }
        sb.setLength(sb.length() - 5);
        if (this.optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
        if (this.optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
        return sb.toString();
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    protected boolean isVersionNoAutoIncrementOnMemory() {
        return this.versionNoAutoIncrementOnMemory;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this.versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }

    protected void setupVersionNoAutoIncrementOnQuery(StringBuilder sb, String columnName) {
        sb.append(columnName).append(" = ").append(columnName).append(" + 1");
    }

    public TnBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this.optimisticLockHandling = optimisticLockHandling;
    }
}

