/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;

public class CompleteSqlBuilder {
    private static final String NULL = "null";
    protected static final Class<?>[] TOTEXT_ARGUMENT_TYPES = new Class[]{Object.class};
    protected static final Method TOTEXT_METHOD;

    private CompleteSqlBuilder() {
    }

    public static String getCompleteSql(String sql, Object[] args, String logDateFormat, String logTimestampFormat) {
        if (args == null || args.length == 0) {
            return sql;
        }
        return CompleteSqlBuilder.getCompleteSql(sql, args, new ValueType[args.length], logDateFormat, logTimestampFormat);
    }

    public static String getCompleteSql(String sql, Object[] args, ValueType[] valueTypes, String logDateFormat, String logTimestampFormat) {
        if (args == null || args.length == 0) {
            return sql;
        }
        StringBuilder buf = new StringBuilder(sql.length() + args.length * 15);
        int pos = 0;
        int pos2 = 0;
        int pos3 = 0;
        int pos4 = 0;
        int pos5 = 0;
        int pos6 = 0;
        int index = 0;
        while (true) {
            pos = sql.indexOf(63, pos2);
            pos3 = sql.indexOf(39, pos2);
            pos4 = sql.indexOf(39, pos3 + 1);
            pos5 = sql.indexOf("/*", pos2);
            pos6 = sql.indexOf("*/", pos5 + 1);
            if (pos <= 0) break;
            if (pos3 >= 0 && pos3 < pos && pos < pos4) {
                buf.append(sql.substring(pos2, pos4 + 1));
                pos2 = pos4 + 1;
                continue;
            }
            if (pos5 >= 0 && pos5 < pos && pos < pos6) {
                buf.append(sql.substring(pos2, pos6 + 1));
                pos2 = pos6 + 1;
                continue;
            }
            if (args.length <= index) {
                String msg = "The size of bind arguments is illegal:";
                msg = msg + " size=" + args.length + " sql=" + sql;
                throw new IllegalStateException(msg);
            }
            buf.append(sql.substring(pos2, pos));
            buf.append(CompleteSqlBuilder.getBindVariableText(args[index], valueTypes[index], logDateFormat, logTimestampFormat));
            pos2 = pos + 1;
            ++index;
        }
        buf.append(sql.substring(pos2));
        return buf.toString();
    }

    protected static String getLogDateFormat() {
        String logDateFormat = ResourceContext.getLogDateFormat();
        return logDateFormat != null ? logDateFormat : "yyyy-MM-dd";
    }

    protected static String getLogTimestampFormat() {
        String logTimestampFormat = ResourceContext.getLogTimestampFormat();
        return logTimestampFormat != null ? logTimestampFormat : "yyyy-MM-dd HH:mm:ss";
    }

    public static String getBindVariableText(Object bindVariable, ValueType valueType, String logDateFormat, String logTimestampFormat) {
        if (valueType != null && TOTEXT_METHOD != null) {
            try {
                return (String)TOTEXT_METHOD.invoke((Object)valueType, bindVariable);
            }
            catch (IllegalArgumentException e) {
                String msg = "ValueType.toText() threw the IllegalArgumentException:";
                msg = msg + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = "ValueType.toText() threw the IllegalAccessException:";
                msg = msg + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                String msg = "ValueType.toText() threw the exception:";
                msg = msg + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e.getTargetException());
            }
        }
        return CompleteSqlBuilder.getBindVariableText(bindVariable, logDateFormat, logTimestampFormat);
    }

    public static String getBindVariableText(Object bindVariable, String logDateFormat, String logTimestampFormat) {
        if (bindVariable instanceof String) {
            return CompleteSqlBuilder.quote(bindVariable.toString());
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Time) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            return CompleteSqlBuilder.quote(sdf.format((Date)bindVariable));
        }
        if (bindVariable instanceof Timestamp) {
            String format = logTimestampFormat != null ? logTimestampFormat : "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return CompleteSqlBuilder.quote(sdf.format((Date)bindVariable));
        }
        if (bindVariable instanceof Date) {
            String format = logDateFormat != null ? logDateFormat : "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return CompleteSqlBuilder.quote(sdf.format((Date)bindVariable));
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return NULL;
        }
        return CompleteSqlBuilder.quote(bindVariable.toString());
    }

    protected static String quote(String text) {
        return "'" + text + "'";
    }

    static {
        Method method = null;
        try {
            method = ValueType.class.getMethod("toText", TOTEXT_ARGUMENT_TYPES);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        TOTEXT_METHOD = method;
    }
}

