/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql;

import java.util.Stack;
import org.seasar.dbflute.exception.EndCommentNotFoundException;
import org.seasar.dbflute.exception.IfCommentConditionNotFoundException;
import org.seasar.dbflute.twowaysql.CompleteSqlBuilder;
import org.seasar.dbflute.twowaysql.SqlTokenizer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.node.AbstractNode;
import org.seasar.dbflute.twowaysql.node.BeginNode;
import org.seasar.dbflute.twowaysql.node.BindVariableNode;
import org.seasar.dbflute.twowaysql.node.ContainerNode;
import org.seasar.dbflute.twowaysql.node.ElseNode;
import org.seasar.dbflute.twowaysql.node.EmbeddedValueNode;
import org.seasar.dbflute.twowaysql.node.IfNode;
import org.seasar.dbflute.twowaysql.node.Node;
import org.seasar.dbflute.twowaysql.node.PrefixSqlNode;
import org.seasar.dbflute.twowaysql.node.SqlNode;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAnalyzer {
    protected String specifiedSql;
    protected boolean blockNullParameter;
    protected SqlTokenizer tokenizer;
    protected Stack<Node> nodeStack = new Stack();

    public SqlAnalyzer(String sql, boolean blockNullParameter) {
        sql = sql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this.specifiedSql = sql;
        this.blockNullParameter = blockNullParameter;
        this.tokenizer = new SqlTokenizer(sql);
    }

    public Node parse() {
        this.push(new ContainerNode());
        while (99 != this.tokenizer.next()) {
            this.parseToken();
        }
        return this.pop();
    }

    protected void parseToken() {
        switch (this.tokenizer.getTokenType()) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
            }
        }
    }

    protected void parseSql() {
        Node node;
        String sql = this.tokenizer.getToken();
        if (this.isElseMode()) {
            sql = MyStringUtil.replace(sql, "--", "");
        }
        if (((node = this.peek()) instanceof IfNode || node instanceof ElseNode) && node.getChildSize() == 0) {
            SqlTokenizer st = new SqlTokenizer(sql);
            st.skipWhitespace();
            String token = st.skipToken();
            st.skipWhitespace();
            if (sql.startsWith(",")) {
                if (sql.startsWith(", ")) {
                    node.addChild(new PrefixSqlNode(", ", sql.substring(2)));
                } else {
                    node.addChild(new PrefixSqlNode(",", sql.substring(1)));
                }
            } else if ("AND".equalsIgnoreCase(token) || "OR".equalsIgnoreCase(token)) {
                node.addChild(new PrefixSqlNode(st.getBefore(), st.getAfter()));
            } else {
                node.addChild(new SqlNode(sql));
            }
        } else {
            node.addChild(new SqlNode(sql));
        }
    }

    protected void parseComment() {
        String comment = this.tokenizer.getToken();
        if (SqlAnalyzer.isTargetComment(comment)) {
            if (SqlAnalyzer.isIfComment(comment)) {
                this.parseIf();
            } else if (SqlAnalyzer.isBeginComment(comment)) {
                this.parseBegin();
            } else {
                if (SqlAnalyzer.isEndComment(comment)) {
                    return;
                }
                this.parseCommentBindVariable();
            }
        } else if (comment != null && 0 < comment.length()) {
            String before = this.tokenizer.getBefore();
            this.peek().addChild(new SqlNode(before.substring(before.lastIndexOf("/*"))));
        }
    }

    protected void parseIf() {
        String condition = this.tokenizer.getToken().substring(2).trim();
        if (MyStringUtil.isEmpty(condition)) {
            this.throwIfCommentConditionNotFoundException();
        }
        ContainerNode ifNode = this.createIfNode(condition);
        this.peek().addChild(ifNode);
        this.push(ifNode);
        this.parseEnd();
    }

    protected void throwIfCommentConditionNotFoundException() {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The condition of IF comment was Not Found!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the IF comment expression." + this.getLineSeparator();
        msg = msg + "It may exist the IF comment that DOESN'T have a condition." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    before (x) -- /*IF*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = msg + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[IF Comment Expression]" + this.getLineSeparator() + this.tokenizer.getToken() + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Specified SQL]" + this.getLineSeparator() + this.specifiedSql + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentConditionNotFoundException(msg);
    }

    protected void parseBegin() {
        BeginNode beginNode = new BeginNode();
        this.peek().addChild(beginNode);
        this.push(beginNode);
        this.parseEnd();
    }

    protected void parseEnd() {
        while (99 != this.tokenizer.next()) {
            if (this.tokenizer.getTokenType() == 2 && SqlAnalyzer.isEndComment(this.tokenizer.getToken())) {
                this.pop();
                return;
            }
            this.parseToken();
        }
        this.throwEndCommentNotFoundException();
    }

    protected void throwEndCommentNotFoundException() {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The end comment was Not Found!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the parameter comment logic." + this.getLineSeparator();
        msg = msg + "It may exist the parameter comment that DOESN'T have an end comment." + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    before (x) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3" + this.getLineSeparator();
        msg = msg + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Specified SQL]" + this.getLineSeparator() + this.specifiedSql + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new EndCommentNotFoundException(msg);
    }

    protected void parseElse() {
        Node parent = this.peek();
        if (!(parent instanceof IfNode)) {
            return;
        }
        IfNode ifNode = (IfNode)this.pop();
        ElseNode elseNode = new ElseNode();
        ifNode.setElseNode(elseNode);
        this.push(elseNode);
        this.tokenizer.skipWhitespace();
    }

    protected void parseCommentBindVariable() {
        String expr = this.tokenizer.getToken();
        String s = this.tokenizer.skipToken();
        if (expr.startsWith("$")) {
            this.peek().addChild(this.createEmbeddedValueNode(expr.substring(1), s));
        } else {
            this.peek().addChild(this.createBindVariableNode(expr, s));
        }
    }

    protected void parseBindVariable() {
        String expr = this.tokenizer.getToken();
        this.peek().addChild(this.createBindVariableNode(expr, null));
    }

    protected Node pop() {
        return this.nodeStack.pop();
    }

    protected Node peek() {
        return this.nodeStack.peek();
    }

    protected void push(Node node) {
        this.nodeStack.push(node);
    }

    protected boolean isElseMode() {
        for (int i = 0; i < this.nodeStack.size(); ++i) {
            if (!(this.nodeStack.get(i) instanceof ElseNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTargetComment(String comment) {
        return comment != null && comment.length() > 0 && Character.isJavaIdentifierStart(comment.charAt(0));
    }

    private static boolean isIfComment(String comment) {
        return comment.startsWith("IF");
    }

    private static boolean isBeginComment(String content) {
        return content != null && "BEGIN".equals(content);
    }

    private static boolean isEndComment(String content) {
        return content != null && "END".equals(content);
    }

    protected AbstractNode createBindVariableNode(String expr, String testValue) {
        return new BindVariableNode(expr, testValue, this.specifiedSql, this.blockNullParameter);
    }

    protected AbstractNode createEmbeddedValueNode(String expr, String testValue) {
        return new EmbeddedValueNode(expr, testValue, this.specifiedSql, this.blockNullParameter);
    }

    protected ContainerNode createIfNode(String expr) {
        return new IfNode(expr, this.specifiedSql);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    public static String convertTwoWaySql2DisplaySql(String twoWaySql, Object arg, String logDateFormat, String logTimestampFormat) {
        String[] argNames = new String[]{"dto"};
        Class[] argTypes = new Class[]{arg.getClass()};
        Object[] args = new Object[]{arg};
        return SqlAnalyzer.convertTwoWaySql2DisplaySql(twoWaySql, argNames, argTypes, args, logDateFormat, logTimestampFormat);
    }

    public static String convertTwoWaySql2DisplaySql(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args, String logDateFormat, String logTimestampFormat) {
        SqlAnalyzer parser = new SqlAnalyzer(twoWaySql, false);
        Node node = parser.parse();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        String preparedSql = context.getSql();
        return CompleteSqlBuilder.getCompleteSql(preparedSql, context.getBindVariables(), logDateFormat, logTimestampFormat);
    }

    protected static class MyStringUtil {
        public static final String[] EMPTY_STRINGS = new String[0];

        private MyStringUtil() {
        }

        public static final boolean isEmpty(String text) {
            return text == null || text.length() == 0;
        }

        public static final String replace(String text, String fromText, String toText) {
            return DfStringUtil.replace(text, fromText, toText);
        }

        public static String[] split(String str, String delimiter) {
            return DfStringUtil.split(str, delimiter);
        }
    }
}

