/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.sourceforge.ea2ddl.dao.allcommon.DBMetaInstanceHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.BehaviorSelector;
import org.seasar.dbflute.bhv.BehaviorReadable;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.util.TraceViewUtil;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementedBehaviorSelector
implements BehaviorSelector {
    private static final Log _log = LogFactory.getLog(ImplementedBehaviorSelector.class);
    protected Map<Class<? extends BehaviorReadable>, BehaviorReadable> _behaviorCache = new ConcurrentHashMap<Class<? extends BehaviorReadable>, BehaviorReadable>();
    protected S2Container _container;

    public <COMPONENT> COMPONENT getComponent(Class<COMPONENT> componentType) {
        this.assertObjectNotNull("componentType", componentType);
        this.assertObjectNotNull("_container", this._container);
        try {
            return (COMPONENT)this._container.getComponent(componentType);
        }
        catch (ComponentNotFoundRuntimeException e) {
            Object component;
            try {
                component = this._container.getRoot().getComponent(componentType);
            }
            catch (ComponentNotFoundRuntimeException ignored) {
                throw e;
            }
            this._container = this._container.getRoot();
            return (COMPONENT)component;
        }
    }

    public void initializeConditionBeanMetaData() {
        Map<String, DBMeta> dbmetaMap = DBMetaInstanceHandler.getDBMetaMap();
        Collection<DBMeta> dbmetas = dbmetaMap.values();
        long before = 0L;
        if (_log.isInfoEnabled()) {
            before = System.currentTimeMillis();
            _log.info((Object)"/= = = = = = = = = = = = = = = = = initializeConditionBeanMetaData()");
        }
        for (DBMeta dbmeta : dbmetas) {
            BehaviorReadable bhv = this.byName(dbmeta.getTableDbName());
            bhv.warmUpCommand();
        }
        if (_log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            _log.info((Object)("Initialized Count: " + dbmetas.size()));
            _log.info((Object)("= = = = = = = = = =/ [" + TraceViewUtil.convertToPerformanceView((long)(after - before)) + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <BEHAVIOR extends BehaviorReadable> BEHAVIOR select(Class<BEHAVIOR> behaviorType) {
        if (this._behaviorCache.containsKey(behaviorType)) {
            return (BEHAVIOR)this._behaviorCache.get(behaviorType);
        }
        Map<Class<? extends BehaviorReadable>, BehaviorReadable> map = this._behaviorCache;
        synchronized (map) {
            if (this._behaviorCache.containsKey(behaviorType)) {
                return (BEHAVIOR)this._behaviorCache.get(behaviorType);
            }
            BehaviorReadable bhv = (BehaviorReadable)this.getComponent(behaviorType);
            this._behaviorCache.put(behaviorType, bhv);
            return (BEHAVIOR)bhv;
        }
    }

    public BehaviorReadable byName(String tableFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("tableFlexibleName", tableFlexibleName);
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(tableFlexibleName);
        return this.select(this.getBehaviorType(dbmeta));
    }

    protected Class<BehaviorReadable> getBehaviorType(DBMeta dbmeta) {
        Class<BehaviorReadable> behaviorType;
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        if (behaviorTypeName == null) {
            String msg = "The dbmeta.getBehaviorTypeName() should not return null: dbmeta=" + dbmeta;
            throw new IllegalStateException(msg);
        }
        try {
            behaviorType = Class.forName(behaviorTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The class does not exist: " + behaviorTypeName, e);
        }
        return behaviorType;
    }

    protected String initUncap(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public void setContainer(S2Container container) {
        this._container = container;
    }
}

