/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.ddl.model;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.ea2ddl.common.config.Config;
import jp.sourceforge.ea2ddl.dao.exentity.TAttribute;
import jp.sourceforge.ea2ddl.dao.exentity.TAttributetag;

public class ColumnModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _name;
    private String _alias;
    private String _note;
    private String _type;
    private Integer _precision;
    private Integer _scale;
    private boolean nullable;
    private boolean autoIncrement;
    private String defaultValue;

    public static ColumnModel create(TAttribute columnDef, Config dictionary) {
        ColumnModel column = new ColumnModel();
        column.setName(columnDef.getName());
        column.setAlias(columnDef.getStyle());
        column.setType(columnDef, dictionary);
        column.setNullable(Integer.valueOf(0).equals(columnDef.getAllowduplicates()));
        column.setAutoIncrement(columnDef);
        column.setNote(columnDef.getNotes());
        return column;
    }

    private void setType(TAttribute columnDef, Config dictionary) {
        String domain = dictionary.getProperty(columnDef.getType());
        if (domain != null) {
            Pattern p = Pattern.compile("^(\\w+)\\s*(\\((\\d+)(,\\s*(\\d+))?\\))?.*", 2);
            Matcher m = p.matcher(domain);
            if (m.matches()) {
                this.setType(m.group(1));
                if (m.group(3) != null) {
                    Integer len = Integer.valueOf(m.group(3));
                    this.setPrecision(len);
                }
                if (m.group(5) != null) {
                    this.setScale(Integer.valueOf(m.group(5)));
                }
            }
            return;
        }
        this.setType(columnDef.getType());
        if (columnDef.getLength() != null) {
            this.setPrecision(columnDef.getLength());
        } else if (columnDef.getPrecision() != null) {
            this.setPrecision(columnDef.getPrecision());
            this.setScale(columnDef.getScale());
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setAutoIncrement(TAttribute columnDef) {
        TAttributetag tag = (TAttributetag)columnDef.getTags().get("AutoNum");
        this.autoIncrement = tag != null && "True".equals(tag.getValue());
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getNote() {
        return this._note;
    }

    public void setNote(String note) {
        this._note = note;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public Integer getPrecision() {
        return this._precision;
    }

    public void setPrecision(Integer precision) {
        this._precision = precision;
    }

    public Integer getScale() {
        return this._scale;
    }

    public void setScale(Integer scale) {
        this._scale = scale;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefinition() {
        StringBuilder b = new StringBuilder();
        b.append(this._type);
        if (this._precision != null) {
            b.append("(").append(this._precision);
            if (this._scale != null) {
                b.append(",").append(this._scale);
            }
            b.append(")");
        }
        if (!this.isNullable()) {
            b.append(" NOT NULL");
        }
        if (this.isAutoIncrement()) {
            b.append(" AUTO_INCREMENT");
        }
        return b.toString();
    }
}

