#include "stdafx.h"

#include "Digest.h"

////

DigestContext::DigestContext() throw()
	: hProv_(NULL)
{
}

DigestContext::~DigestContext() throw()
{
	if (hProv_)
		::CryptReleaseContext(hProv_, 0);
}

BOOL DigestContext::Create() throw()
{
	ATLASSERT(!hProv_);
	return ::CryptAcquireContext(
		&hProv_,
		NULL,
		NULL,
		PROV_RSA_FULL,
		CRYPT_VERIFYCONTEXT
		);
}

////

Digest::Digest(DigestContext& ctx) throw ()
	: ctx_(ctx)
	, hHash_(NULL)
{
	ATLASSERT(ctx.hProv_);
}

Digest::~Digest() throw()
{
	if (hHash_)
		::CryptDestroyHash(hHash_);
}

BOOL Digest::Create(const ALG_ID algo_id) throw()
{
	ATLASSERT(!hHash_);
	return ::CryptCreateHash(ctx_.hProv_, algo_id, 0, 0, &hHash_);
}

BOOL Digest::Update(LPBYTE data, DWORD len) throw()
{
	ATLASSERT(hHash_);
	return ::CryptHashData(hHash_, data, len, 0);
}

size_t Digest::GetHashSize() throw()
{
	ATLASSERT(hHash_);

	DWORD len;
	DWORD sz = sizeof(DWORD);
	if (!::CryptGetHashParam(hHash_, HP_HASHSIZE, (BYTE*)&len, &sz, 0))
		return 0;
	return len;
}

BOOL Digest::GetHashValue(LPBYTE data, DWORD len) throw()
{
	ATLASSERT(hHash_);
	return ::CryptGetHashParam(hHash_, HP_HASHVAL, data, &len, 0);
}

///

BOOL CalcFileDigest(const LPCWSTR fileName, Digest& digest) throw()
{
	const size_t buffer_size = 4096;
	BYTE buf[buffer_size];

	HANDLE fh = ::CreateFile(
		fileName,
		GENERIC_READ,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		FILE_FLAG_SEQUENTIAL_SCAN,
		NULL
		);
	if (fh == INVALID_HANDLE_VALUE)
		return FALSE;

	CHandle hFileAutoCloser(fh);

	DWORD rd;
	BOOL ret;
	while (ret = ::ReadFile(fh, buf, buffer_size, &rd, NULL))
	{
		if (rd == 0)
			break;
		if (!digest.Update(reinterpret_cast<LPBYTE>(buf), rd))
			return FALSE;
	}
	return ret;
}
