#pragma once

#include <Wincrypt.h>
#include <atlbase.h>

class DigestContext
{
	friend class Digest;

	DigestContext(const DigestContext& other) throw(); //<! Ȃ
	DigestContext& operator=(const DigestContext& other) throw(); //<! Ȃ

public:
	DigestContext() throw();
	~DigestContext() throw();

	BOOL Create() throw();

protected:
	HCRYPTPROV hProv_;
};

class Digest
{
	Digest(const Digest&); //<! Ȃ
	Digest& operator=(const Digest&); //<! Ȃ

public:
	Digest(DigestContext& ctx) throw ();
	~Digest() throw();

	BOOL Create(const ALG_ID algo_id) throw();

	BOOL Update(LPBYTE data, DWORD len) throw();

	size_t GetHashSize() throw();

	BOOL GetHashValue(LPBYTE data, DWORD len) throw();

private:
	DigestContext& ctx_;

	HCRYPTHASH hHash_;
};

BOOL CalcFileDigest(const LPCWSTR fileName, Digest& digest) throw();
