#include "stdafx.h"

#include "DigestFormatParser.h"

namespace
{
	inline BOOL IsCRLF(const CHAR c) throw()
	{
		return (c == '\r') || (c == '\n');
	}

	inline BOOL IsWhiteSpace(const CHAR c) throw()
	{
		return (c == ' ') || (c == '\t') || IsCRLF(c);
	}
}

DigestFormatParser::DigestFormatParser(DigestItemPtrList& list)
	: list_(list)
{
}

DigestFormatParser::~DigestFormatParser()
{
}

BOOL DigestFormatParser::ParseDigest(const LPCSTR text, const ALG_ID algoId) throw()
{
	LPCSTR p = text;
	while (*p)
	{
		while (IsWhiteSpace(*p))
			p++;
		if (!*p)
			break;

		LPCSTR hash_st = p;
		while (*p && !IsWhiteSpace(*p))
			p++;
		if (!*p)
			return FALSE; // sȃtH[}bg
		LPCSTR hash_end = p;
		const size_t hash_len = hash_end - hash_st;
		if (hash_len == 0 || (hash_len % 2))
			return FALSE; // sȃtH[}bg

		while (IsWhiteSpace(*p))
			p++;
		if (!*p)
			return FALSE; // sȃtH[}bg

		bool binary = false;
		if (*p == '*')
		{
			binary = true;
			p++;
		}

		LPCSTR filename_st = p;
		while (*p && !IsCRLF(*p))
			p++;
		LPCSTR filename_en = p;
		const size_t filename_len = filename_en - filename_st;

		DigestItem* item = new DigestItem();
		if (!item)
			return FALSE; // s
		
		DigestItemPtr itemPtr(item);

		item->SetHash(hash_st, hash_len);
		item->SetName(filename_st, filename_len);
		item->SetBinary(binary);
		item->SetAlgoID(algoId);

		list_.AddTail(itemPtr);
	}

	return TRUE;
}
