#include "stdafx.h"

#include "DigestItem.h"

DigestItem::DigestItem() throw()
	: hash_(NULL)
	, name_(NULL)
	, binary_(false)
	, algoId_(CALG_MD5)
{
}

DigestItem::~DigestItem() throw()
{
}

void DigestItem::SetHash(const LPCSTR src, const size_t len) throw()
{
	if (hash_)
		hash_.Empty();
	hash_ = CComBSTR(static_cast<UINT>(len), src);
}

void DigestItem::SetName(const LPCSTR src, const size_t len) throw()
{
	if (name_)
		name_.Empty();
	name_ = CComBSTR(static_cast<UINT>(len), src);
}

void DigestItem::SetBinary(const bool binary) throw()
{
	binary_ = binary;
}

void DigestItem::SetAlgoID(const ALG_ID algoId) throw()
{
	algoId_ = algoId;
}

LPCWSTR DigestItem::GetHash() const throw()
{
	return hash_;
}

LPCWSTR DigestItem::GetName() const throw()
{
	return name_;
}

bool DigestItem::IsBinary() const throw()
{
	return binary_;
}

ALG_ID DigestItem::getAlgoId() const throw()
{
	return algoId_;
}
