#pragma once

#include <atlbase.h>

class DigestItem
{
private:
	DigestItem(const DigestItem&); //<! Ȃ
	DigestItem& operator=(const DigestItem&); //<! Ȃ

public:
	DigestItem() throw();
	~DigestItem() throw();

	void SetHash(const LPCSTR src, const size_t len) throw();
	void SetName(const LPCSTR src, const size_t len) throw();
	void SetBinary(const bool binary) throw();
	void SetAlgoID(const ALG_ID algoId) throw();

	LPCWSTR GetHash() const throw();
	LPCWSTR GetName() const throw();
	bool IsBinary() const throw();
	ALG_ID getAlgoId() const throw();

private:
	CComBSTR hash_;
	CComBSTR name_;
	bool binary_;
	ALG_ID algoId_;
};

typedef CAutoPtr<DigestItem> DigestItemPtr;
typedef CAutoPtrList<DigestItem> DigestItemPtrList;
