#pragma once

#include <wincrypt.h>
#include <atlbase.h>

#include "Utility.h"

int MakeOperation(DigestContext& ctx, const ALG_ID algId, const LPCWSTR ext) throw()
{
	WIN32_FIND_DATA findData;
	HANDLE hFind = ::FindFirstFile(L"*.*", &findData);
	if (hFind == INVALID_HANDLE_VALUE)
		return 0;

	bool err = false;
	while(1)
	{
		if (!(findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
		{
			CComBSTR fileName(findData.cFileName);
			
			Digest digest(ctx);
			if (!digest.Create(algId))
			{
				ShowError(::GetLastError());
				err = true;
				break;
			}

			if (!CalcFileDigest(fileName, digest))
			{
				ShowError(::GetLastError());
				err = true;
				break;
			}

			const size_t siz = digest.GetHashSize();
			const size_t max_siz = 64;
			ATLASSERT(siz < max_siz);
			BYTE hashBuf[max_siz];
			if (!digest.GetHashValue(hashBuf, static_cast<DWORD>(siz)))
			{
				ShowError(::GetLastError());
				err = true;
				break;
			}

			CComBSTR digestFileName(fileName);
			digestFileName.Append(L".");
			digestFileName.Append(ext);

			HANDLE fh = ::CreateFile(
				digestFileName,
				GENERIC_WRITE,
				0,
				NULL,
				CREATE_ALWAYS,
				FILE_FLAG_SEQUENTIAL_SCAN,
				NULL
				);
			if (fh == INVALID_HANDLE_VALUE)
			{
				ShowError(::GetLastError());
				err = true;
				break;
			}
			CHandle fhAutoCloser(fh);

			DWORD wd;
			unsigned char buf[3] = {0};
			for (size_t idx = 0; !err && idx < siz; idx++)
			{
				const static LPCSTR hexmap = "0123456789abcdef";
				const BYTE x = hashBuf[idx];
				buf[0] = hexmap[((x >> 4) & 0x0f)];
				buf[1] = hexmap[x & 0x0f];
				if (!::WriteFile(fh, buf, 2, &wd, NULL) || wd != 2)
					err = true;
			}

			if (!err)
			{
				if (!::WriteFile(fh, " *", 2, &wd, NULL) || wd != 2)
					err = true;
			}
			if (!err)
			{
				CHAR mbcsFileName[MAX_PATH];
				if (!::WideCharToMultiByte(
					::GetACP(),
					0,
					findData.cFileName,
					-1,
					mbcsFileName,
					MAX_PATH,
					NULL,
					NULL
					))
				{
					err = true;
					break;
				}

				const DWORD len = lstrlenA(mbcsFileName);
				if (!::WriteFile(fh, mbcsFileName, len, &wd, NULL) || wd != len)
					err = true;
			}
			if (!err)
			{
				if (!::WriteFile(fh, "\n", 1, &wd, NULL) || wd != 1)
					err = true;
			}

			if (err)
			{
				ShowError(::GetLastError());
				break;
			}
		}

		if (!::FindNextFile(hFind, &findData))
		{
			const DWORD err = ::GetLastError();
			if (err == ERROR_NO_MORE_FILES)
				break;
			else
				ShowError(err);
		}
	}
	::FindClose(hFind);

	if (!err)
		::MessageBox(
			NULL,
			L"쐬I܂B",
			L"nbV̍쐬",
			MB_ICONINFORMATION | MB_OK);

	return 0;
}
