#include "stdafx.h"

#include "Utility.h"

void ShowError(const DWORD errcode) throw()
{
	LPVOID lpMsgBuf;
	if (FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM |
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		errcode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ̌
		(LPTSTR) &lpMsgBuf,
		0,
		NULL
		))
	{
		MessageBox(NULL, (LPCTSTR)lpMsgBuf, NULL, MB_OK | MB_ICONERROR);
		LocalFree(lpMsgBuf);
	}
}

BSTR ReadFile(const LPCWSTR fileName) throw()
{
	HANDLE hFile = ::CreateFile(
		(LPCWSTR)fileName,
		GENERIC_READ,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		FILE_FLAG_SEQUENTIAL_SCAN,
		NULL
		);
	if (hFile == INVALID_HANDLE_VALUE)
		return NULL;
	CHandle hFileAutoCloser(hFile);

	const DWORD siz = ::GetFileSize(hFile, NULL);
	if (siz == INVALID_FILE_SIZE)
		return NULL;

	BSTR buf = ::SysAllocStringByteLen(NULL, siz + 1);
	if (!buf)
		return NULL;

	DWORD rd = 0;
	if (!::ReadFile(hFile, reinterpret_cast<LPSTR>(buf), siz, &rd, NULL ))
	{
		::SysFreeString(buf);
		return NULL;
	}

	reinterpret_cast<LPSTR>(buf)[siz] = 0;
	return buf;
}

size_t HexToBin(const LPCWSTR text, LPBYTE buf, const size_t buf_siz) throw()
{
	size_t idx = 0;
	LPCWSTR p = text;
	bool alt = false;
	unsigned char d = 0;
	while (*p && idx < buf_siz)
	{
		unsigned char x = 0;
		const WCHAR c = *p;
		p++;
		if (c >= '0' && c <= '9')
			x = c - '0';
		else if (c >= 'a' && c <= 'f')
			x = c - 'a' + 10;
		else if (c >= 'A' && c <= 'F')
			x = c - 'A' + 10;
		if (alt)
		{
			alt = false;
			d <<= 4;
			d |= x;
			*(buf + idx) = d;
			idx++;
		}
		else
		{
			alt = true;
			d = x;
		}
	}
	return idx;
}
