#include "stdafx.h"

#include "VerifyOperation.h"
#include "Utility.h"

void ReadCurrentDirectory(const LPCWSTR fname, const ALG_ID algId, DigestFormatParser& parser) throw()
{
	WIN32_FIND_DATA findData;
	HANDLE hFind = ::FindFirstFile(fname, &findData);
	if (hFind == INVALID_HANDLE_VALUE)
		return;

	while(1)
	{
		if (!(findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
		{
			CComBSTR fileName(findData.cFileName);

			BSTR buf = ReadFile(fileName);
			if (!buf)
			{
				ShowError(::GetLastError());
				break;
			}
			CComBSTR bufAutoDeleter;
			bufAutoDeleter.Attach(buf);

			if (!parser.ParseDigest(reinterpret_cast<LPCSTR>(buf), algId))
			{
				::MessageBox(
					NULL,
					L"t@C̃tH[}bgsł邩͂Ɏs܂B",
					fileName,
					MB_ICONERROR | MB_OK
					);
			}
		}

		if (!::FindNextFile(hFind, &findData))
		{
			const DWORD err = ::GetLastError();
			if (err == ERROR_NO_MORE_FILES)
				break;
			else
				ShowError(err);
		}
	}
	::FindClose(hFind);
}

int VerifyOperation(DigestContext& ctx) throw()
{
	DigestItemPtrList list;
	DigestFormatParser parser(list);

	ReadCurrentDirectory(L"*.md5", CALG_MD5, parser);
	ReadCurrentDirectory(L"*.sha1", CALG_SHA1, parser);

	if (list.GetCount() == 0)
	{
		::MessageBox(
			NULL,
			L"_CWFXgt@C(*.md5/*.sha1)JgfBNg1݂Ȃߌ؂ł܂B\r\n\r\n"
			L"(؂̂ł͂ȂA_CWFXgt@CVKɍ쐬ꍇ\r\nSHIFTL[ASHIFT+CTRLL[ȂN܂B)",
			NULL,
			MB_ICONERROR | MB_OK
			);
		return 0;
	}

	bool occureError = false;
	CComBSTR mes;

	POSITION pos = list.GetHeadPosition();
	while (pos)
	{
		DigestItemPtr itemPtr = list.GetNext(pos);

		Digest digest(ctx);
		if (!digest.Create(itemPtr->getAlgoId()))
		{
			ShowError(::GetLastError());
			mes.Empty();
			break;
		}

		mes.Append(itemPtr->GetName());
		mes.Append(L" - ");

		if (!CalcFileDigest(itemPtr->GetName(), digest))
		{
			mes.Append(L"t@CȂAǂݍ݂Ɏs܂B");
			occureError = true;
		}
		else
		{
			const size_t siz = digest.GetHashSize();
			const size_t max_siz = 64;
			ATLASSERT(siz < max_siz);

			BYTE verifyHash[max_siz];
			BYTE fileHash[max_siz];

			if (!digest.GetHashValue(verifyHash, static_cast<DWORD>(siz)))
			{
				ShowError(::GetLastError());
				mes.Empty();
				break;
			}

			const size_t cnv_siz = HexToBin(
				itemPtr->GetHash(),
				reinterpret_cast<LPBYTE>(fileHash),
				siz
				);

			if (cnv_siz == siz && memcmp(fileHash, verifyHash, siz) == 0)
				mes.Append(L"OK");
			else
			{
				mes.Append(L"nbVlv܂B");
				occureError = true;
			}
		}

		mes.Append(L"\r\n");
	}

	if (mes.Length())
	{
		const LPCWSTR messageTitle =
			occureError ? L"؂Ɏs܂B": L"؂ɐ܂B";
		mes.Append(L"\r\n");
		mes.Append(messageTitle);
		::MessageBox(
			NULL,
			mes,
			messageTitle,
			occureError ? ( MB_ICONERROR | MB_OK ) : ( MB_ICONINFORMATION | MB_OK )
			);
	}

	return 0;
}
