// StaticPolymorphism.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include "Utility.h"
#include "Digest.h"
#include "VerifyOperation.h"

#if !VERIFY_ONLY
#include "MakeOperation.h"
#endif // !VERIFY_ONLY

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	DigestContext ctx;
	if (!ctx.Create())
	{
		ShowError(::GetLastError());
		return 1;
	}

#if !VERIFY_ONLY

	const bool makeMode = ((::GetAsyncKeyState(VK_SHIFT) & 0x8000) != 0);
	const bool makeType = ((::GetAsyncKeyState(VK_CONTROL) & 0x8000) != 0);

	if (makeMode)
	{
		int confirm;

		if (makeType)
			confirm = ::MessageBox(
				NULL,
				L"JgfBNg̃t@CSHA1nbV쐬܂H\r\n"
				L"(MD5nbV쐬ꍇSHIFTL[̂݉ȂN܂B)",
				L"nbV쐬̊mF",
				MB_ICONQUESTION | MB_YESNO
				);
		else
			confirm = ::MessageBox(
				NULL,
				L"JgfBNg̃t@CMD5nbV쐬܂H\r\n"
				L"(SHA1nbV쐬ꍇSHIFT+CTRLL[ȂN܂B)",
				L"nbV쐬̊mF",
				MB_ICONQUESTION | MB_YESNO
				);

		if (confirm == IDYES)
			return MakeOperation(
				ctx,
				makeType ? CALG_SHA1 : CALG_MD5,
				makeType ? L"sha1" : L"md5"
				);
	
		return 0;
	}

#endif // !VERIFY_ONLY

	return VerifyOperation(ctx);
}

