/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.IndexStyle;
import fuku.eb4j.Result;
import fuku.eb4j.SearchMethod;
import fuku.eb4j.SearchSingle;
import fuku.eb4j.SubBook;
import java.util.ArrayList;

final class SearchMultiple
extends SearchMethod {
    private SubBook _sub = null;
    private IndexStyle _style = null;
    private IndexStyle[] _entry = null;
    private SearchSingle[] _searcher = null;

    SearchMultiple(SubBook sub, IndexStyle style) {
        this._sub = sub;
        this._style = style;
    }

    SearchMultiple(SubBook sub, IndexStyle multi, IndexStyle[] entry) {
        this._sub = sub;
        this._style = multi;
        this._entry = entry;
    }

    void search(byte[][] word) throws EBException {
        int len = word.length;
        ArrayList<SearchSingle> list = new ArrayList<SearchSingle>(len);
        if (this._entry == null) {
            for (int i = 0; i < len; ++i) {
                if (word[i] == null || word[i].length <= 0) continue;
                SearchSingle search = new SearchSingle(this._sub, this._style, 3);
                search.search(word[i]);
                list.add(search);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (word[i] == null || word[i].length <= 0) continue;
                SearchSingle search = new SearchSingle(this._sub, this._entry[i], 4);
                search.search(word[i]);
                list.add(search);
            }
        }
        this._searcher = list.toArray(new SearchSingle[0]);
    }

    Result getNextResult() throws EBException {
        int i;
        if (this._searcher == null || this._searcher.length <= 0) {
            return null;
        }
        int len = this._searcher.length;
        Result[] result = new Result[len];
        long pos1 = -1L;
        long pos2 = -1L;
        int count = 0;
        for (i = 0; i < len; ++i) {
            result[i] = this._searcher[i].getNextResult();
            if (result[i] == null) {
                return null;
            }
            pos2 = result[i].getTextPosition();
            if (pos1 < 0L) {
                pos1 = pos2;
                ++count;
                continue;
            }
            if (pos1 < pos2) {
                pos1 = pos2;
                count = 0;
                continue;
            }
            if (pos1 != pos2) continue;
            ++count;
        }
        while (count != len) {
            count = 0;
            for (i = 0; i < len; ++i) {
                if (pos1 != result[i].getTextPosition()) {
                    result[i] = this._searcher[i].getNextResult();
                    if (result[i] == null) {
                        return null;
                    }
                    pos2 = result[i].getTextPosition();
                    if (pos1 < pos2) {
                        pos1 = pos2;
                        count = 0;
                        continue;
                    }
                    if (pos1 != pos2) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        return result[0];
    }
}

