/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.IndexStyle;
import fuku.eb4j.Result;
import fuku.eb4j.SearchMethod;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;
import fuku.eb4j.util.CompareUtil;

final class SearchSingle
extends SearchMethod {
    static final int WORD = 0;
    static final int ENDWORD = 1;
    static final int EXACTWORD = 2;
    static final int KEYWORD = 3;
    static final int MULTI = 4;
    private static final int MAX_INDEX_DEPTH = 6;
    private static final int VARIABLE = 0;
    private static final int FIXED = 1;
    private SubBook _sub = null;
    private IndexStyle _style = null;
    private int _type = 0;
    private byte[] _word = null;
    private byte[] _canonical = null;
    private EBFile _file = null;
    private byte[] _cache = new byte[2048];
    private long _cachePage = 0L;
    private int _off = 0;
    private long _page = 0L;
    private int _pageID = 0;
    private int _entryLength = 0;
    private int _entryArrangement = 0;
    private int _entryCount = 0;
    private int _entryIndex = 0;
    private boolean _inGroupEntry = false;
    private int _comparison = -1;
    private long _keywordHeading = 0L;

    SearchSingle(SubBook sub, IndexStyle style, int type) {
        this._sub = sub;
        this._file = sub.getTextFile();
        this._style = style;
        this._type = type;
    }

    private void _setWord(byte[] word) {
        this._word = word;
        this._canonical = new byte[this._word.length];
        System.arraycopy(this._word, 0, this._canonical, 0, this._word.length);
        if (this._sub.getBook().getCharCode() == 1) {
            this._style.fixWordLatin(this._canonical);
        } else {
            this._style.fixWord(this._canonical);
        }
        if (this._style.getIndexID() != 112 && this._style.getIndexID() != 144) {
            System.arraycopy(this._canonical, 0, this._word, 0, this._word.length);
        }
        if (this._type == 1) {
            if (this._sub.getBook().getCharCode() == 1) {
                ByteUtil.reverseWordLatin(this._word);
                ByteUtil.reverseWordLatin(this._canonical);
            } else {
                ByteUtil.reverseWord(this._word);
                ByteUtil.reverseWord(this._canonical);
            }
        }
    }

    private int _compareToCanonical(byte[] canonical, byte[] pattern) {
        boolean exact = false;
        if (this._type == 2 || this._type == 3 || this._type == 4) {
            exact = true;
        }
        return CompareUtil.compareToCanonical(canonical, pattern, exact);
    }

    private int _compareToWord(byte[] word, byte[] pattern) {
        boolean exact = false;
        if (this._type == 2 || this._type == 3 || this._type == 4) {
            exact = true;
        }
        int ret = 0;
        ret = this._sub.getBook().getCharCode() == 1 ? CompareUtil.compareToLatin(word, pattern, exact) : CompareUtil.compareTo(word, pattern, exact);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void search(byte[] word) throws EBException {
        this._setWord(word);
        this._page = this._style.getStartPage();
        BookInputStream bis = this._file.getInputStream();
        try {
            int depth;
            long nextPage = this._page;
            for (depth = 0; depth < 6; ++depth) {
                bis.seek(this._page, 0);
                bis.readFully(this._cache, 0, this._cache.length);
                this._cachePage = this._page;
                this._pageID = this._cache[0] & 0xFF;
                this._entryLength = this._cache[1] & 0xFF;
                this._entryArrangement = this._entryLength == 0 ? 0 : 1;
                this._entryCount = ByteUtil.getInt2(this._cache, 2);
                this._off = 4;
                if (this._isLeafLayer(this._pageID)) break;
                byte[] b = new byte[this._entryLength];
                this._entryIndex = 0;
                while (this._entryIndex < this._entryCount) {
                    if (this._off + this._entryLength + 4 > 2048) {
                        throw new EBException(5, this._file.getPath());
                    }
                    System.arraycopy(this._cache, this._off, b, 0, b.length);
                    this._off += this._entryLength;
                    if (this._compareToCanonical(this._canonical, b) <= 0) {
                        nextPage = ByteUtil.getLong4(this._cache, this._off);
                        break;
                    }
                    this._off += 4;
                    ++this._entryIndex;
                }
                if (this._entryIndex >= this._entryCount || nextPage == this._page) {
                    this._comparison = -1;
                    return;
                }
                this._page = nextPage;
            }
            if (depth == 6) {
                throw new EBException(5, this._file.getPath());
            }
        }
        finally {
            bis.close();
        }
        this._entryIndex = 0;
        this._comparison = 1;
        this._inGroupEntry = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getNextResult() throws EBException {
        if (this._comparison < 0) {
            return null;
        }
        while (true) {
            int hOff;
            int tOff;
            Result result;
            if (this._cachePage != this._page) {
                BookInputStream bis = this._file.getInputStream();
                try {
                    bis.seek(this._page, 0);
                    bis.readFully(this._cache, 0, this._cache.length);
                }
                finally {
                    bis.close();
                }
                this._cachePage = this._page;
                if (this._entryIndex == 0) {
                    this._pageID = this._cache[0] & 0xFF;
                    this._entryLength = this._cache[1] & 0xFF;
                    this._entryArrangement = this._entryLength == 0 ? 0 : 1;
                    this._entryCount = ByteUtil.getInt2(this._cache, 2);
                    this._entryIndex = 0;
                    this._off = 4;
                }
            }
            if (!this._isLeafLayer(this._pageID)) {
                throw new EBException(5, this._file.getPath());
            }
            if (!this._hasGroupEntry(this._pageID)) {
                while (this._entryIndex < this._entryCount) {
                    if (this._entryArrangement == 0) {
                        if (this._off + 1 > 2048) {
                            throw new EBException(5, this._file.getPath());
                        }
                        this._entryLength = this._cache[this._off] & 0xFF;
                        ++this._off;
                    }
                    if (this._off + this._entryLength + 12 > 2048) {
                        throw new EBException(5, this._file.getPath());
                    }
                    byte[] b = new byte[this._entryLength];
                    System.arraycopy(this._cache, this._off, b, 0, b.length);
                    this._off += this._entryLength;
                    this._comparison = this._compareToWord(this._word, b);
                    result = null;
                    if (this._comparison == 0) {
                        long tPage = ByteUtil.getLong4(this._cache, this._off);
                        tOff = ByteUtil.getInt2(this._cache, this._off + 4);
                        long hPage = ByteUtil.getLong4(this._cache, this._off + 6);
                        hOff = ByteUtil.getInt2(this._cache, this._off + 10);
                        result = new Result(hPage, hOff, tPage, tOff);
                    }
                    ++this._entryIndex;
                    this._off += 12;
                    if (result != null) {
                        return result;
                    }
                    if (this._comparison >= 0) continue;
                    return null;
                }
            } else {
                while (this._entryIndex < this._entryCount) {
                    int hOff2;
                    long hPage;
                    long tPage;
                    if (this._off + 2 > 2048) {
                        throw new EBException(5, this._file.getPath());
                    }
                    int groupID = this._cache[this._off] & 0xFF;
                    result = null;
                    if (groupID == 0) {
                        this._entryLength = this._cache[this._off + 1] & 0xFF;
                        if (this._off + this._entryLength + 14 > 2048) {
                            throw new EBException(5, this._file.getPath());
                        }
                        byte[] b = new byte[this._entryLength];
                        System.arraycopy(this._cache, this._off + 2, b, 0, b.length);
                        this._off += this._entryLength + 2;
                        this._comparison = this._compareToWord(this._canonical, b);
                        if (this._comparison == 0 && this._compareToWord(this._word, b) == 0) {
                            tPage = ByteUtil.getLong4(this._cache, this._off);
                            int tOff2 = ByteUtil.getInt2(this._cache, this._off + 4);
                            hPage = ByteUtil.getLong4(this._cache, this._off + 6);
                            hOff2 = ByteUtil.getInt2(this._cache, this._off + 10);
                            result = new Result(hPage, hOff2, tPage, tOff2);
                        }
                        this._off += 12;
                        this._inGroupEntry = false;
                    } else if (groupID == 128) {
                        this._entryLength = this._cache[this._off + 1] & 0xFF;
                        byte[] b = new byte[this._entryLength];
                        if (this._type == 3) {
                            if (this._off + this._entryLength + 12 > 2048) {
                                throw new EBException(5, this._file.getPath());
                            }
                            System.arraycopy(this._cache, this._off + 6, b, 0, b.length);
                            this._off += this._entryLength + 6;
                            this._comparison = this._compareToWord(this._word, b);
                            long hPage2 = ByteUtil.getLong4(this._cache, this._off);
                            int hOff3 = ByteUtil.getInt2(this._cache, this._off + 4);
                            this._keywordHeading = BookInputStream.getPosition(hPage2, hOff3);
                            this._off += 6;
                        } else if (this._type == 4) {
                            if (this._off + this._entryLength + 6 > 2048) {
                                throw new EBException(5, this._file.getPath());
                            }
                            System.arraycopy(this._cache, this._off + 6, b, 0, b.length);
                            this._comparison = this._compareToWord(this._word, b);
                            this._off += this._entryLength + 6;
                        } else {
                            if (this._off + this._entryLength + 4 > 2048) {
                                throw new EBException(5, this._file.getPath());
                            }
                            System.arraycopy(this._cache, this._off + 4, b, 0, b.length);
                            this._comparison = this._compareToWord(this._canonical, b);
                            this._off += this._entryLength + 4;
                        }
                        this._inGroupEntry = true;
                    } else if (groupID == 192) {
                        if (this._type == 3) {
                            if (this._off + 7 > 2048) {
                                throw new EBException(5, this._file.getPath());
                            }
                            if (this._comparison == 0 && this._inGroupEntry) {
                                long tPage2 = ByteUtil.getLong4(this._cache, this._off + 1);
                                tOff = ByteUtil.getInt2(this._cache, this._off + 5);
                                result = new Result(this._keywordHeading, tPage2, tOff);
                                this._keywordHeading = this._sub.getNextHeadingPosition(this._keywordHeading);
                            }
                            this._off += 7;
                        } else if (this._type == 4) {
                            if (this._off + 13 > 2048) {
                                throw new EBException(5, this._file.getPath());
                            }
                            if (this._comparison == 0 && this._inGroupEntry) {
                                long tPage3 = ByteUtil.getLong4(this._cache, this._off + 1);
                                tOff = ByteUtil.getInt2(this._cache, this._off + 5);
                                long hPage3 = ByteUtil.getLong4(this._cache, this._off + 7);
                                hOff = ByteUtil.getInt2(this._cache, this._off + 11);
                                result = new Result(hPage3, hOff, tPage3, tOff);
                            }
                            this._off += 13;
                        } else {
                            this._entryLength = this._cache[this._off + 1] & 0xFF;
                            if (this._off + this._entryLength + 14 > 2048) {
                                throw new EBException(5, this._file.getPath());
                            }
                            byte[] b = new byte[this._entryLength];
                            System.arraycopy(this._cache, this._off + 2, b, 0, b.length);
                            this._off += this._entryLength + 2;
                            if (this._comparison == 0 && this._inGroupEntry && this._compareToWord(this._word, b) == 0) {
                                tPage = ByteUtil.getLong4(this._cache, this._off);
                                int tOff3 = ByteUtil.getInt2(this._cache, this._off + 4);
                                hPage = ByteUtil.getLong4(this._cache, this._off + 6);
                                hOff2 = ByteUtil.getInt2(this._cache, this._off + 10);
                                result = new Result(hPage, hOff2, tPage, tOff3);
                            }
                            this._off += 12;
                        }
                    } else {
                        throw new EBException(5, this._file.getPath());
                    }
                    ++this._entryIndex;
                    if (result != null) {
                        return result;
                    }
                    if (this._comparison >= 0) continue;
                    return null;
                }
            }
            if (this._isLayerEnd(this._pageID)) break;
            ++this._page;
            this._entryIndex = 0;
        }
        this._comparison = -1;
        return null;
    }

    private boolean _isLeafLayer(int id) {
        return (id & 0x80) == 128;
    }

    private boolean _isLayerStart(int id) {
        return (id & 0x40) == 64;
    }

    private boolean _isLayerEnd(int id) {
        return (id & 0x20) == 32;
    }

    private boolean _hasGroupEntry(int id) {
        return (id & 0x10) == 16;
    }
}

