/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.Appendix;
import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class SubAppendix {
    private static final int ALTERNATION_TEXT_LENGTH = 31;
    private Appendix _appendix = null;
    private EBFile _file = null;
    private long[] _page = new long[2];
    private int[] _start = new int[2];
    private int[] _end = new int[2];
    private int _charCode = -1;
    private int[] _stopCode = new int[2];
    private Map[] _cache = new Map[2];

    SubAppendix(Appendix appendix, String path) throws EBException {
        this._appendix = appendix;
        if (this._appendix.getAppendixType() == 0) {
            this._setupEB(path);
        } else {
            this._setupEPWING(path);
        }
        this._load();
    }

    private void _setupEB(String path) throws EBException {
        File dir = EBFile.searchDirectory(this._appendix.getPath(), path);
        this._file = new EBFile(dir, "appendix", 0);
    }

    private void _setupEPWING(String path) throws EBException {
        File dir = EBFile.searchDirectory(this._appendix.getPath(), path);
        File dataDir = EBFile.searchDirectory(dir, "data");
        this._file = new EBFile(dataDir, "furoku", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() throws EBException {
        byte[] b = new byte[16];
        BookInputStream bis = this._file.getInputStream();
        try {
            bis.seek(0L);
            bis.readFully(b, 0, b.length);
            this._charCode = ByteUtil.getInt2(b, 2);
            for (int i = 0; i < 2; ++i) {
                bis.readFully(b, 0, b.length);
                int charCount = ByteUtil.getInt2(b, 12);
                if (charCount <= 0) {
                    this._page[i] = -1L;
                    this._start[i] = -1;
                    this._end[i] = -1;
                    this._cache[i] = null;
                    continue;
                }
                this._page[i] = ByteUtil.getLong4(b, 0);
                this._start[i] = ByteUtil.getInt2(b, 10);
                if (this._charCode == 1) {
                    this._end[i] = this._start[i] + (charCount / 254 << 8) + charCount % 254 - 1;
                    if ((this._end[i] & 0xFF) > 254) {
                        int n = i;
                        this._end[n] = this._end[n] + 3;
                    }
                    if ((this._start[i] & 0xFF) < 1 || (this._start[i] & 0xFF) > 254 || this._start[i] < 1 || this._start[i] > 7934) {
                        throw new EBException(5, this._file.getPath());
                    }
                } else {
                    this._end[i] = this._start[i] + (charCount / 94 << 8) + charCount % 94 - 1;
                    if ((this._end[i] & 0xFF) > 126) {
                        int n = i;
                        this._end[n] = this._end[n] + 163;
                    }
                    if ((this._start[i] & 0xFF) < 33 || (this._start[i] & 0xFF) > 126 || this._start[i] < 41249 || this._end[i] > 65150) {
                        throw new EBException(5, this._file.getPath());
                    }
                }
                this._cache[i] = new HashMap(charCount + 1, 1.0f);
            }
            bis.readFully(b, 0, b.length);
            long stopCodePage = ByteUtil.getLong4(b, 0);
            if (stopCodePage > 0L) {
                bis.seek(stopCodePage, 0);
                bis.readFully(b, 0, b.length);
                if (ByteUtil.getInt2(b, 0) != 0) {
                    this._stopCode[0] = ByteUtil.getInt2(b, 2);
                    this._stopCode[1] = ByteUtil.getInt2(b, 4);
                } else {
                    this._stopCode[0] = 0;
                    this._stopCode[1] = 0;
                }
            }
        }
        finally {
            bis.close();
        }
    }

    public boolean hasNarrowFontAlt() {
        return this._page[1] > 0L;
    }

    public boolean hasWideFontAlt() {
        return this._page[1] > 0L;
    }

    public String getNarrowFontAlt(int code) throws EBException {
        return this._getFontAlt(1, code);
    }

    public String getWideFontAlt(int code) throws EBException {
        return this._getFontAlt(0, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getFontAlt(int kind, int code) throws EBException {
        if (this._page[kind] <= 0L) {
            return null;
        }
        if (code < this._start[kind] || code > this._end[kind]) {
            return null;
        }
        String ret = (String)this._cache[kind].get(new Integer(code));
        if (ret != null) {
            return ret;
        }
        int index = 0;
        if (this._charCode == 1) {
            if ((code & 0xFF) < 1 || (code & 0xFF) > 254) {
                return null;
            }
            index = ((code >>> 8) - (this._start[kind] >>> 8)) * 254 + ((code & 0xFF) - (this._start[kind] & 0xFF));
        } else {
            if ((code & 0xFF) < 33 || (code & 0xFF) > 126) {
                return null;
            }
            index = ((code >>> 8) - (this._start[kind] >>> 8)) * 94 + ((code & 0xFF) - (this._start[kind] & 0xFF));
        }
        byte[] b = new byte[31];
        BookInputStream bis = this._file.getInputStream();
        try {
            bis.seek(this._page[kind], index * 32);
            bis.readFully(b, 0, b.length);
        }
        finally {
            bis.close();
        }
        try {
            ret = new String(b, "EUC-JP").trim();
            this._cache[kind].put(new Integer(code), ret);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return ret;
    }

    public boolean hasStopCode() {
        return this._stopCode[0] != 0;
    }

    public boolean isStopCode(int code0, int code1) {
        return this._stopCode[0] == code0 && this._stopCode[1] == code1;
    }
}

