/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBZipConstants;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class EBZipInputStream
extends BookInputStream
implements EBZipConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EBZipInputStream(FileInfo info) throws EBException {
        super(info);
        this.open();
        FileInfo fileInfo = info;
        synchronized (fileInfo) {
            if (info.realFileSize <= 0L) {
                this._init();
            }
        }
        this._cache = new byte[this._info.sliceSize];
    }

    private void _init() throws EBException {
        try {
            this._info.realFileSize = this._stream.length();
        }
        catch (IOException e) {
            throw new EBException(4, this._info.file.getPath(), e);
        }
        byte[] b = new byte[22];
        this.readRawFully(b, 0, b.length);
        this._info.zipLevel = b[5] & 0xF;
        this._info.sliceSize = 2048 << this._info.zipLevel;
        this._info.fileSize = ByteUtil.getLong4(b, 10);
        this._info.zipCrc = ByteUtil.getLong4(b, 14);
        this._info.zipIndexSize = this._info.fileSize < 65536L ? 2 : (this._info.fileSize < 0x1000000L ? 3 : 4);
        String str = new String(b, 0, 5);
        if (!str.equals("EBZip") || b[5] >>> 4 != 1 || this._info.sliceSize > 16384) {
            throw new EBException(5, this._info.file.getPath());
        }
    }

    public int getLevel() {
        return this._info.zipLevel;
    }

    public long getCRC() {
        return this._info.zipCrc;
    }

    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this._info.fileSize <= this._filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this._cachePos < 0L || this._filePos < this._cachePos || this._cachePos + (long)this._info.sliceSize <= this._filePos) {
                this._cachePos = this._filePos - this._filePos % (long)this._info.sliceSize;
                long pos = this._filePos / (long)this._info.sliceSize * (long)this._info.zipIndexSize + 22L;
                try {
                    this._stream.seek(pos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                byte[] buf = new byte[this._info.zipIndexSize * 2];
                this.readRawFully(buf, 0, buf.length);
                long slicePos = 0L;
                long nextSlicePos = 0L;
                switch (this._info.zipIndexSize) {
                    case 2: {
                        slicePos = ByteUtil.getInt2(buf, 0);
                        nextSlicePos = ByteUtil.getInt2(buf, 2);
                        break;
                    }
                    case 3: {
                        slicePos = ByteUtil.getInt3(buf, 0);
                        nextSlicePos = ByteUtil.getInt3(buf, 3);
                        break;
                    }
                    case 4: {
                        slicePos = ByteUtil.getLong4(buf, 0);
                        nextSlicePos = ByteUtil.getLong4(buf, 4);
                        break;
                    }
                }
                int sliceSize = (int)(nextSlicePos - slicePos);
                if (sliceSize <= 0 || this._info.sliceSize < sliceSize) {
                    return -1;
                }
                try {
                    this._stream.seek(slicePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                this._decode(sliceSize);
            }
            if (len - rlen < (n = (int)((long)this._info.sliceSize - this._filePos % (long)this._info.sliceSize))) {
                n = len - rlen;
            }
            if (this._info.fileSize - this._filePos < (long)n) {
                n = (int)(this._info.fileSize - this._filePos);
            }
            int p = (int)(this._filePos % (long)this._info.sliceSize);
            System.arraycopy(this._cache, p, b, off + rlen, n);
            rlen += n;
            this._filePos += (long)n;
        }
        return rlen;
    }

    private void _decode(int size) throws EBException {
        if (size == this._info.sliceSize) {
            this.readRawFully(this._cache, 0, size);
        } else {
            byte[] b = new byte[size];
            Inflater inf = new Inflater();
            try {
                this.readRawFully(b, 0, size);
                inf.setInput(b, 0, size);
                inf.inflate(this._cache, 0, this._info.sliceSize);
            }
            catch (DataFormatException e) {
                throw new EBException(5, this._info.file.getPath(), e);
            }
            finally {
                inf.end();
            }
        }
    }
}

