/*
 * Decompiled with CFR 0.152.
 */
package fuku.player;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;

public final class AudioPlayerApplet
extends JApplet
implements ActionListener,
LineListener,
MetaEventListener {
    private static final int PLAY = 0;
    private static final int PAUSE = 1;
    private static final int STOP = 2;
    private static final String[] ICON = new String[]{"fuku/player/resources/play16x16.png", "fuku/player/resources/pause16x16.png", "fuku/player/resources/stop16x16.png"};
    private static final Dimension ICON_SIZE = new Dimension(16, 16);
    private ImageIcon[] _icon = null;
    private boolean _loaded = false;
    private Clip _clip = null;
    private Sequencer _sequencer = null;
    private JButton _playBtn = null;
    private JButton _stopBtn = null;
    private int _pos = 0;
    private boolean _reset = false;

    public void init() {
        this._icon = new ImageIcon[ICON.length];
        for (int i = 0; i < ICON.length; ++i) {
            URL url = this.getClass().getClassLoader().getResource(ICON[i]);
            this._icon[i] = new ImageIcon(url);
        }
        this._playBtn = new JButton(this._icon[0]);
        this._playBtn.setMargin(new Insets(0, 0, 0, 0));
        this._playBtn.setPreferredSize(ICON_SIZE);
        this._playBtn.setMaximumSize(ICON_SIZE);
        this._playBtn.setMinimumSize(ICON_SIZE);
        this._playBtn.addActionListener(this);
        this._stopBtn = new JButton(this._icon[2]);
        this._stopBtn.setMargin(new Insets(0, 0, 0, 0));
        this._stopBtn.setPreferredSize(ICON_SIZE);
        this._stopBtn.setMaximumSize(ICON_SIZE);
        this._stopBtn.setMinimumSize(ICON_SIZE);
        this._stopBtn.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this._playBtn, "West");
        this.getContentPane().add((Component)this._stopBtn, "East");
    }

    private void _setup() {
        if (this._loaded) {
            return;
        }
        URL url = null;
        try {
            url = new URL(this.getDocumentBase(), this.getParameter("file"));
            AudioInputStream ais = AudioSystem.getAudioInputStream(url);
            DataLine.Info info = new DataLine.Info(Clip.class, ais.getFormat());
            this._clip = (Clip)AudioSystem.getLine(info);
            this._clip.addLineListener(this);
            this._clip.open(ais);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e1) {
            try {
                this._sequencer = MidiSystem.getSequencer();
                this._sequencer.addMetaEventListener(this);
                this._sequencer.open();
                this._sequencer.setSequence(MidiSystem.getSequence(url));
            }
            catch (InvalidMidiDataException imde) {
                System.err.println("Unsupported audio file.");
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
            }
        }
        this._loaded = true;
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.getContentPane().removeAll();
        if (this._clip != null) {
            this._clip.removeLineListener(this);
            if (this._clip.isRunning()) {
                this._clip.stop();
            }
            if (this._clip.isOpen()) {
                this._clip.close();
            }
            this._clip = null;
        }
        if (this._sequencer != null) {
            this._sequencer.removeMetaEventListener(this);
            if (this._sequencer.isRunning()) {
                this._sequencer.stop();
            }
            if (this._sequencer.isOpen()) {
                this._sequencer.close();
            }
            this._sequencer = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this._setup();
        Object obj = evt.getSource();
        if (obj instanceof JButton) {
            JButton btn = (JButton)obj;
            if (obj.equals(this._playBtn)) {
                if (this._clip != null) {
                    if (this._clip.isRunning()) {
                        this._clip.stop();
                    } else {
                        this._clip.setFramePosition(this._pos);
                        this._clip.start();
                    }
                } else if (this._sequencer != null) {
                    if (this._sequencer.isRunning()) {
                        this._sequencer.stop();
                        this._playBtn.setIcon(this._icon[0]);
                    } else {
                        this._sequencer.start();
                        this._playBtn.setIcon(this._icon[1]);
                    }
                }
            } else if (obj.equals(this._stopBtn)) {
                if (this._clip != null) {
                    if (this._clip.isRunning()) {
                        this._clip.stop();
                    }
                } else if (this._sequencer != null) {
                    if (this._sequencer.isRunning()) {
                        this._sequencer.stop();
                    }
                    this._playBtn.setIcon(this._icon[0]);
                }
                this._reset = true;
            }
        }
    }

    public void update(LineEvent evt) {
        if (this._clip == null) {
            return;
        }
        LineEvent.Type type = evt.getType();
        if (type.equals(LineEvent.Type.START)) {
            this._playBtn.setIcon(this._icon[1]);
        } else if (type.equals(LineEvent.Type.STOP)) {
            if (this._reset) {
                this._pos = 0;
                this._reset = false;
            } else if (this._pos >= this._clip.getFramePosition()) {
                this._pos = 0;
            } else {
                this._pos = this._clip.getFramePosition();
                if (this._pos < 0 || this._pos >= this._clip.getFrameLength()) {
                    this._pos = 0;
                }
            }
            this._playBtn.setIcon(this._icon[0]);
        }
    }

    public void meta(MetaMessage msg) {
        if (this._sequencer == null) {
            return;
        }
        if (msg.getType() == 47) {
            this._playBtn.setIcon(this._icon[0]);
        }
    }
}

