/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.tool;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.ExtFont;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.EBZipConstants;
import fuku.eb4j.io.EBZipInputStream;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.zip.Adler32;
import java.util.zip.Deflater;

public final class EBZip
implements EBZipConstants {
    private static final String _PROGRAM = "fuku.eb4j.tool.EBZip";
    private static final String DEFAULT_BOOK_DIR = ".";
    private static final String DEFAULT_OUTPUT_DIR = ".";
    private static final int OVERWRITE_NO = 0;
    private static final int OVERWRITE_QUERY = 1;
    private static final int OVERWRITE_FORCE = 2;
    private static final int ACTION_ZIP = 0;
    private static final int ACTION_UNZIP = 1;
    private static final int ACTION_INFO = 2;
    private static final DecimalFormat FMT = new DecimalFormat("##0.0'%'");
    private static final LongOpt[] LONGOPT = new LongOpt[]{new LongOpt("force-overwrite", 0, null, 102), new LongOpt("no-overwrite", 0, null, 110), new LongOpt("information", 0, null, 105), new LongOpt("keep", 0, null, 107), new LongOpt("level", 1, null, 108), new LongOpt("outpur-directory", 1, null, 111), new LongOpt("quiet", 0, null, 113), new LongOpt("skip-content", 1, null, 115), new LongOpt("subbook", 1, null, 83), new LongOpt("compress", 0, null, 122), new LongOpt("uncompress", 0, null, 117), new LongOpt("test", 0, null, 116), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
    private static String _bookDir = ".";
    private static String _outDir = ".";
    private static String[] _subbooks = null;
    private static int _overwrite = 1;
    private static int _level = 0;
    private static boolean _keep = false;
    private static boolean _quiet = false;
    private static boolean _test = false;
    private static boolean _skipFont = false;
    private static boolean _skipSound = false;
    private static boolean _skipGraphic = false;
    private static boolean _skipMovie = false;

    public static void main(String[] args) {
        int idx;
        int c;
        Getopt g = new Getopt(_PROGRAM, args, "fnikl:o:qs:S:zuthv", LONGOPT);
        int action = 0;
        StringTokenizer st = null;
        ArrayList<String> list = new ArrayList<String>(4);
        block20: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 102: {
                    _overwrite = 2;
                    continue block20;
                }
                case 110: {
                    _overwrite = 0;
                    continue block20;
                }
                case 105: {
                    action = 2;
                    continue block20;
                }
                case 107: {
                    _keep = true;
                    continue block20;
                }
                case 108: {
                    String level = g.getOptarg();
                    try {
                        _level = Integer.parseInt(level);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBZip: invalid compression level `" + level + "'");
                        System.exit(1);
                    }
                    if (_level <= 3 && _level >= 0) continue block20;
                    System.err.println("fuku.eb4j.tool.EBZip: invalid compression level `" + level + "'");
                    System.exit(1);
                    continue block20;
                }
                case 111: {
                    _outDir = g.getOptarg();
                    continue block20;
                }
                case 113: {
                    _quiet = true;
                    continue block20;
                }
                case 115: {
                    st = new StringTokenizer(g.getOptarg(), ",");
                    while (st.hasMoreTokens()) {
                        String skip = st.nextToken().trim().toLowerCase();
                        if (skip.equals("font")) {
                            _skipFont = true;
                            continue;
                        }
                        if (skip.equals("sound")) {
                            _skipSound = true;
                            continue;
                        }
                        if (skip.equals("graphic")) {
                            _skipGraphic = true;
                            continue;
                        }
                        if (skip.equals("movie")) {
                            _skipMovie = true;
                            continue;
                        }
                        System.err.println("fuku.eb4j.tool.EBZip: invalid content name `" + skip + "'");
                        System.exit(1);
                    }
                    continue block20;
                }
                case 83: {
                    st = new StringTokenizer(g.getOptarg(), ",");
                    while (st.hasMoreTokens()) {
                        list.add(st.nextToken().trim().toLowerCase());
                    }
                    continue block20;
                }
                case 122: {
                    action = 0;
                    continue block20;
                }
                case 117: {
                    action = 1;
                    continue block20;
                }
                case 116: {
                    _test = true;
                    continue block20;
                }
                case 104: {
                    EBZip._usage(0);
                    continue block20;
                }
                case 118: {
                    EBZip._version();
                    continue block20;
                }
            }
            EBZip._usage(1);
        }
        if (!list.isEmpty()) {
            _subbooks = list.toArray(new String[0]);
        }
        if ((idx = g.getOptind()) + 1 == args.length) {
            _bookDir = args[idx];
        } else if (idx + 1 < args.length) {
            System.err.println("fuku.eb4j.tool.EBZip: too many arguments");
            EBZip._usage(1);
        }
        EBZip ebzip = new EBZip();
        try {
            ebzip._exec(action);
        }
        catch (EBException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
    }

    private static void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java fuku.eb4j.tool.EBZip --help' for more information");
        } else {
            System.out.println("Usage: java fuku.eb4j.tool.EBZip [option...] [book-directory]");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  -f  --force-overwrite      force overwrite of output files");
            System.out.println("  -n  --no-overwrite         don't overwrite output files");
            System.out.println("  -i  --information          list information of compressed files");
            System.out.println("  -k  --keep                 keep (don't delete) original files");
            System.out.println("  -l INTEGER  --level INTEGER");
            System.out.println("                             compression level; 0..3");
            System.out.println("                             (default: 0)");
            System.out.println("  -o DIRECTORY  --output-directory DIRECTORY");
            System.out.println("                             output files under DIRECTORY");
            System.out.println("                             (default: .)");
            System.out.println("  -q  --quiet                suppress all warnings");
            System.out.println("  -s TYPE[,TYPE]  --skip-content TYPE[,TYPE]");
            System.out.println("                             skip content; font, graphic, sound or movie");
            System.out.println("                             (default: none is skipped)");
            System.out.println("  -S SUBBOOK[,SUBBOOK]  --subbook SUBBOOK[,SUBBOOK]");
            System.out.println("                             target subbook");
            System.out.println("                             (default: all subbook)");
            System.out.println("  -z  --compress             compress files");
            System.out.println("  -u  --uncompress           uncompress files");
            System.out.println("  -t  --test                 only check for input files");
            System.out.println("  -h  --help                 display this help and exit");
            System.out.println("  -v  --version              output version information and exit");
            System.out.println("");
            System.out.println("Argument:");
            System.out.println("  book-directory             top directory of a book");
            System.out.println("                             (default: .)");
            System.out.println("");
            System.out.println("Report bugs to <fukumoto@users.sourceforge.jp>.");
        }
        System.exit(status);
    }

    private static void _version() {
        System.out.println("fuku.eb4j.tool.EBZip 0.3.4");
        System.out.println("Copyright (c) 2002-2004 by Hisaya FUKUMOTO.");
        System.out.println("All right reserved.");
        System.exit(0);
    }

    private EBZip() {
    }

    private void _exec(int action) throws EBException {
        Book book = new Book(_bookDir);
        File root = new File(_bookDir);
        SubBook[] sub = book.getSubBooks();
        EBFile file = null;
        for (int i = 0; i < sub.length; ++i) {
            File[] files;
            if (_subbooks != null) {
                boolean show = false;
                String dir = sub[i].getName().toLowerCase();
                for (int j = 0; j < _subbooks.length; ++j) {
                    if (!_subbooks[j].equals(dir)) continue;
                    show = true;
                    break;
                }
                if (!show) continue;
            }
            if (book.getBookType() == 0) {
                file = sub[i].getTextFile();
                this._act(action, file);
                if (action != 1 || file.getFormat() != 4) continue;
                this._fixSEBXA(this._getOutFile(file, ".org"));
                continue;
            }
            file = sub[i].getTextFile();
            this._act(action, file);
            if (file.getName().compareToIgnoreCase("honmon2") == 0) {
                if (!_skipSound && (file = sub[i].getSoundFile()) != null) {
                    this._act(action, file);
                }
                if (!_skipGraphic && (file = sub[i].getGraphicFile()) != null) {
                    if (action == 0) {
                        this._copy(file);
                    } else {
                        this._act(action, file);
                    }
                }
            }
            if (!_skipFont) {
                for (int j = 0; j < 4; ++j) {
                    ExtFont font = sub[i].getFont(j);
                    if (font.hasWideFont()) {
                        file = font.getWideFontFile();
                        this._act(action, file);
                    }
                    if (!font.hasNarrowFont()) continue;
                    file = font.getNarrowFontFile();
                    this._act(action, file);
                }
            }
            if (_skipMovie || action == 2 || (files = sub[i].getMovieFileList()) == null) continue;
            for (int j = 0; j < files.length; ++j) {
                this._copy(this._getOutFile(files[j], null), files[j]);
            }
        }
        if (book.getBookType() == 0) {
            try {
                file = new EBFile(root, "language", 0);
                this._act(action, file);
            }
            catch (EBException e) {
                // empty catch block
            }
            file = new EBFile(root, "catalog", 0);
            if (action == 0) {
                this._copy(file);
            } else {
                this._act(action, file);
            }
        } else {
            file = new EBFile(root, "catalogs", 0);
            if (action == 0) {
                this._copy(file);
            } else {
                this._act(action, file);
            }
        }
    }

    private void _act(int action, EBFile file) {
        switch (action) {
            case 0: {
                this._zip(file);
                break;
            }
            case 1: {
                this._unzip(file);
                break;
            }
            case 2: {
                this._info(file);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _zip(EBFile file) {
        block57: {
            if (!_test) {
                this._mkdir(file);
            }
            File f = this._getOutFile(file, ".ebz");
            if (!_quiet) {
                System.out.println("==> compress " + file.getPath() + " <==");
                System.out.println("output to " + f.getPath());
            }
            if (f.equals(file.getFile())) {
                if (_quiet) return;
                System.out.println("the input and output files are the same, skipped.");
                System.out.println("");
                return;
            }
            if (!_test && !this._isOverwrite(f)) {
                return;
            }
            BookInputStream bis = null;
            AbstractInterruptibleChannel channel = null;
            try {
                bis = file.getInputStream();
                int sliceSize = 2048 << _level;
                long fileSize = bis.getFileSize();
                int indexSize = 0;
                indexSize = fileSize < 65536L ? 2 : (fileSize < 0x1000000L ? 3 : 4);
                int totalSlice = (int)((fileSize + (long)sliceSize - 1L) / (long)sliceSize);
                long indexLength = (totalSlice + 1) * indexSize;
                byte[] in = new byte[sliceSize];
                byte[] out = new byte[sliceSize + 1024];
                long slicePos = 22L + indexLength;
                if (!_test) {
                    long i;
                    channel = new FileOutputStream(f).getChannel();
                    Arrays.fill(out, 0, out.length, (byte)0);
                    for (i = slicePos; i >= (long)sliceSize; i -= (long)sliceSize) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(out, 0, sliceSize));
                    }
                    if (i > 0L) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(out, 0, (int)i));
                    }
                }
                long inTotalLength = 0L;
                long outTotalLength = 0L;
                int interval = 1024 >>> _level;
                Adler32 crc32 = new Adler32();
                Deflater def = new Deflater(9);
                for (int i = 0; i < totalSlice; ++i) {
                    bis.seek(inTotalLength);
                    int inLen = bis.read(in, 0, in.length);
                    if (inLen < 0) {
                        System.err.println("fuku.eb4j.tool.EBZip: failed to read the file (" + f.getPath() + ")");
                        return;
                    }
                    if (inLen == 0) {
                        System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF (" + f.getPath() + ")");
                        return;
                    }
                    if (inLen != in.length && inTotalLength + (long)inLen != fileSize) {
                        System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF (" + f.getPath() + ")");
                        return;
                    }
                    crc32.update(in, 0, inLen);
                    if (inLen < sliceSize) {
                        Arrays.fill(in, inLen, in.length, (byte)0);
                        inLen = sliceSize;
                    }
                    def.reset();
                    def.setInput(in, 0, inLen);
                    def.finish();
                    int outLen = 0;
                    while (!def.needsInput()) {
                        int n = def.deflate(out, outLen, out.length - outLen);
                        outLen += n;
                    }
                    if (outLen >= sliceSize) {
                        System.arraycopy(in, 0, out, 0, sliceSize);
                        outLen = sliceSize;
                    }
                    if (!_test) {
                        ((FileChannel)channel).position(((FileChannel)channel).size());
                        ((FileChannel)channel).write(ByteBuffer.wrap(out, 0, outLen));
                    }
                    long nextPos = slicePos + (long)outLen;
                    switch (indexSize) {
                        case 2: {
                            out[0] = (byte)(slicePos >>> 8 & 0xFFL);
                            out[1] = (byte)(slicePos & 0xFFL);
                            out[2] = (byte)(nextPos >>> 8 & 0xFFL);
                            out[3] = (byte)(nextPos & 0xFFL);
                            break;
                        }
                        case 3: {
                            out[0] = (byte)(slicePos >>> 16 & 0xFFL);
                            out[1] = (byte)(slicePos >>> 8 & 0xFFL);
                            out[2] = (byte)(slicePos & 0xFFL);
                            out[3] = (byte)(nextPos >>> 16 & 0xFFL);
                            out[4] = (byte)(nextPos >>> 8 & 0xFFL);
                            out[5] = (byte)(nextPos & 0xFFL);
                            break;
                        }
                        case 4: {
                            out[0] = (byte)(slicePos >>> 24 & 0xFFL);
                            out[1] = (byte)(slicePos >>> 16 & 0xFFL);
                            out[2] = (byte)(slicePos >>> 8 & 0xFFL);
                            out[3] = (byte)(slicePos & 0xFFL);
                            out[4] = (byte)(nextPos >>> 24 & 0xFFL);
                            out[5] = (byte)(nextPos >>> 16 & 0xFFL);
                            out[6] = (byte)(nextPos >>> 8 & 0xFFL);
                            out[7] = (byte)(nextPos & 0xFFL);
                            break;
                        }
                    }
                    if (!_test) {
                        ((FileChannel)channel).position(22 + i * indexSize);
                        ((FileChannel)channel).write(ByteBuffer.wrap(out, 0, indexSize * 2));
                    }
                    inTotalLength += (long)inLen;
                    outTotalLength += (long)(outLen + indexSize);
                    slicePos = nextPos;
                    if (_quiet || i % interval + 1 != interval) continue;
                    double rate = (double)(i + 1) / (double)totalSlice * 100.0;
                    System.out.println(FMT.format(rate) + " done (" + inTotalLength + " / " + fileSize + " bytes)");
                }
                def.end();
                out[0] = 69;
                out[1] = 66;
                out[2] = 90;
                out[3] = 105;
                out[4] = 112;
                out[5] = (byte)(0x10 | _level & 0xF);
                out[6] = 0;
                out[7] = 0;
                out[8] = 0;
                out[9] = 0;
                out[10] = (byte)(fileSize >>> 24 & 0xFFL);
                out[11] = (byte)(fileSize >>> 16 & 0xFFL);
                out[12] = (byte)(fileSize >>> 8 & 0xFFL);
                out[13] = (byte)(fileSize & 0xFFL);
                long crc = crc32.getValue();
                out[14] = (byte)(crc >>> 24 & 0xFFL);
                out[15] = (byte)(crc >>> 16 & 0xFFL);
                out[16] = (byte)(crc >>> 8 & 0xFFL);
                out[17] = (byte)(crc & 0xFFL);
                long mtime = System.currentTimeMillis();
                out[18] = (byte)(mtime >>> 24 & 0xFFL);
                out[19] = (byte)(mtime >>> 16 & 0xFFL);
                out[20] = (byte)(mtime >>> 8 & 0xFFL);
                out[21] = (byte)(mtime & 0xFFL);
                if (!_test) {
                    ((FileChannel)channel).position(0L);
                    ((FileChannel)channel).write(ByteBuffer.wrap(out, 0, 22));
                }
                outTotalLength += (long)(22 + indexSize);
                if (_quiet) break block57;
                System.out.println("completed (" + fileSize + " / " + fileSize + " bytes)");
                if (inTotalLength != 0L) {
                    double rate = (double)outTotalLength / (double)bis.getRealFileSize() * 100.0;
                    System.out.println(bis.getRealFileSize() + " -> " + outTotalLength + " bytes (" + FMT.format(rate) + ")");
                }
            }
            catch (EBException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
            catch (FileNotFoundException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
            catch (IOException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
            catch (SecurityException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
            finally {
                bis.close();
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (!_test && !_keep) {
            this._delete(file.getFile());
        }
        if (_quiet) return;
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _unzip(EBFile file) {
        if (file.getFormat() == 0) {
            this._copy(file);
            return;
        }
        if (!_test) {
            this._mkdir(file);
        }
        String suffix = null;
        if (file.getFormat() != 1) {
            suffix = ".org";
        }
        File f = this._getOutFile(file, suffix);
        if (!_quiet) {
            System.out.println("==> uncompress " + file.getPath() + " <==");
            System.out.println("output to " + f.getPath());
        }
        if (f.equals(file.getFile())) {
            if (_quiet) return;
            System.out.println("the input and output files are the same, skipped.");
            System.out.println("");
            return;
        }
        if (!_test && !this._isOverwrite(f)) {
            return;
        }
        BookInputStream bis = null;
        AbstractInterruptibleChannel channel = null;
        try {
            bis = file.getInputStream();
            byte[] b = new byte[bis.getSliceSize()];
            if (!_test) {
                channel = new FileOutputStream(f).getChannel();
            }
            long totalLength = 0L;
            int totalSlice = (int)((bis.getFileSize() + (long)bis.getSliceSize() - 1L) / (long)bis.getSliceSize());
            Adler32 crc32 = new Adler32();
            for (int i = 0; i < totalSlice; ++i) {
                bis.seek(totalLength);
                int n = bis.read(b, 0, b.length);
                if (n < 0) {
                    System.err.println("fuku.eb4j.tool.EBZip: failed to read the file (" + f.getPath() + ")");
                    return;
                }
                if (n == 0) {
                    System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF (" + f.getPath() + ")");
                    return;
                }
                if (n != b.length && totalLength + (long)n != bis.getFileSize()) {
                    System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF (" + f.getPath() + ")");
                    return;
                }
                if (bis instanceof EBZipInputStream) {
                    crc32.update(b, 0, n);
                }
                if (!_test) {
                    ((FileChannel)channel).write(ByteBuffer.wrap(b, 0, n));
                }
                totalLength += (long)n;
                if (_quiet || i % 1024 + 1 != 1024) continue;
                double rate = (double)(i + 1) / (double)totalSlice * 100.0;
                System.out.println(FMT.format(rate) + " done (" + totalLength + " / " + bis.getFileSize() + " bytes)");
            }
            if (!_quiet) {
                System.out.println("completed (" + bis.getFileSize() + " / " + bis.getFileSize() + " bytes)");
                System.out.println(bis.getRealFileSize() + " -> " + totalLength + " bytes");
            }
            if (bis instanceof EBZipInputStream && crc32.getValue() != ((EBZipInputStream)bis).getCRC()) {
                System.err.println("fuku.eb4j.tool.EBZip: CRC error (" + f.getPath() + ")");
                return;
            }
        }
        catch (EBException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        finally {
            bis.close();
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {}
            }
        }
        if (!_test && !_keep) {
            this._delete(file.getFile());
        }
        if (_quiet) return;
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _info(EBFile file) {
        System.out.println("==> " + file.getPath() + " <==");
        BookInputStream bis = null;
        try {
            bis = file.getInputStream();
        }
        catch (EBException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            System.out.println("");
            return;
        }
        finally {
            bis.close();
        }
        StringBuffer buf = new StringBuffer();
        String text = null;
        switch (file.getFormat()) {
            case 0: {
                buf.append(bis.getFileSize());
                buf.append(" bytes (not compressed)");
                break;
            }
            case 1: {
                int level = ((EBZipInputStream)bis).getLevel();
                text = "ebzip level " + level + " compression)";
                break;
            }
            case 4: {
                text = "S-EBXA compression)";
                break;
            }
            default: {
                text = "EPWING compression)";
            }
        }
        if (text != null) {
            long size = bis.getFileSize();
            long real = bis.getRealFileSize();
            buf.append(Long.toString(size)).append(" -> ");
            buf.append(Long.toString(real)).append(" bytes (");
            if (size == 0L) {
                System.out.print("empty original file, ");
            } else {
                double rate = (double)real / (double)size * 100.0;
                buf.append(FMT.format(rate));
                buf.append(", ");
            }
            buf.append(text);
        }
        System.out.println(buf.toString());
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fixSEBXA(File file) {
        if (!_quiet) {
            System.out.println("==> fix " + file.getPath() + " <==");
        }
        FileChannel channel = null;
        boolean err = false;
        try {
            int i;
            channel = new RandomAccessFile(file, "rw").getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_WRITE, 0L, 2048L);
            int indexCount = buf.get(1) & 0xFF;
            int removeCount = 0;
            int inOff = 16;
            int outOff = 16;
            for (i = 0; i < indexCount; ++i) {
                int index = buf.get(inOff) & 0xFF;
                if (index == 33 || index == 34) {
                    ++removeCount;
                } else {
                    if (inOff != outOff) {
                        for (int j = 0; j < 16; ++j) {
                            buf.put(outOff + j, buf.get(inOff + j));
                        }
                    }
                    outOff += 16;
                }
                inOff += 16;
            }
            for (i = 0; i < removeCount; ++i) {
                for (int j = 0; j < 16; ++j) {
                    buf.put(outOff + j, (byte)0);
                }
                outOff += 16;
            }
            buf.force();
        }
        catch (FileNotFoundException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            err = true;
        }
        catch (IOException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            err = true;
        }
        catch (SecurityException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            err = true;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {}
            }
        }
        if (!_quiet) {
            if (!err) {
                System.out.println("complated");
            }
            System.out.println("");
        }
    }

    private File _getOutFile(EBFile file, String suffix) {
        return this._getOutFile(file.getFile(), suffix);
    }

    private File _getOutFile(File file, String suffix) {
        String bookDir = null;
        String inFile = null;
        try {
            bookDir = new File(_bookDir).getCanonicalPath();
            inFile = file.getCanonicalPath();
        }
        catch (IOException e) {
            System.err.println("fuku.eb4j.tool.EBZip: can't get canonical path");
            System.exit(1);
        }
        String fname = inFile.substring(bookDir.length());
        if (fname.length() > 4) {
            String s = fname.substring(fname.length() - 4);
            if (s.compareToIgnoreCase(".ebz") == 0) {
                fname = fname.substring(0, fname.length() - 4);
            } else if (s.compareToIgnoreCase(".org") == 0) {
                fname = fname.substring(0, fname.length() - 4);
            }
        }
        if (suffix != null) {
            fname = fname + suffix;
        }
        return new File(_outDir, fname);
    }

    private void _mkdir(EBFile file) {
        this._mkdir(this._getOutFile(file, null));
    }

    private void _mkdir(File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException e) {
                System.err.println("fuku.eb4j.tool.EBZip: can't create directory (" + e.getMessage() + ")");
                System.exit(1);
            }
        }
    }

    private void _copy(EBFile file) {
        this._copy(file.getFile(), this._getOutFile(file, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copy(File file1, File file2) {
        if (!_test) {
            this._mkdir(file2);
        }
        if (!_quiet) {
            System.out.println("==> copy " + file1.getPath() + " <==");
            System.out.println("output to " + file2.getPath());
        }
        if (file1.equals(file2)) {
            if (!_quiet) {
                System.out.println("the input and output files are the same, skipped.");
                System.out.println("");
            }
            return;
        }
        if (_test) {
            if (!_quiet) {
                System.out.println("");
            }
            return;
        }
        if (!this._isOverwrite(file2)) {
            return;
        }
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(file1).getChannel();
            out = new FileOutputStream(file2).getChannel();
            in.transferTo(0L, (int)in.size(), (WritableByteChannel)((Object)out));
            if (!_quiet) {
                System.out.println("completed (" + in.size() + " / " + ((FileChannel)out).size() + " bytes)");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        if (!_keep) {
            this._delete(file1);
        }
        if (!_quiet) {
            System.out.println("");
        }
    }

    private void _delete(File file) {
        try {
            if (!file.delete()) {
                System.err.println("fuku.eb4j.tool.EBZip: failed to delete the file (" + file.getPath() + ")");
            }
        }
        catch (SecurityException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
    }

    private boolean _isOverwrite(File file) {
        if (!file.exists()) {
            return true;
        }
        if (_overwrite == 0) {
            if (!_quiet) {
                System.err.println("already exists, skip the file");
                System.err.println("");
            }
            return false;
        }
        if (_overwrite == 1) {
            while (true) {
                System.err.println("");
                System.err.println("the file already exists: " + file.getPath());
                System.err.print("do you wish to overwrite (y or n)? ");
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(System.in));
                    String line = br.readLine();
                    if (line == null) continue;
                    if ((line = line.trim()).compareToIgnoreCase("y") != 0) {
                        if (line.compareToIgnoreCase("n") != 0) continue;
                        System.err.println("");
                        return false;
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            System.err.println("");
        }
        return true;
    }
}

