package fuku.eb4j;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;

/**
 * Хʥǡ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class BinaryData {

    /** 顼Υإå */
    private static final int COLOR_GRAPHIC_HEADER = 8;

    /** Хʥǡե */
    private EBFile _file = null;
    /** ǥå */
    private IndexStyle _style = null;


    /**
     * 󥹥ȥ饯
     *
     * @param bis Хʥǡե
     * @param style ǥå
     */
    BinaryData(EBFile file, IndexStyle style) {
        super();
        _file = file;
        _style = style;
    }


    /**
     * ֤ΥΥǡ֤ޤ
     *
     * @param pos ǡ
     * @param width 
     * @param height ⤵
     * @return Υǡ(bitmap)ΥХ
     * @exception EBException եɤ߹˥顼ȯ
     */
    public byte[] getMonoGraphic(long pos, int width, int height) throws EBException {
        byte[] img = null;
        BookInputStream bis = _file.getInputStream();
        try {
            // ⤵0ξ硢⤵֤ɤ߽Ф
            if (width == 0 && height == 0) {
                byte[] b = new byte[22];
                bis.seek(pos);
                bis.readFully(b, 0, b.length);
                if (ByteUtil.getInt2(b, 0) != 0x1f45
                    || ByteUtil.getInt2(b, 4) != 0x1f31) {
                    throw new EBException(EBException.UNEXP_FILE, _file.getPath());
                }
                width = ByteUtil.getBCD2(b, 8);
                height = ByteUtil.getBCD2(b, 10);
                if (ByteUtil.getInt2(b, 12) == 0x1f51) {
                    pos = BookInputStream.getPosition(ByteUtil.getBCD4(b, 14),
                                                      ByteUtil.getBCD2(b, 18));
                } else if (ByteUtil.getInt2(b, 14) == 0x1f51) {
                    pos = BookInputStream.getPosition(ByteUtil.getBCD4(b, 16),
                                                      ByteUtil.getBCD2(b, 20));
                } else {
                    throw new EBException(EBException.UNEXP_FILE, _file.getPath());
                }
            }

            if (width <= 0 || height <= 0) {
                return null;
            }

            bis.seek(pos);
            int size = (width+7)/8 * height;
            img = new byte[size];
            bis.readFully(img, 0, img.length);
        } finally {
            bis.close();
        }
        return img;
    }

    /**
     * ֤Υ顼ǡ֤ޤ
     *
     * @param pos ǡ
     * @return 顼ǡ(JPEG/DIB)ΥХ
     * @exception EBException եɤ߹˥顼ȯ
     */
    public byte[] getColorGraphic(long pos) throws EBException {
        byte[] img = null;
        BookInputStream bis = _file.getInputStream();
        try {
            bis.seek(pos);
            byte[] b = new byte[COLOR_GRAPHIC_HEADER];
            bis.readFully(b, 0, b.length);

            int size = 0;
            if (new String(b, 0, 4).equals("data")) {
                size = (int)ByteUtil.getLongLE4(b, 4);
            }
            img = new byte[size];
            bis.readFully(img, 0, img.length);
        } finally {
            bis.close();
        }
        return img;
    }

    /**
     * ֤WAVEǡ֤ޤ
     *
     * @param pos1 ǡϰ
     * @param pos2 ǡλ
     * @return WAVEǡΥХ
     * @exception EBException եɤ߹˥顼ȯ
     */
    public byte[] getWaveSound(long pos1, long pos2) throws EBException {
        long size = 0;
        if (pos1 < pos2) {
            size = pos2 - pos1;
        } else {
            throw new EBException(EBException.UNEXP_FILE, _file.getPath());
        }

        /* WAVE Format
         *  "RIFF"
         *  size (4byte) = "WAVE" + header fragment + size of data part + data
         *  "WAVE"
         *  header fragment (28byte)
         *  size of data part (4byte)
         */
        byte[] wave = null;
        BookInputStream bis = _file.getInputStream();
        try {
            bis.seek(pos1);
            byte[] b = new byte[4];
            bis.readFully(b, 0, b.length);
            int off = 0;
            if (new String(b, 0, 4).equals("fmt ")) {
                size -= 32;
                wave = new byte[(int)(44+size)];
                System.arraycopy(b, 0, wave, 12, 4);
                off = 16;
            } else {
                wave = new byte[(int)(44+size)];
                bis.seek(_style.getStartPage(), 32);
                bis.readFully(wave, 12, 28);
                wave[40] = (byte)(size & 0xff);
                wave[41] = (byte)((size >>> 8) & 0xff);
                wave[42] = (byte)((size >>> 16) & 0xff);
                wave[43] = (byte)((size >>> 24) & 0xff);
                off = 44;
                bis.seek(pos1);
            }
            bis.readFully(wave, off, wave.length-off);
        } finally {
            bis.close();
        }

        wave[0] = 'R';
        wave[1] = 'I';
        wave[2] = 'F';
        wave[3] = 'F';
        wave[4] = (byte)((36+size) & 0xff);
        wave[5] = (byte)(((36+size) >>> 8) & 0xff);
        wave[6] = (byte)(((36+size) >>> 16) & 0xff);
        wave[7] = (byte)(((36+size) >>> 24) & 0xff);
        wave[8] = 'W';
        wave[9] = 'A';
        wave[10] = 'V';
        wave[11] = 'E';
        return wave;
    }

    /**
     * ֤MIDIǡ֤ޤ
     *
     * @param pos1 ǡϰ
     * @param pos2 ǡλ
     * @return MIDIǡΥХ
     * @exception EBException եɤ߹˥顼ȯ
     */
    public byte[] getMidiSound(long pos1, long pos2) throws EBException {
        long size = 0;
        if (pos1 < pos2) {
            size = pos2 - pos1;
        } else {
            throw new EBException(EBException.UNEXP_FILE, _file.getPath());
        }

        byte[] midi = new byte[(int)size];
        BookInputStream bis = _file.getInputStream();
        try {
            bis.seek(pos1);
            bis.readFully(midi, 0, midi.length);
        } finally {
            bis.close();
        }
        return midi;
    }
}

// end of BinaryData.java
