package fuku.eb4j;

import java.io.*;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;

/**
 * ҥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class Book {

    /** Żҥ֥å(EB/EBG/EBXA/EBXA-C/S-EBXA)򼨤 */
    public static final int DISC_EB = 0;
    /** EPWINGνҤ򼨤 */
    public static final int DISC_EPWING = 1;

    /** ISO 8859-1ʸåȤ򼨤 */
    public static final int CHARCODE_ISO8859_1 = 1;
    /** JIS X 0208ʸåȤ򼨤 */
    public static final int CHARCODE_JISX0208 = 2;
    /** JIS X 0208/GB 2312ʸåȤ򼨤 */
    public static final int CHARCODE_JISX0208_GB2312 = 3;

    /** CATALOG(S)եΥǡ */
    static final int[] SIZE_CATALOG = {40, 164};
    /** ȥΥǡ */
    static final int[] SIZE_TITLE = {30, 80};
    /** ǥ쥯ȥ̾Υǡ */
    static final int SIZE_DIRNAME = 8;

    /** ʸɤȽǤǤʤҤκǽܤΥȥ */
    private static final String[] MISLEADED = {
        // SONY DataDiskMan (DD-DR1) accessories.
        // (ܥӥͥܥ饦)
        "%;%s%A%e%j!\\%S%8%M%9!\\%/%i%&%s",
        // Shin Eiwa Waei Chujiten (earliest edition)
        // (ҡ漭ŵ)
        "8&5f<R!!?71QOBCf<-E5",
        // EB Kagakugijutsu Yougo Daijiten (YRRS-048)
        // (ţ²ʳصѸ缭ŵ)
        "#E#B2J3X5;=QMQ8lBg<-E5",
        // Japanese-English-Spanish Jiten (YRRS-060)
        // (ţΣǡʣΡʡܣӣУ)
        "#E#N#G!?#J#A#N!J!\\#S#P#A!K"
    };


    /** ҤΥǥ쥯ȥ */
    private String _bookPath = null;

    /** Ҥμ */
    private int _bookType = -1;
    /** ʸåȤμ */
    private int _charCode = -1;
    /** EPWINGեޥåȤΥС */
    private int _version = -1;

    /**  */
    private SubBook[] _sub = null;


    /**
     * 󥹥ȥ饯
     *
     * @param bookPath ҤΥѥ
     * @exception EBException ˥顼ȯ
     */
    public Book(String bookPath) throws EBException {
        this(bookPath, null);
    }

    /**
     * 󥹥ȥ饯
     *
     * @param bookPath ҤΥѥ
     * @param appendixPath ϿѥåΥѥ
     * @exception EBException ˥顼ȯ
     */
    public Book(String bookPath, String appendixPath) throws EBException {
        super();

        _bookPath = bookPath;
        File dir = new File(bookPath);
        if (!dir.isDirectory()) {
            throw new EBException(EBException.DIR_NOT_FOUND, bookPath);
        }
        if (!dir.canRead()) {
            throw new EBException(EBException.CANT_READ_DIR, bookPath);
        }
        _loadLanguage(dir);
        _loadCatalog(dir);

        // Ͽѥå
        if (appendixPath != null && appendixPath.length() > 0) {
            Appendix appendix = new Appendix(appendixPath);
            SubAppendix[] sa = appendix.getSubAppendixes();
            if (sa != null) {
                int len = sa.length;
                if (len > _sub.length) {
                    len = _sub.length;
                }
                for (int i=0; i<len; i++) {
                    _sub[i].setAppendix(sa[i]);
                }
            }
        }
    }


    /**
     * νҤΥѥʸ֤ޤ
     *
     * @return ҤΥѥʸ
     */
    public String getPath() {
        return _bookPath;
    }

    /**
     * νҤμ֤ޤ
     *
     * @return Ҥμ򼨤ե饰
     * @see Book#DISC_EB
     * @see Book#DISC_EPWING
     */
    public int getBookType() {
        return _bookType;
    }

    /**
     * νҤʸåȤ֤ޤ
     *
     * @return ҤʸåȤ򼨤ե饰
     * @see Book#CHARCODE_ISO8859_1
     * @see Book#CHARCODE_JISX0208
     * @see Book#CHARCODE_JISX0208_GB2312
     */
    public int getCharCode() {
        return _charCode;
    }

    /**
     * νҤ֤ܿޤ
     *
     * @return ܿ
     */
    public int getSubBookCount() {
        int ret = 0;
        if (_sub != null) {
            ret = _sub.length;
        }
        return ret;
    }

    /**
     * νҤܥꥹȤ֤ޤ
     *
     * @return ܤ
     */
    public SubBook[] getSubBooks() {
        return _sub;
    }

    /**
     * νҤλꤷǥåܤ֤ޤ
     *
     * @param index ǥå
     * @return  (ϰϳΥǥånull)
     */
    public SubBook getSubBook(int index) {
        if (index < 0 || index >= _sub.length) {
            return null;
        }
        return _sub[index];
    }

    /**
     * EPWINGΥС֤ޤ
     *
     * @return EPWINGΥС
     */
    public int getVersion() {
        return _version;
    }

    /**
     * CATALOG(S)ե뤫ɤ߹ߤޤ
     *
     * @param dir ҤΥǥ쥯ȥ
     * @exception EBException CATALOG(S)եɤ߹˥顼ȯ
     */
    private void _loadCatalog(File dir) throws EBException {
        // եθ
        EBFile file = null;
        try {
            file = new EBFile(dir, "catalog", EBFile.FORMAT_PLAIN);
            _bookType = DISC_EB;
            _loadCatalogEB(file);
        } catch (EBException e) {
            file = new EBFile(dir, "catalogs", EBFile.FORMAT_PLAIN);
            _bookType = DISC_EPWING;
            _loadCatalogEPWING(file);
        }
    }

    /**
     * CATALOGե뤫ɤ߹ߤޤ
     *
     * @param file CATALOGե
     * @exception EBException CATALOGեɤ߹˥顼ȯ
     */
    private void _loadCatalogEB(EBFile file) throws EBException {
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);

            // ܿμ
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(EBException.UNEXP_FILE, file.getPath());
            }

            // ܤξ
            _sub = new SubBook[subCount];
            b = new byte[SIZE_CATALOG[DISC_EB]];
            for (int i=0; i<subCount; i++) {
                bis.readFully(b, 0, b.length);

                // ȥμ
                int off = 2;
                String title = null;
                if (_charCode == CHARCODE_ISO8859_1) {
                    title = new String(b, off, SIZE_TITLE[DISC_EB]).trim();
                    // ȥνɬפɤĴ٤
                    for (int j=0; j<MISLEADED.length; j++) {
                        if (title.equals(MISLEADED[j])) {
                            // ȥν
                            _charCode = CHARCODE_JISX0208;
                            byte[] tmp = title.getBytes();
                            title = ByteUtil.jisx0208ToString(tmp, 0, tmp.length);
                            break;
                        }
                    }
                } else {
                    title = ByteUtil.jisx0208ToString(b, off,
                                                      SIZE_TITLE[DISC_EB]);
                }
                off += SIZE_TITLE[DISC_EB];

                // ǥ쥯ȥ̾μ
                String name = new String(b, off, SIZE_DIRNAME).trim();
                off += SIZE_DIRNAME;

                // ܥ֥Ȥκ
                String[] fname = new String[3];
                int[] format = new int[3];
                fname[0] = "start";
                format[0] = EBFile.FORMAT_PLAIN;
                _sub[i] = new SubBook(this, title, name, 1,
                                      fname, format, null, null);
            }
        } finally {
            bis.close();
        }
    }

    /**
     * CATALOGSե뤫ɤ߹ߤޤ
     *
     * @param file CATALOGSե
     * @exception EBException CATALOGSեɤ߹˥顼ȯ
     */
    private void _loadCatalogEPWING(EBFile file) throws EBException {
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);

            // ܿμ
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(EBException.UNEXP_FILE, file.getPath());
            }

            // EPWINGΥС
            _version = b[3] & 0xff;

            // ܤξ
            _sub = new SubBook[subCount];
            b = new byte[SIZE_CATALOG[DISC_EPWING]];
            for (int i=0; i<subCount; i++) {
                bis.seek(16 + i * b.length);
                bis.readFully(b, 0, b.length);

                // ȥμ
                int off = 2;
                String title = null;
                if (_charCode == CHARCODE_ISO8859_1) {
                    title = new String(b, off, SIZE_TITLE[DISC_EPWING]).trim();
                    // ȥνɬפɤĴ٤
                    for (int j=0; j<MISLEADED.length; j++) {
                        if (title.equals(MISLEADED[j])) {
                            // ȥν
                            _charCode = CHARCODE_JISX0208;
                            byte[] tmp = title.getBytes();
                            title = ByteUtil.jisx0208ToString(tmp, 0, tmp.length);
                            break;
                        }
                    }
                } else {
                    title = ByteUtil.jisx0208ToString(b, off,
                                                      SIZE_TITLE[DISC_EPWING]);
                }
                off += SIZE_TITLE[DISC_EPWING];

                // ǥ쥯ȥ̾μ
                String name = new String(b, off, SIZE_DIRNAME).trim();
                off += SIZE_DIRNAME;

                // ǥåֹμ
                int index = ByteUtil.getInt2(b, off+4);
                off += 6;

                // ե̾μ
                String[] narrow = new String[4];
                String[] wide = new String[4];
                off += 4;
                for (int j=0; j<4; j++) {
                    // ѳ
                    if (b[off] != '\0' && b[off] < 0x80) {
                        wide[j] = new String(b, off, SIZE_DIRNAME).trim();
                    }
                    // Ⱦѳ
                    if (b[off+32] != '\0' && b[off+32] < 0x80) {
                        narrow[j] = new String(b, off+32, SIZE_DIRNAME).trim();
                    }
                    off += SIZE_DIRNAME;
                }

                // ܤΥե̾μ
                bis.seek(16 + (subCount + i) * b.length);
                bis.readFully(b, 0, b.length);
                String[] fname = new String[3];
                int[] format = new int[3];
                if ((b[4] & 0xff) != 0) {
                    // ʸƥȥե̾
                    fname[0] = new String(b, 4, SIZE_DIRNAME).trim();
                    format[0] = b[55] & 0xff;

                    int dataType = ByteUtil.getInt2(b, 41);
                    // ե̾
                    if ((dataType & 0x03) == 0x02) {
                        fname[1] = new String(b, 44, SIZE_DIRNAME).trim();
                        format[1] = b[54] & 0xff;
                    } else if (((dataType>>>8) & 0x03) == 0x02) {
                        fname[1] = new String(b, 56, SIZE_DIRNAME).trim();
                        format[1] = b[53] & 0xff;
                    }

                    // ե̾
                    if ((dataType & 0x03) == 0x01) {
                        fname[2] = new String(b, 44, SIZE_DIRNAME).trim();
                        format[2] = b[54] & 0xff;
                    } else if (((dataType>>>8) & 0x03) == 0x01) {
                        fname[2] = new String(b, 56, SIZE_DIRNAME).trim();
                        format[2] = b[53] & 0xff;
                    }

                    for (int j=0; j<3; j++) {
                        switch (format[j]) {
                            case 0x00:
                                format[j] = EBFile.FORMAT_PLAIN;
                                break;
                            case 0x11:
                                format[j] = EBFile.FORMAT_EPWING;
                                break;
                            case 0x12:
                                format[j] = EBFile.FORMAT_EPWING6;
                                break;
                            default:
                                throw new EBException(EBException.UNEXP_FILE, file.getPath());
                        }
                    }
                } else {
                    fname[0] = "honmon";
                    format[0] = EBFile.FORMAT_PLAIN;
                }

                // ܥ֥Ȥκ
                _sub[i] = new SubBook(this, title, name, index,
                                      fname, format, narrow, wide);
            }
        } finally {
            bis.close();
        }
    }

    /**
     * LANGUAGEե뤫ɤ߹ߤޤ
     *
     * @param dir ҤΥǥ쥯ȥ
     * @exception EBException LANGUAGEեɤ߹˥顼ȯ
     */
    private void _loadLanguage(File dir) throws EBException {
        _charCode = CHARCODE_JISX0208;

        EBFile file = null;
        try {
            file = new EBFile(dir, "language", EBFile.FORMAT_PLAIN);
        } catch (EBException e) {
        }
        if (file == null) {
            return;
        }

        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            if (bis.read(b, 0, b.length) != b.length) {
                return;
            }
            _charCode = ByteUtil.getInt2(b, 0);
        } finally {
            if (bis != null) {
                bis.close();
            }
        }
    }
}

// end of Book.java
