package fuku.eb4j;

import fuku.eb4j.io.BookInputStream;

/**
 * ̥饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class Result {

    /** Ф */
    private long _heading = 0L;
    /** ʸ */
    private long _text = 0L;


    /**
     * 󥹥ȥ饯
     *
     * @param headPage Ф֤Υڡֹ
     * @param headOff Ф֤Υڡ⥪եå
     * @param textPage ʸ֤Υڡֹ
     * @param textOff ʸ֤Υڡ⥪եå
     */
    Result(long headPage, int headOff, long textPage, int textOff) {
        this(BookInputStream.getPosition(headPage, headOff),
             BookInputStream.getPosition(textPage, textOff));
    }

    /**
     * 󥹥ȥ饯
     *
     * @param heading Ф
     * @param textPage ʸ֤Υڡֹ
     * @param textOff ʸ֤Υڡ⥪եå
     */
    Result(long heading, long textPage, int textOff) {
        this(heading, BookInputStream.getPosition(textPage, textOff));
    }

    /**
     * 󥹥ȥ饯
     *
     * @param headPage Ф֤Υڡֹ
     * @param headOff Ф֤Υڡ⥪եå
     * @param text ʸ
     */
    Result(long headPage, int headOff, long text) {
        this(BookInputStream.getPosition(headPage, headOff), text);
    }

    /**
     * 󥹥ȥ饯
     *
     * @param heading Ф
     * @param text ʸ
     */
    Result(long heading, long text) {
        super();
        _heading = heading;
        _text = text;
    }


    /**
     * ̤θФ֤֤ޤ
     *
     * @return θФǡ
     */
    public long getHeadingPosition() {
        return _heading;
    }

    /**
     * ̤ʸ֤֤ޤ
     *
     * @return ʸǡ
     */
    public long getTextPosition() {
        return _text;
    }
}

// end of Result.java
