package fuku.eb4j;

import java.io.*;
import java.util.*;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;

/**
 * Ͽѥåܥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class SubAppendix {

    /** ʸĹ */
    private static final int ALTERNATION_TEXT_LENGTH = 31;

    /** Ͽѥå */
    private Appendix _appendix = null;
    /** Ͽǡե */
    private EBFile _file = null;

    /** ϥڡ */
    private long[] _page = new long[2];
    /** ʸ */
    private int[] _start = new int[2];
    /** λʸ */
    private int[] _end = new int[2];

    /** ʸåȤμ */
    private int _charCode = -1;
    /** ȥåץ */
    private int[] _stopCode = new int[2];

    /** ʸΥå */
    private Map[] _cache = new Map[2];


    /**
     * 󥹥ȥ饯
     *
     * @param appendix Ͽѥå
     * @param path ܤΥǥ쥯ȥ̾
     * @exception EBException եɤ߹˥顼ȯ
     */
    SubAppendix(Appendix appendix, String path) throws EBException {
        super();
        _appendix = appendix;

        if (_appendix.getAppendixType() == Book.DISC_EB) {
            _setupEB(path);
        } else {
            _setupEPWING(path);
        }
        _load();
    }

    /**
     * ܤϿѥåǤΥѥꤷޤ
     *
     * @param path ѥ̾
     * @exception EBException ѥ˥顼ȯ
     */
    private void _setupEB(String path) throws EBException {
        File dir = EBFile.searchDirectory(_appendix.getPath(), path);
        _file = new EBFile(dir, "appendix", EBFile.FORMAT_PLAIN);
    }

    /**
     * ܤϿѥåǤΥѥꤷޤ
     *
     * @param path ѥ̾
     * @exception EBException ѥ˥顼ȯ
     */
    private void _setupEPWING(String path) throws EBException {
        File dir = EBFile.searchDirectory(_appendix.getPath(), path);
        File dataDir = EBFile.searchDirectory(dir, "data");
        _file = new EBFile(dataDir, "furoku", EBFile.FORMAT_PLAIN);
    }

    /**
     * ܤξɤ߹ߤޤ
     *
     * @exception EBException եɤ߹˥顼ȯ
     */
    private void _load() throws EBException {
        byte[] b = new byte[16];
        BookInputStream bis = _file.getInputStream();
        try {
            // ʸåȤμ
            bis.seek(0);
            bis.readFully(b, 0, b.length);
            _charCode = ByteUtil.getInt2(b, 2);

            // Ⱦѳʸμ
            for (int i=0; i<2; i++) {
                bis.readFully(b, 0, b.length);
                int charCount = ByteUtil.getInt2(b, 12);
                if (charCount <= 0) {
                    _page[i] = -1;
                    _start[i] = -1;
                    _end[i] = -1;
                    _cache[i] = null;
                    continue;
                }
                _page[i] = ByteUtil.getLong4(b, 0);
                _start[i] = ByteUtil.getInt2(b, 10);
                if (_charCode == Book.CHARCODE_ISO8859_1) {
                    _end[i] = (_start[i]
                               + ((charCount / 0xfe) << 8)
                               + (charCount % 0xfe) - 1);
                    if ((_end[i] & 0xff) > 0xfe) {
                        _end[i] += 3;
                    }
                    if ((_start[i] & 0xff) < 0x01 || (_start[i] & 0xff) > 0xfe
                        || _start[i] < 0x0001 || _start[i] > 0x1efe) {
                        throw new EBException(EBException.UNEXP_FILE, _file.getPath());
                    }
                } else {
                    _end[i] = (_start[i]
                               + ((charCount / 0x5e) << 8)
                               + (charCount % 0x5e) - 1);
                    if ((_end[i] & 0xff) > 0x7e) {
                        _end[i] += 0xa3;
                    }
                    if ((_start[i] & 0xff) < 0x21 || (_start[i] & 0xff) > 0x7e
                        || _start[i] < 0xa121 || _end[i] > 0xfe7e) {
                        throw new EBException(EBException.UNEXP_FILE, _file.getPath());
                    }
                }
                _cache[i] = new HashMap(charCount+1, (float)1.0);
            }

            // ȥåץɾμ
            bis.readFully(b, 0, b.length);
            long stopCodePage = ByteUtil.getLong4(b, 0);
            if (stopCodePage > 0) {
                bis.seek(stopCodePage, 0);
                bis.readFully(b, 0, b.length);
                if (ByteUtil.getInt2(b, 0) != 0) {
                    _stopCode[0] = ByteUtil.getInt2(b, 2);
                    _stopCode[1] = ByteUtil.getInt2(b, 4);
                } else {
                    _stopCode[0] = 0;
                    _stopCode[1] = 0;
                }
            }
        } finally {
            bis.close();
        }
    }

    /**
     * ܤȾѳʸޤޤƤ뤫ɤȽ̤ޤ
     *
     * @return ȾѳʸޤޤƤtrueǤʤfalse
     */
    public boolean hasNarrowFontAlt() {
        if (_page[ExtFont.NARROW] <= 0) {
            return false;
        }
        return true;
    }

    /**
     * ܤѳʸޤޤƤ뤫ɤȽ̤ޤ
     *
     * @return ѳʸޤޤƤtrueǤʤfalse
     */
    public boolean hasWideFontAlt() {
        if (_page[ExtFont.NARROW] <= 0) {
            return false;
        }
        return true;
    }

    /**
     * ꤵ줿ʸɤȾѳʸ֤ޤ
     *
     * @param code ʸ
     * @return Ⱦѳʸ (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     */
    public String getNarrowFontAlt(int code) throws EBException {
        return _getFontAlt(ExtFont.NARROW, code);
    }

    /**
     * ꤵ줿ʸɤѳʸ֤ޤ
     *
     * @param code ʸ
     * @return ѳʸ (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     */
    public String getWideFontAlt(int code) throws EBException {
        return _getFontAlt(ExtFont.WIDE, code);
    }

    /**
     * ꤵ줿ʸɤγʸ֤ޤ
     *
     * @param kind Ⱦ/
     * @param code ʸ
     * @return ʸ (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     * @see ExtFont#WIDE
     * @see ExtFont#NARROW
     */
    private String _getFontAlt(int kind, int code) throws EBException {
        if (_page[kind] <= 0) {
            return null;
        }
        if (code < _start[kind] || code > _end[kind]) {
            return null;
        }

        String ret = (String)_cache[kind].get(new Integer(code));
        if (ret != null) {
            return ret;
        }

        int index = 0;
        if (_charCode == Book.CHARCODE_ISO8859_1) {
            if ((code & 0xff) < 0x01 || (code & 0xff) > 0xfe) {
                return null;
            }
            index = ((code >>> 8) - (_start[kind] >>> 8)) * 0xfe
                + ((code & 0xff) - (_start[kind] & 0xff));
        } else {
            if ((code & 0xff) < 0x21 || (code & 0xff) > 0x7e) {
                return null;
            }
            index = ((code >>> 8) - (_start[kind] >>> 8)) * 0x5e
                + ((code & 0xff) - (_start[kind] & 0xff));
        }

        byte[] b = new byte[ALTERNATION_TEXT_LENGTH];
        BookInputStream bis = _file.getInputStream();
        try {
            bis.seek(_page[kind], index * (ALTERNATION_TEXT_LENGTH + 1));
            bis.readFully(b, 0, b.length);
        } finally {
            bis.close();
        }

        try {
            ret = new String(b, "EUC-JP").trim();
            _cache[kind].put(new Integer(code), ret);
        } catch (UnsupportedEncodingException e) {
        }
        return ret;
    }

    /**
     * ܤ˥ȥåץɤޤޤƤ뤫ɤȽ̤ޤ
     *
     * @return ȥåץɤޤޤƤtrueǤʤfalse
     */
    public boolean hasStopCode() {
        if (_stopCode[0] == 0) {
            return false;
        }
        return true;
    }

    /**
     * ץ󥹤ȥåץɤɤȽǤޤ
     *
     * @param code0 0
     * @param code1 1
     * @return ȥåץɤξtrueǤʤfalse
     */
    public boolean isStopCode(int code0, int code1) {
        if (_stopCode[0] == code0 && _stopCode[1] == code1) {
            return true;
        }
        return false;
    }
}

// end of SubAppendix.java
