package fuku.eb4j;

import java.io.*;
import java.util.*;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.BookReader;
import fuku.eb4j.hook.Hook;
import fuku.eb4j.util.ByteUtil;

/**
 * ܥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class SubBook {

    /** ʣ縡٥Υǡ */
    private static final int SIZE_MULTI_LABEL = 30;
    /** ʣ縡ȥΥǡ */
    private static final int SIZE_MULTI_TITLE = 32;

    /** ̾ */
    private static final int KANA = 0;
    /**  */
    private static final int KANJI = 1;
    /** ե٥å */
    private static final int ALPHABET = 2;

    /**  */
    private Book _book = null;
    /** ܤбϿѥå */
    private SubAppendix _appendix = null;
    /** ܥǥ쥯ȥ̾ */
    private String _name = null;
    /** ưǥ쥯ȥ */
    private File _movieDir = null;

    /** ƥȥǡե */
    private EBFile _text = null;
    /** ǡե */
    private EBFile _graphic = null;
    /** ǡե */
    private EBFile _sound = null;

    /** ǥåڡ */
    private int _indexPage = 0;
    /** ȥڡ */
    private long _titlePage = 0L;

    /** ȥ */
    private String _title = null;
    /**  */
    private ExtFont[] _fonts = new ExtFont[4];
    /** γ */
    private int _fontIndex = -1;

    /** ʸѥǥå */
    private IndexStyle _textStyle = null;
    /** ѥǥå */
    private IndexStyle _soundStyle = null;

    /** ׸ѥǥå */
    private IndexStyle[] _wordStyle = new IndexStyle[3];
    /** ׸ѥǥå */
    private IndexStyle[] _endwordStyle = new IndexStyle[3];
    /** ︡ѥǥå */
    private IndexStyle _keywordStyle = null;
    /** ʣ縡ѥǥå */
    private IndexStyle[] _multiStyle = null;
    /** ʣ縡ȥѥǥå */
    private IndexStyle[][] _entryStyle = null;
    /** ˥塼ѥǥå */
    private IndexStyle _menuStyle = null;
    /** ѥǥå */
    private IndexStyle _copyrightStyle = null;

    /** ˡ֥ */
    private SearchMethod _searchMethod = null;


    /**
     * 󥹥ȥ饯
     *
     * @param book 
     * @param title ܤΥȥ
     * @param path ܤΥǥ쥯ȥ̾
     * @param index ܤΥǥåڡ
     * @param fname ǡե̾
     * @param format եޥåȷ
     * @param narrow Ⱦѳե̾
     * @param wide ѳե̾
     * @exception EBException եɤ߹˥顼ȯ
     */
    SubBook(Book book, String title, String path, int index,
            String[] fname, int[] format,
            String[] narrow, String[] wide) throws EBException {
        super();
        _book = book;
        _title = title;
        _indexPage = index;

        if (_book.getBookType() == Book.DISC_EB) {
            _setupEB(path, fname, format);
        } else {
            _setupEPWING(path, fname, format, narrow, wide);
        }

        _load();

        // Ⱦ/ξ¸ߤΤ
        int len = _fonts.length;
        for (int i=0; i<len; i++) {
            if (_fonts[i].hasNarrowFont() && _fonts[i].hasWideFont()) {
                _fontIndex = i;
                break;
            }
        }
        // Ⱦ/Ѥɤ餫¸ߤΤ
        if (_fontIndex < 0) {
            _fontIndex = 0;
            for (int i=0; i<len; i++) {
                if (_fonts[i].hasFont()) {
                    _fontIndex = i;
                    break;
                }
            }
        }
    }

    /**
     * ܤνǤΥѥꤷޤ
     *
     * @param path ѥ̾
     * @param fname ǡե̾
     * @param format եޥåȷ
     * @exception EBException ѥ˥顼ȯ
     */
    private void _setupEB(String path, String[] fname, int[] format) throws EBException {
        // 롼ȥǥ쥯ȥ
        File dir = EBFile.searchDirectory(_book.getPath(), path);
        _name = dir.getName();
        // ʸǡե
        _text = new EBFile(dir, fname[0], format[0]);
        // ǡե
        _graphic = _text;
    }

    /**
     * ܤνǤΥѥꤷޤ
     *
     * @param path ѥ̾
     * @param fname ǡե̾
     * @param format եޥåȷ
     * @exception EBException ѥ˥顼ȯ
     */
    private void _setupEPWING(String path, String[] fname, int[] format,
                              String[] narrow, String[] wide) throws EBException {
        // 롼ȥǥ쥯ȥ
        File dir = EBFile.searchDirectory(_book.getPath(), path);
        _name = dir.getName();

        // ǡǥ쥯ȥ
        File dataDir = EBFile.searchDirectory(dir, "data");
        // ʸǡե
        _text = new EBFile(dataDir, fname[0], format[0]);
        // ǡե
        if (fname[1] != null) {
            try {
                _graphic = new EBFile(dataDir, fname[1], format[1]);
            } catch (EBException e2) {
            }
        } else {
            _graphic = _text;
        }
        // ǡե
        if (fname[2] != null) {
            try {
                _sound = new EBFile(dataDir, fname[2], format[2]);
            } catch (EBException e2) {
            }
        } else {
            _sound = _text;
        }

        // ǡǥ쥯ȥ
        File gaijiDir = null;
        try {
            gaijiDir = EBFile.searchDirectory(dir, "gaiji");
        } catch (EBException e) {
        }
        // 
        EBFile file = null;
        int len = _fonts.length;
        for (int i=0; i<len; i++) {
            _fonts[i] = new ExtFont(this, i);
            if (gaijiDir != null) {
                if (narrow[i] != null) {
                    file = new EBFile(gaijiDir, narrow[i], EBFile.FORMAT_PLAIN);
                    _fonts[i].setNarrowFont(file, 1);
                }
                if (wide[i] != null) {
                    file = new EBFile(gaijiDir, wide[i], EBFile.FORMAT_PLAIN);
                    _fonts[i].setWideFont(file, 1);
                }
            }
        }

        // ưǡǥ쥯ȥ
        try {
            _movieDir = EBFile.searchDirectory(dir, "movie");
        } catch (EBException e) {
        }
    }

    /**
     * ܤξɤ߹ߤޤ
     *
     * @exception EBException եɤ߹˥顼ȯ
     */
    private void _load() throws EBException {
        byte[] b = new byte[BookInputStream.PAGE_SIZE];
        // ǥåơ֥ɤ߹
        BookInputStream bis = _text.getInputStream();
        try {
            bis.seek(_indexPage, 0);
            bis.readFully(b, 0, b.length);
        } finally {
            bis.close();
        }

        // ǥå
        int indexCount = b[1] & 0xff;
        if (indexCount >= BookInputStream.PAGE_SIZE/16-1) {
            throw new EBException(EBException.UNEXP_FILE, _text.getPath());
        }
        int avail1 = b[4] & 0xff;
        if (avail1 > 0x02) {
            avail1 = 0;
        }

        // EB
        int len = _fonts.length;
        long[][] fontPage = new long[len][2];
        for (int i=0; i<len; i++) {
            fontPage[i][0] = -1;
            fontPage[i][1] = -1;
        }
        // S-EBXA
        IndexStyle[] sebxa = new IndexStyle[2];

        // ǥåμ
        ArrayList multi = new ArrayList(indexCount);
        for (int i=0, off=16; i<indexCount; i++, off+=16) {
            IndexStyle style = new IndexStyle();
            int id = b[off] & 0xff;
            style.setIndexID(id);
            style.setStartPage(ByteUtil.getLong4(b, off+2));
            style.setEndPage(style.getStartPage()
                             + ByteUtil.getLong4(b, off+6) - 1);
            if (_book.getCharCode() == Book.CHARCODE_ISO8859_1
                || id == 0x72 || id == 0x92) {
                style.setSpaceStyle(IndexStyle.ASIS);
            }

            int avail2 = b[off+10] & 0xff;
            if ((avail1 == 0x00 && avail2 == 0x02) || avail1 == 0x02) {
                int flag = ByteUtil.getInt3(b, off+11);
                style.setKatakanaStyle((flag & 0xc00000) >>> 22);
                style.setLowerStyle((flag & 0x300000) >>> 20);
                if ((flag & 0x0c0000) >>> 18 == 0) {
                    style.setMarkStyle(IndexStyle.DELETE);
                } else {
                    style.setMarkStyle(IndexStyle.ASIS);
                }
                style.setLongVowelStyle((flag & 0x030000) >>> 16);
                style.setDoubleConsonantStyle((flag & 0x00c000) >>> 14);
                style.setContractedSoundStyle((flag & 0x003000) >>> 12);
                style.setSmallVowelStyle((flag & 0x000c00) >>> 10);
                style.setVoicedConsonantStyle((flag & 0x000300) >>> 8);
                style.setPSoundStyle((flag & 0x0000c0) >>> 6);
            } else if (id == 0x70 || id == 0x90) {
                style.setKatakanaStyle(IndexStyle.CONVERT);
                style.setLowerStyle(IndexStyle.CONVERT);
                style.setMarkStyle(IndexStyle.DELETE);
                style.setLongVowelStyle(IndexStyle.CONVERT);
                style.setDoubleConsonantStyle(IndexStyle.CONVERT);
                style.setContractedSoundStyle(IndexStyle.CONVERT);
                style.setSmallVowelStyle(IndexStyle.CONVERT);
                style.setVoicedConsonantStyle(IndexStyle.CONVERT);
                style.setPSoundStyle(IndexStyle.CONVERT);
            } else {
                style.setKatakanaStyle(IndexStyle.ASIS);
                style.setLowerStyle(IndexStyle.CONVERT);
                style.setMarkStyle(IndexStyle.ASIS);
                style.setLongVowelStyle(IndexStyle.ASIS);
                style.setDoubleConsonantStyle(IndexStyle.ASIS);
                style.setContractedSoundStyle(IndexStyle.ASIS);
                style.setSmallVowelStyle(IndexStyle.ASIS);
                style.setVoicedConsonantStyle(IndexStyle.ASIS);
                style.setPSoundStyle(IndexStyle.ASIS);
            }

            int idx;
            switch (style.getIndexID()) {
                case 0x00:
                    _textStyle = style;
                    break;
                case 0x01:
                    _menuStyle = style;
                    break;
                case 0x02:
                    _copyrightStyle = style;
                    break;
                case 0x16:
                    if (_book.getBookType() == Book.DISC_EPWING) {
                        _titlePage = style.getStartPage();
                    }
                    break;
                case 0x21:
                    if (_book.getBookType() == Book.DISC_EB) {
                        sebxa[1] = style;
                    }
                    break;
                case 0x22:
                    if (_book.getBookType() == Book.DISC_EB) {
                        sebxa[0] = style;
                    }
                    break;
                case 0x70:
                case 0x71:
                case 0x72:
                    idx = style.getIndexID() % 0x70;
                    _endwordStyle[idx] = style;
                    break;
                case 0x80:
                    _keywordStyle = style;
                    break;
                case 0x90:
                case 0x91:
                case 0x92:
                    idx = style.getIndexID() % 0x90;
                    _wordStyle[idx] = style;
                    break;
                case 0xd8:
                    _soundStyle = style;
                    break;
                case 0xf1:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[0][0] = style.getStartPage();
                    }
                    break;
                case 0xf2:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[0][1] = style.getStartPage();
                    }
                    break;
                case 0xf3:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[1][0] = style.getStartPage();
                    }
                    break;
                case 0xf4:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[1][1] = style.getStartPage();
                    }
                    break;
                case 0xf5:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[2][0] = style.getStartPage();
                    }
                    break;
                case 0xf6:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[2][1] = style.getStartPage();
                    }
                    break;
                case 0xf7:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[3][0] = style.getStartPage();
                    }
                    break;
                case 0xf8:
                    if (_book.getBookType() == Book.DISC_EB) {
                        fontPage[3][1] = style.getStartPage();
                    }
                    break;
                case 0xff:
                    multi.add(style);
                    break;
                default:
            }
        }
        if (!multi.isEmpty()) {
            _multiStyle = (IndexStyle[])multi.toArray(new IndexStyle[0]);
            _loadMulti();
            _loadMultiTitle();
        }

        if (_book.getBookType() == Book.DISC_EB) {
            if (_text.getFormat() == EBFile.FORMAT_PLAIN
                && sebxa[0] != null && sebxa[1] != null
                && _textStyle.getStartPage() != 0
                && sebxa[0].getStartPage() != 0
                && sebxa[1].getStartPage() != 0) {
                long index = (sebxa[0].getStartPage() - 1) * BookInputStream.PAGE_SIZE;
                long base = (sebxa[1].getStartPage() - 1) * BookInputStream.PAGE_SIZE;
                long start = (_textStyle.getStartPage() - 1) * BookInputStream.PAGE_SIZE;
                long end = (_textStyle.getEndPage() * BookInputStream.PAGE_SIZE - 1);
                // S-EBXA
                _text.setSEBXAInfo(index, base, start, end);
            }
            // ե
            for (int i=0; i<len; i++) {
                _fonts[i] = new ExtFont(this, i);
                long page = fontPage[i][0];
                if (page < 0) {
                    _fonts[i].setWideFont(_text, page);
                }
                page = fontPage[i][1];
                if (page < 0) {
                    _fonts[i].setNarrowFont(_text, page);
                }
            }
        }
    }

    /**
     * ܤʣ縡ɤ߹ߤޤ
     *
     * @exception EBException եɤ߹˥顼ȯ
     */
    private void _loadMulti() throws EBException {
        int len = _multiStyle.length;
        _entryStyle = new IndexStyle[len][];
        ArrayList list = new ArrayList(len*4);
        byte[] b = new byte[BookInputStream.PAGE_SIZE];
        BookInputStream bis = _text.getInputStream();
        try {
            for (int i=0; i<len; i++) {
                // ǥåơ֥ɤ߹
                bis.seek(_multiStyle[i].getStartPage(), 0);
                bis.readFully(b, 0, b.length);

                // ȥμ
                int entryCount = ByteUtil.getInt2(b, 0);
                if (entryCount <= 0) {
                    throw new EBException(EBException.UNEXP_FILE, _text.getPath());
                }

                int off = 16;
                for (int j=0; j<entryCount; j++) {
                    IndexStyle style = new IndexStyle();
                    style.setSpaceStyle(IndexStyle.ASIS);
                    style.setKatakanaStyle(IndexStyle.ASIS);
                    style.setLowerStyle(IndexStyle.ASIS);
                    style.setMarkStyle(IndexStyle.ASIS);
                    style.setLongVowelStyle(IndexStyle.ASIS);
                    style.setDoubleConsonantStyle(IndexStyle.ASIS);
                    style.setContractedSoundStyle(IndexStyle.ASIS);
                    style.setVoicedConsonantStyle(IndexStyle.ASIS);
                    style.setSmallVowelStyle(IndexStyle.ASIS);
                    style.setPSoundStyle(IndexStyle.ASIS);
                    // ȥΥǥå
                    int indexCount = b[off] & 0xff;
                    // ȥΥ٥
                    String label = ByteUtil.jisx0208ToString(b, off+2, SIZE_MULTI_LABEL);
                    style.setLabel(label);
                    off += 2 + SIZE_MULTI_LABEL;
                    for (int k=0; k<indexCount; k++) {
                        // ǥåڡξ
                        int indexID = b[off] & 0xff;
                        long page = ByteUtil.getLong4(b, off+2);
                        switch (indexID) {
                            case 0x71:
                            case 0x91:
                            case 0xa1:
                                if (style.getStartPage() != 0
                                    && style.getIndexID() != 0x71) {
                                    break;
                                }
                                style.setIndexID(indexID);
                                style.setStartPage(page);
                                page += ByteUtil.getLong4(b, off+6) - 1;
                                style.setEndPage(page);
                                break;
                            case 0x01:
                                style.setIndexID(indexID);
                                style.setCandidatePage(page);
                                break;
                            default:
                        }
                        off += 16;
                    }
                    list.add(style);
                }
                _entryStyle[i] = (IndexStyle[])list.toArray(new IndexStyle[0]);
                list.clear();
            }
        } finally {
            bis.close();
        }
    }

    /**
     * ܤʣ縡Υȥɤ߹ߤޤ
     *
     * @exception EBException եɤ߹˥顼ȯ
     */
    private void _loadMultiTitle() throws EBException {
        // ǥեȥȥ
        int len = _multiStyle.length;
        if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
            for (int i=0; i>len; i++) {
                String num = Integer.toString(i+1);
                _multiStyle[i].setLabel("Multi search " + num);
            }
        } else {
            for (int i=0; i<len; i++) {
                String num = ByteUtil.narrowToWide(Integer.toString(i+1));
                _multiStyle[i].setLabel("ʣ縡" + num);
            }
        }

        if (_book.getBookType() != Book.DISC_EPWING || _titlePage == 0) {
            return;
        }

        // ȥڡɤ߹
        byte[] b = new byte[BookInputStream.PAGE_SIZE];
        BookInputStream bis = _text.getInputStream();
        try {
            bis.seek(_titlePage, 0);
            bis.readFully(b, 0, b.length);
        } finally {
            bis.close();
        }

        int titleCount = ByteUtil.getInt2(b, 0);
        if (titleCount > _multiStyle.length + 4) {
            titleCount = _multiStyle.length + 4;
        }
        /*
         * ʣ縡ΥȥΤɬ
         *     titles[ 0]: /׸Υȥ
         *     titles[ 1]: ︡Υȥ
         *     titles[ 2]: ʣ縡ζ̥ȥ
         *     titles[ 3]: ʣ縡1Υȥ
         *         :
         *     titles[12]: ʣ縡10Υȥ
         *     titles[13]: ˥塼Υȥ
         *
         * titles[3]Υեå:
         *     ȥ (2bytes)
         *     + ͽ1 (68bytes)
         *     + /׸Υȥ (70bytes)
         *     + ︡Υȥ (70bytes)
         *     + ʣ縡ζ̥ȥ (70bytes)
         *     + ͽ2 (70bytes)
         *     = 2 + 68 + 70 + 70 + 70 + 70 = 350
         */
        int off = 350;
        for (int i=4; i<titleCount; i++) {
            if (ByteUtil.getInt2(b, off) != 0x02) {
                continue;
            }
            /*
             * titles[]
             *    ѥ᡼ (2bytes)
             *    ûȥ (16bytes)
             *    Ĺȥ (32bytes)
             */
            String title =
                ByteUtil.jisx0208ToString(b, off+18, SIZE_MULTI_TITLE);
            _multiStyle[i-4].setLabel(title);
            off += 70;
        }
    }

    /**
     * ܤޤޤҤ֤ޤ
     *
     * @return 
     */
    public Book getBook() {
        return _book;
    }

    /**
     * ܤбϿѥåꤷޤ
     *
     * @param appendix Ͽѥå
     */
    void setAppendix(SubAppendix appendix) {
        _appendix = appendix;
    }

    /**
     * ܤбϿѥå֤ޤ
     *
     * @return Ͽѥå
     */
    public SubAppendix getAppendix() {
        return _appendix;
    }

    /**
     * ܤΥȥ֤ޤ
     *
     * @return ȥ
     */
    public String getTitle() {
        return _title;
    }

    /**
     * ܤΥǥ쥯ȥ֤̾ޤ
     *
     * @return ܤΥǥ쥯ȥ̾
     */
    public String getName() {
        return _name;
    }

    /**
     * ꤵƤ륵γ֤ޤ
     *
     * @return 
     */
    public ExtFont getFont() {
        return _fonts[_fontIndex];
    }

    /**
     * ꤵ줿γ֤ޤ
     *
     * @param type μ
     * @return 
     * @see ExtFont#FONT_16
     * @see ExtFont#FONT_24
     * @see ExtFont#FONT_30
     * @see ExtFont#FONT_48
     * @exception IllegalArgumentException μबʾ
     */
    public ExtFont getFont(int type) {
        if (type < ExtFont.FONT_16 || type > ExtFont.FONT_48) {
            throw new IllegalArgumentException("Illegal font type: "
                                               + Integer.toString(type));
        }
        return _fonts[type];
    }

    /**
     * Ѥ볰ꤵ줿ꤷޤ
     *
     * @param type μ
     * @see ExtFont#FONT_16
     * @see ExtFont#FONT_24
     * @see ExtFont#FONT_30
     * @see ExtFont#FONT_48
     * @exception IllegalArgumentException μबʾ
     */
    public void setFont(int type) {
        if (type < ExtFont.FONT_16 || type > ExtFont.FONT_48) {
            throw new IllegalArgumentException("Illegal font type: "
                                               + Integer.toString(type));
        }
        _fontIndex = type;
    }

    /**
     * ܤβǡ֤ޤ
     *
     * @return ǡ
     */
    public BinaryData getGraphicData() {
        return new BinaryData(_graphic, null);
    }

    /**
     * ܤβǡ֤ޤ
     *
     * @return ǡ
     */
    public BinaryData getSoundData() {
        return new BinaryData(_sound, _soundStyle);
    }

    /**
     * ܤʸե֤ޤ
     *
     * @return ʸե
     */
    public EBFile getTextFile() {
        return _text;
    }

    /**
     * ܤβե֤ޤ
     *
     * @return ե
     */
    public EBFile getGraphicFile() {
        return _graphic;
    }

    /**
     * ܤβե֤ޤ
     *
     * @return ե
     */
    public EBFile getSoundFile() {
        return _sound;
    }

    /**
     * ưեΥꥹȤ֤ޤ
     *
     * @return ưեΥꥹ
     */
    public File[] getMovieFileList() {
        if (_movieDir == null) {
            return null;
        }
        return _movieDir.listFiles();
    }

    /**
     * ưե֤ޤ
     *
     * @param name ե̾
     * @return ưե
     */
    public File getMovieFile(String name) {
        if (_movieDir == null) {
            return null;
        }
        File file = null;
        try {
            EBFile ebfile = new EBFile(_movieDir, name, EBFile.FORMAT_PLAIN);
            file = ebfile.getFile();
        } catch (EBException e) {
        }
        return file;
    }

    /**
     * ֤θФ֤ޤ
     *
     * @param result 
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     * @exception EBException եɤ߹˥顼ȯ
     */
    public Object getHeading(Result result, Hook hook) throws EBException {
        return getHeading(result.getHeadingPosition(), hook);
    }

    /**
     * ֤θФ֤ޤ
     *
     * @param pos ǡ
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     * @exception EBException եɤ߹˥顼ȯ
     */
    public Object getHeading(long pos, Hook hook) throws EBException {
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readHeading(pos);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /**
     * ֤μθФ֤֤ޤ
     *
     * @param pos ǡ
     * @return θФ
     * @exception EBException եɤ߹˥顼ȯ
     */
    long getNextHeadingPosition(long pos) throws EBException {
        BookReader reader = null;
        long nextPos = 0L;
        try {
            reader = new BookReader(this, null);
            nextPos = reader.nextHeadingPosition(pos);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return nextPos;
    }

    /**
     * ֤ʸ֤ޤ
     *
     * @param result 
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     * @exception EBException եɤ߹˥顼ȯ
     */
    public Object getText(Result result, Hook hook) throws EBException {
        return getText(result.getTextPosition(), hook);
    }

    /**
     * ֤ʸ֤ޤ
     *
     * @param pos ǡ
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     * @exception EBException եɤ߹˥顼ȯ
     */
    public Object getText(long pos, Hook hook) throws EBException {
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readText(pos);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /**
     * ܤΥ˥塼ɽ֤ޤ
     *
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     *         (˥塼ɽݡȤƤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     */
    public Object getMenu(Hook hook) throws EBException {
        if (!hasMenu()) {
            return null;
        }
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readText(_menuStyle.getStartPage(), 0);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /**
     * ܤɽ֤ޤ
     *
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     *         (ɽݡȤƤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     */
    public Object getCopyright(Hook hook) throws EBException {
        if (!hasCopyright()) {
            return null;
        }
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readText(_copyrightStyle.getStartPage(), 0);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /**
     * θ̤֤ޤ
     *
     * @return  (θ̤ʤnull)
     * @exception EBException ˥顼ȯ
     */
    public Result getNextResult() throws EBException {
        if (_searchMethod == null) {
            return null;
        }
        return _searchMethod.getNextResult();
    }

    /**
     * ꤵ줿Хʸ̤֤ޤ
     *
     * @param b Х
     * @return ʸ
     */
    private int _getWordType(byte[] b) {
        boolean alphabet = false;
        boolean kana = false;
        boolean kanji = false;
        int len = b.length;
        for (int i=0; i<len; i+=2) {
            if (b[i] == 0x23) {
                alphabet = true;
            } else if (b[i] == 0x24 || b[i] == 0x25) {
                kana = true;
            } else if (b[i] != 0x21) {
                kanji = true;
            }
        }
        if (alphabet && !kana && !kanji) {
            return ALPHABET;
        } else if (!alphabet && kana && !kanji) {
            return KANA;
        } else {
            return KANJI;
        }
    }

    /**
     * ׸Ԥޤ
     *
     * @param word 
     * @exception EBException ˥顼ȯ
     */
    public void searchExactword(String word) throws EBException {
        if (!hasWordSearch() || word == null || word.trim().length() <= 0) {
            _searchMethod = null;
            return;
        }

        byte[] b = null;
        int type = ALPHABET;
        if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
            b = word.getBytes();
        } else {
            b = ByteUtil.stringToJISX0208(word);
            type = _getWordType(b);
            if (_wordStyle[type] == null) {
                type = KANJI;
            }
        }
        SearchSingle method =
            new SearchSingle(this, _wordStyle[type], SearchSingle.EXACTWORD);
        method.search(b);
        _searchMethod = method;
    }

    /**
     * ׸Ԥޤ
     *
     * @param word 
     * @exception EBException ˥顼ȯ
     */
    public void searchWord(String word) throws EBException {
        if (!hasWordSearch() || word == null || word.trim().length() <= 0) {
            _searchMethod = null;
            return;
        }

        byte[] b = null;
        int type = ALPHABET;
        if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
            b = word.trim().getBytes();
        } else {
            b = ByteUtil.stringToJISX0208(word);
            type = _getWordType(b);
            if (_wordStyle[type] == null) {
                type = KANJI;
            }
        }
        SearchSingle method =
            new SearchSingle(this, _wordStyle[type], SearchSingle.WORD);
        method.search(b);
        _searchMethod = method;
    }

    /**
     * ׸Ԥޤ
     *
     * @param word 
     * @exception EBException ˥顼ȯ
     */
    public void searchEndword(String word) throws EBException {
        if (!hasEndwordSearch() || word == null || word.trim().length() <= 0) {
            _searchMethod = null;
            return;
        }

        byte[] b = null;
        int type = ALPHABET;
        if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
            b = word.trim().getBytes();
        } else {
            b = ByteUtil.stringToJISX0208(word);
            type = _getWordType(b);
            if (_wordStyle[type] == null) {
                type = KANJI;
            }
        }
        SearchSingle method =
            new SearchSingle(this, _endwordStyle[type], SearchSingle.ENDWORD);
        method.search(b);
        _searchMethod = method;
    }

    /**
     * ︡Ԥޤ
     *
     * @param word 
     * @exception EBException ˥顼ȯ
     */
    public void searchKeyword(String[] word) throws EBException {
        if (!hasKeywordSearch()) {
            _searchMethod = null;
            return;
        }

        int len = word.length;
        byte[][] b = new byte[len][];
        if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
            for (int i=0; i<len; i++) {
                b[i] = word[i].trim().getBytes();
            }
        } else {
            for (int i=0; i<len; i++) {
                b[i] = ByteUtil.stringToJISX0208(word[i]);
            }
        }
        SearchMultiple method = new SearchMultiple(this, _keywordStyle);
        method.search(b);
        _searchMethod = method;
    }

    /**
     * ʣ縡Ԥޤ
     *
     * @param multiIndex ʣ縡Υǥå
     * @param word 
     *             (ޤޤϳ"\####"Τ褦"\"ǥפʸɤ򵭽Ҥ뤳)
     * @exception EBException ˥顼ȯ
     * @exception IllegalArgumentException ͤʾ
     */
    public void searchMulti(int multiIndex, String[] word) throws EBException {
        if (!hasMultiSearch()) {
            _searchMethod = null;
            return;
        }

        int len = word.length;

        if (multiIndex < 0 || multiIndex >= _multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: "
                                               + Integer.toString(multiIndex));
        }
        if (_entryStyle[multiIndex].length < len) {
            throw new IllegalArgumentException("Too many words: "
                                               + Integer.toString(len));
        }

        byte[][] b = new byte[len][];
        ArrayList list = new ArrayList(4);
        for (int i=0; i<len; i++) {
            list.clear();
            String key = word[i].trim();
            int length = key.length();
            int size = 0;
            int idx1 = 0;
            int idx2 = key.indexOf('\\', 0);
            String str = null;
            byte[] tmp = null;
            while (idx2 >= 0) {
                if (idx1 < idx2) {
                    str = key.substring(idx1, idx2);
                    if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
                        tmp = str.getBytes();
                    } else {
                        tmp = ByteUtil.stringToJISX0208(str);
                    }
                    size += tmp.length;
                    list.add(tmp);
                }

                int idx3 = idx2 + 5;
                if (idx3 > length) {
                    idx3 = length;
                }
                str = key.substring(idx2+1, idx3);
                int code = -1;
                // 4ʸʲ16ʿʸʸ
                for (int j=4; j>0; j--) {
                    try {
                        code = Integer.parseInt(str, 16);
                        idx1 = idx2 + 1 + j;
                        break;
                    } catch (NumberFormatException e) {
                        str = str.substring(0, j-1);
                    }
                }
                if (code >= 0) {
                    tmp = new byte[2];
                    tmp[0] = (byte)((code >>> 8) & 0xff);
                    tmp[1] = (byte)(code & 0xff);
                } else {
                    tmp = new byte[1];
                    tmp[0] = '\\';
                    idx1 = idx2 + 1;
                }
                size += tmp.length;
                list.add(tmp);

                idx2 = key.indexOf('\\', idx1);
            }
            if (idx1 < length) {
                str = key.substring(idx1, length);
                if (_book.getCharCode() == Book.CHARCODE_ISO8859_1) {
                    tmp = str.getBytes();
                } else {
                    tmp = ByteUtil.stringToJISX0208(str);
                }
                size += tmp.length;
                list.add(tmp);
            }
            b[i] = new byte[size];
            int pos = 0;
            int num = list.size();
            for (int j=0; j<num; j++) {
                tmp = (byte[])list.get(j);
                System.arraycopy(tmp, 0, b[i], pos, tmp.length);
                pos += tmp.length;
            }
        }
        SearchMultiple method = new SearchMultiple(this,
                                                   _multiStyle[multiIndex],
                                                   _entryStyle[multiIndex]);
        method.search(b);
        _searchMethod = method;
    }

    /**
     * ܤ˥塼򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ˥塼򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasMenu() {
        if (_menuStyle == null || _menuStyle.getStartPage() == 0) {
            return false;
        }
        return true;
    }

    /**
     * ܤɽ򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ɽ򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasCopyright() {
        if (_copyrightStyle == null || _copyrightStyle.getStartPage() == 0) {
            return false;
        }
        return true;
    }

    /**
     * ܤ׸򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ׸򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasExactwordSearch() {
        return hasWordSearch();
    }

    /**
     * ܤ׸򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ׸򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasWordSearch() {
        if (_wordStyle == null) {
            return false;
        }
        int len = _wordStyle.length;
        for (int i=0; i<len; i++) {
            if (_wordStyle[i] != null && _wordStyle[i].getStartPage() > 0) {
                return true;
            }
        }
        return false;
    }

    /**
     * ܤ׸򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ׸򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasEndwordSearch() {
        if (_endwordStyle == null) {
            return false;
        }
        int len = _endwordStyle.length;
        for (int i=0; i<len; i++) {
            if (_endwordStyle[i] != null && _endwordStyle[i].getStartPage() > 0) {
                return true;
            }
        }
        return false;
    }

    /**
     * ܤ︡򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ︡򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasKeywordSearch() {
        if (_keywordStyle == null || _keywordStyle.getStartPage() == 0) {
            return false;
        }
        return true;
    }

    /**
     * ܤʣ縡򥵥ݡȤƤ뤫ɤȽ̤ޤ
     *
     * @return ʣ縡򥵥ݡȤƤtrueǤʤfalse
     */
    public boolean hasMultiSearch() {
        if (_multiStyle == null) {
            return false;
        }
        return true;
    }

    /**
     * ʣ縡ο֤ޤ
     *
     * @return ʣ縡
     */
    public int getMultiCount() {
        if (_multiStyle == null) {
            return 0;
        }
        return _multiStyle.length;
    }

    /**
     * ꤵ줿ʣ縡Υȥ֤ޤ
     *
     * @param multiIndex ʣ縡Υǥå
     * @return ʣ縡Υȥ
     * @exception IllegalArgumentException ǥåͤʾ
     */
    public String getMultiTitle(int multiIndex) {
        if (_multiStyle == null) {
            return null;
        }
        if (multiIndex < 0 || multiIndex >= _multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: "
                                               + Integer.toString(multiIndex));
        }
        return _multiStyle[multiIndex].getLabel();
    }

    /**
     * ꤵ줿ʣ縡Υȥ֤ޤ
     *
     * @param multiIndex ʣ縡Υǥå
     * @return ȥ
     * @exception IllegalArgumentException ǥåͤʾ
     */
    public int getMultiEntryCount(int multiIndex) {
        if (_multiStyle == null) {
            return 0;
        }
        if (multiIndex < 0 || multiIndex >= _multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: "
                                               + Integer.toString(multiIndex));
        }
        return _entryStyle[multiIndex].length;
    }

    /**
     * ꤵ줿ȥΥ٥֤ޤ
     *
     * @param multiIndex ʣ縡Υǥå
     * @param entryIndex ȥΥǥå
     * @return ȥΥ٥
     * @exception IllegalArgumentException ǥåͤʾ
     */
    public String getMultiEntryLabel(int multiIndex, int entryIndex) {
        if (_multiStyle == null || _entryStyle == null) {
            return null;
        }
        if (multiIndex < 0 || multiIndex >= _multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: "
                                               + Integer.toString(multiIndex));
        }
        if (entryIndex < 0 || entryIndex >= _entryStyle[multiIndex].length) {
            throw new IllegalArgumentException("Illegal entry index: "
                                               + Integer.toString(entryIndex));
        }
        return _entryStyle[multiIndex][entryIndex].getLabel();
    }

    /**
     * ܤλꤵ줿ȥθ֤ޤ
     *
     * @param multiIndex ʣ縡Υǥå
     * @param entryIndex ȥΥǥå
     * @param hook եå (nullξϥǥեȤΥեå)
     * @return եåˤäƲù줿֥
     *         (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     * @exception IllegalArgumentException ǥåͤʾ
     */
    public Object getCandidate(int multiIndex, int entryIndex,
                               Hook hook) throws EBException {
        if (!hasMultiEntryCandidate(multiIndex, entryIndex)) {
            return null;
        }
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            long page = _entryStyle[multiIndex][entryIndex].getCandidatePage();
            obj = reader.readText(page, 0);
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /**
     * ꤵ줿ȥ˸䤬뤫ɤȽ̤ޤ
     *
     * @param multiIndex ʣ縡Υǥå
     * @param entryIndex ȥΥǥå
     * @return ȥ˸䤬trueǤʤfalse
     * @exception IllegalArgumentException ǥåͤʾ
     */
    public boolean hasMultiEntryCandidate(int multiIndex, int entryIndex) {
        if (_multiStyle == null || _entryStyle == null) {
            return false;
        }
        if (multiIndex < 0 || multiIndex >= _multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: "
                                               + Integer.toString(multiIndex));
        }
        if (entryIndex < 0 || entryIndex >= _entryStyle[multiIndex].length) {
            throw new IllegalArgumentException("Illegal entry index: "
                                               + Integer.toString(entryIndex));
        }
        if (_entryStyle[multiIndex][entryIndex].getCandidatePage() > 0) {
            return true;
        }
        return false;
    }

    /**
     * Υ饹ʸɽ(ܤΥȥ)֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        return getTitle();
    }
}

// end of SubBook.java
