package fuku.eb4j.io;

import java.io.*;

import fuku.eb4j.EBException;

/**
 * ե뤪ӥǥ쥯ȥɽ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class EBFile {

    /** PLAIN */
    public static final int FORMAT_PLAIN = 0;
    /** EBZIP */
    public static final int FORMAT_EBZIP = 1;
    /** EPWING V4/V5 */
    public static final int FORMAT_EPWING = 2;
    /** EPWING V6 */
    public static final int FORMAT_EPWING6 = 3;
    /** S-EBXA */
    public static final int FORMAT_SEBXA = 4;

    /** ե */
    private FileInfo _info = null;
    /** ꥸʥե̾ */
    private String _name = null;


    /**
     * 󥹥ȥ饯
     *
     * @param parent ƥǥ쥯ȥ
     * @param name ե̾
     * @param defaultFormat ǥեȤΥեޥåȷ
     * @exception EBException ե뤬¸ߤʤ
     * @see EBFile#FORMAT_PLAIN
     * @see EBFile#FORMAT_EBZIP
     * @see EBFile#FORMAT_EPWING
     * @see EBFile#FORMAT_EPWING6
     */
    public EBFile(File parent, String name,
                  int defaultFormat) throws EBException {
        super();
        _info = new FileInfo();

        String ebzName = name + ".ebz";
        String orgName = name + ".org";
        String[] list = parent.list();
        if (list != null) {
            int len = list.length;
            for (int i=0; i<len; i++) {
                File f = new File(parent, list[i]);
                if (f.isDirectory()) {
                    continue;
                }
                if (list[i].compareToIgnoreCase(name) == 0) {
                    _info.file = f;
                    _info.format = defaultFormat;
                    _name = list[i];
                    break;
                } else if (list[i].compareToIgnoreCase(orgName) == 0) {
                    _info.file = f;
                    _info.format = FORMAT_PLAIN;
                    _name = list[i].substring(0, list[i].length() - 4);
                    break;
                } else if (list[i].compareToIgnoreCase(ebzName) == 0) {
                    _info.file = f;
                    _info.format = FORMAT_EBZIP;
                    _name = list[i].substring(0, list[i].length() - 4);
                    break;
                }
            }
        }
        if (_info.file == null) {
            throw new EBException(EBException.FILE_NOT_FOUND, parent.getPath(), name);
        }
        if (!_info.file.canRead()) {
            throw new EBException(EBException.CANT_READ_FILE, _info.file.getPath());
        }
    }


    /**
     * ꤵ줿ƥǥ쥯ȥ⤫ꤵ줿ǥ쥯ȥ
     * ʸ/ʸζ̤ʤޤ
     *
     * @param parent ƥǥ쥯ȥ
     * @param name ǥ쥯ȥ̾
     * @exception EBException ե뤬¸ߤʤ
     */
    public static File searchDirectory(String parent, String name) throws EBException {
        return searchDirectory(new File(parent), name);
    }

    /**
     * ꤵ줿ƥǥ쥯ȥ⤫ꤵ줿ǥ쥯ȥ
     * ʸ/ʸζ̤ʤޤ
     *
     * @param parent ƥǥ쥯ȥ
     * @param name ǥ쥯ȥ̾
     * @exception EBException ե뤬¸ߤʤ
     */
    public static File searchDirectory(File parent, String name) throws EBException {
        String[] list = parent.list();
        File dir = null;
        if (list != null) {
            int len = list.length;
            for (int i=0; i<len; i++) {
                File f = new File(parent, list[i]);
                if (!f.isDirectory()) {
                    continue;
                }
                if (list[i].compareToIgnoreCase(name) == 0) {
                    dir = f;
                    break;
                }
            }
        }
        if (dir == null) {
            throw new EBException(EBException.DIR_NOT_FOUND, parent.getPath(), name);
        }
        if (!dir.canRead()) {
            throw new EBException(EBException.CANT_READ_DIR, dir.getPath());
        }
        return dir;
    }

    /**
     * Υ֥ȤΥե֤ޤ
     *
     * @return ե
     */
    public File getFile() {
        return _info.file;
    }

    /**
     * ΥեΥѥ֤̾ޤ
     *
     * @return եΥѥ̾
     */
    public String getPath() {
        return _info.file.getPath();
    }

    /**
     * ΥեΥꥸʥ֤̾ޤ
     *
     * @return ꥸʥե̾
     */
    public String getName() {
        return _name;
    }

    /**
     * ΥեΥեޥåȷ֤ޤ
     *
     * @return եޥåȷ
     * @see EBFile#FORMAT_PLAIN
     * @see EBFile#FORMAT_EBZIP
     * @see EBFile#FORMAT_EPWING
     * @see EBFile#FORMAT_EPWING6
     */
    public int getFormat() {
        return _info.format;
    }

    /**
     * S-EBXAΰ̾ꤷޤ
     *
     * @param index ʸǡǥåϰ
     * @param base ʸǡϰ
     * @param start ʸϰ
     * @param end ʸλ
     */
    public void setSEBXAInfo(long index, long base, long start, long end) {
        _info.sebxaIndexPos = index;
        _info.sebxaBasePos = base;
        _info.sebxaStartPos = start;
        _info.sebxaEndPos = end;
        _info.fileSize = end;
        _info.format = FORMAT_SEBXA;
    }

    /**
     * ΥեΥǡɤ߹ߥȥ꡼֤ޤ
     *
     * @return ǡɤ߹ߥȥ꡼ (ǥ쥯ȥξnull)
     * @exception EBException ϥ顼ȯ
     */
    public BookInputStream getInputStream() throws EBException {
        BookInputStream bis = null;
        switch (_info.format) {
            case FORMAT_EBZIP:
                bis = new EBZipInputStream(_info);
                break;
            case FORMAT_EPWING:
            case FORMAT_EPWING6:
                bis = new EPWINGInputStream(_info);
                break;
            case FORMAT_SEBXA:
                bis = new SEBXAInputStream(_info);
                break;
            case FORMAT_PLAIN:
            default:
                bis = new PlainInputStream(_info);
        }
        return bis;
    }
}

// end of EBFile.java
