package fuku.eb4j.io;

import java.io.*;

import fuku.eb4j.EBException;
import fuku.eb4j.util.ByteUtil;

/**
 * S-EBXAνϥȥ꡼९饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class SEBXAInputStream extends BookInputStream {

    /** S-EBXA饤 */
    private static final int SEBXA_SLICE_SIZE = 4096;


    /**
     * 󥹥ȥ饯
     *
     * @param info ե
     * @exception EBException ϥ顼ȯ
     */
    SEBXAInputStream(FileInfo info) throws EBException {
        super(info);
        open();
        synchronized (info) {
            if (info.realFileSize <= 0) {
                try {
                    info.realFileSize = _stream.length();
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_READ_FILE, info.file.getPath(), e);
                }
            }
        }
        _cache = new byte[PAGE_SIZE];
    }


    /**
     * S-EBXAΥե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            if (_info.fileSize <= _filePos) {
                // ȥ꡼ν
                if (rlen == 0) {
                    // ǡɤ߹Ǥʤ-1
                    return -1;
                } else {
                    // ǡɤ߹ǤХХȿ֤
                    return rlen;
                }
            }
            if (_filePos < _info.sebxaStartPos) {
                // ǡ֤ʸǡ
                int n = 0;
                if (_info.sebxaStartPos - _filePos < len - rlen) {
                    n = (int)(_info.sebxaStartPos - _filePos);
                } else {
                    n = len - rlen;
                }
                try {
                    _stream.seek(_filePos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE, _info.file.getPath(), e);
                }
                n = readRaw(b, off+rlen, n);
                rlen += n;
                _filePos += n;
            } else if (_filePos >= _info.sebxaEndPos) {
                // ǡ֤ʸǡθ
                try {
                    _stream.seek(_filePos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE, _info.file.getPath(), e);
                }
                readRawFully(b, off+rlen, len-rlen);
                _filePos = _filePos + (len - rlen);
                rlen = len;
            } else {
                // ǡ֤ʸǡ
                if (_cachePos < 0
                    || _filePos < _cachePos
                    || _cachePos + SEBXA_SLICE_SIZE <= _filePos) {
                    // åΥǡ
                    // _filePosΰ֤ޤޤ륹饤Ƭ
                    _cachePos = _filePos - (_filePos % SEBXA_SLICE_SIZE);

                    // ǡΰ
                    long sliceIndex = (_filePos - _info.sebxaStartPos) / SEBXA_SLICE_SIZE;
                    long slicePos = 0;
                    if (sliceIndex == 0) {
                        slicePos = _info.sebxaBasePos;
                    } else {
                        long pos = (sliceIndex - 1) * 4 + _info.sebxaIndexPos;
                        try {
                            _stream.seek(pos);
                        } catch (IOException e) {
                            throw new EBException(EBException.FAILED_SEEK_FILE, _info.file.getPath(), e);
                        }
                        byte[] tmp = new byte[4];
                        readRawFully(tmp, 0, tmp.length);
                        slicePos = _info.sebxaBasePos + ByteUtil.getLong4(tmp, 0);
                    }
                    // 饤ǥɤƥåɤ߹
                    try {
                        _stream.seek(slicePos);
                    } catch (IOException e) {
                        throw new EBException(EBException.FAILED_SEEK_FILE, _info.file.getPath(), e);
                    }
                    _decode();
                }

                // å夫ǡμ
                int n = (int)(SEBXA_SLICE_SIZE - (_filePos % SEBXA_SLICE_SIZE));
                if (len - rlen < n) {
                    n = len - rlen;
                }
                if (_info.fileSize - _filePos < n) {
                    n = (int)(_info.fileSize - _filePos);
                }
                int p = (int)(_filePos - _cachePos);
                System.arraycopy(_cache, p, b, off+rlen, n);
                rlen += n;
                _filePos += n;
            }
        }
        return rlen;
    }

    /**
     * 沽ޤ
     *
     * @exception EBException ϥ顼ȯ
     */
    private void _decode() throws EBException {
        int inRest = 0;
        int inOff = 0;
        int outLen = 0;
        int outOff = 0;
        byte[] b = new byte[SEBXA_SLICE_SIZE];
        int len = 8;
        boolean[] flags = new boolean[len];
        boolean loop = true;
        while (loop) {
            if (inRest <= 0) {
                // Хåե˥ǡɤ߹
                inRest = readRaw(b, 0, b.length);
                if (inRest <= 0) {
                    throw new EBException(EBException.FAILED_SEEK_FILE, _info.file.getPath());
                }
                inOff = 0;
            }
            // ̥ե饰
            int mask = 0x01;
            for (int i=0; i<len; i++) {
                if ((b[inOff] & mask) == 0) {
                    flags[i] = true;
                } else {
                    flags[i] = false;
                }
                mask = mask << 1;
            }
            inOff++;
            inRest--;
            // ĥ
            for (int i=0; i<len; i++) {
                if (flags[i]) {
                    if (inRest <= 1) {
                        throw new EBException(EBException.FAILED_SEEK_FILE, _info.file.getPath());
                    }
                    int c0 = b[inOff] & 0xff;
                    int c1 = b[inOff+1] & 0xff;
                    int copyOff = (((c1 & 0xf0) << 4) + c0 + 18) % SEBXA_SLICE_SIZE;
                    int copyLen = (c1 & 0x0f) + 3;
                    if (outLen + copyLen > SEBXA_SLICE_SIZE) {
                        copyLen = SEBXA_SLICE_SIZE - outLen;
                    }
                    if (copyOff < outLen) {
                        for (int j=0; j<copyLen; j++) {
                            _cache[outOff++] = b[copyOff++];
                        }
                    } else {
                        for (int j=0; j<copyLen; j++) {
                            _cache[outOff++] = 0x00;
                        }
                    }
                    inRest -= 2;
                    inOff += 2;
                    outLen = outLen + copyLen;
                } else {
                    // ̤Ƥʤ
                    if (inRest <= 0) {
                    }
                    inRest--;
                    _cache[outOff++] = b[inOff++];
                    outLen++;
                }

                // 饤򤹤٤ƿĥ齪λ
                if (outLen >= SEBXA_SLICE_SIZE) {
                    loop = false;
                    break;
                }
            }
        }
    }
}

// end of SEBXAInputStream.java
